#ifndef _KVI_IRCSERVER_H_INCLUDED_
#define _KVI_IRCSERVER_H_INCLUDED_

//
//   File : kvi_ircserver.h (/usr/build/NEW_kvirc/kvirc/kvilib/kvi_ircserver.h)
//   Last major modification : Thu Jan 14 1999 18:06:28 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_config.h"
#include "kvi_settings.h"
#include <qlist.h>

typedef struct KviIrcServer
{
	KviStr szHost;
	KviStr szIp;
	KviStr szPassword;
	KviStr szDescription;
	KviStr szPort;
#ifdef COMPILE_NEED_IPV6
	bool   bIpV6;
#endif
};

typedef struct KviIrcProxy
{
	KviStr szHost;
	KviStr szIp;
	KviStr szPassword;
	KviStr szUsername;
	KviStr szPort;
};

class KviIrcNetwork
{
	friend class KviIrcServerManager;
public:
	KviIrcNetwork(const char *szName = 0);
	KviIrcNetwork(KviIrcNetwork * net);
	~KviIrcNetwork();
private:
	KviStr m_szName;
	KviIrcServer *m_pCurrentServer;
	QList<KviIrcServer> *m_pServerList;
public:
	void clear();
	uint serverCount();
	QList<KviIrcServer> *serverList();
	bool setCurrentServer(KviIrcServer * ptr);
	//Returns the current server or 0 if (and only if) the list is empty
	KviIrcServer * currentServer();
	//Returns the next server in the list (circular) , 0 if the list is empty.
	//Updates the current server!!!
	KviIrcServer * nextServer();
	//Appends a server entry and sets it as current
	void appendServer(KviIrcServer * ptr);
	//Returns true if the server was in the list , updates the current server!
	//Deletes the KviIrcServer entry!!!!  , so ptr is not valid anymore
	bool removeServer(KviIrcServer * ptr);
	//Copies the current network too...
	void copyFrom(KviIrcNetwork *net);
	char *name();
	//DO NOT CALL THIS , will mix the server list! (called from KviDlgOptServer)
	void setName(const char *name){ m_szName = name; };
	void updateServerIp(const char *szServer,const char *szIp);
	KviIrcServer * getServerByName(const char *szName);
	void sortServers();
private:
	void serverFromString(KviStr  &szSrv,KviIrcServer * srv);
	void serverToString(KviStr &szSrv,KviIrcServer *srv);
	void save(KviConfig *cfg);
	void load(KviConfig *cfg);
	void getServerCompareString(KviStr &szStr,KviIrcServer *srv);
};

inline char * KviIrcNetwork::name(){ return m_szName.ptr(); }

class KviIrcServerManager
{
public:
	KviIrcServerManager();
	~KviIrcServerManager();
private:
	QList<KviIrcNetwork> *m_pNetList;
	KviIrcNetwork *m_pCurrentNet;
public:
	void clear();
	void load(KviConfig *cfg);
	void save(KviConfig *cfg);
	QList<KviIrcNetwork> * networkList();
	void insertNetwork(KviIrcNetwork * net);
	KviIrcNetwork * getCurrentNetwork();
	KviIrcNetwork * getNetworkByName(const char *szName);
	bool setCurrentNetwork(KviIrcNetwork *net);
	bool setCurrentNetwork(const char *szName);
	bool setCurrentServer(KviIrcServer *srv);
	void iWantThisServerToBeCurrent(const char *szName,const char *szPort,bool bIpV6 = false);
	void setCurrentServerPassword(const char * pass);
	bool removeNetwork(KviIrcNetwork *net);
	bool removeNetwork(const char *szName);
	void copyFrom(KviIrcServerManager * ptr);
	KviIrcServer * getCurrentServer();
	KviIrcServer * getNextServer();
	void updateServerIp(const char *szNet,const char *szServer,const char *szIp);
	bool importFromIni(const char *filename);
	void insertNewServer(KviIrcServer *srv,const char *szNetName);
};

class KviIrcProxyManager
{
public:
	KviIrcProxyManager();
	~KviIrcProxyManager();
private:
	QList<KviIrcProxy> *m_pProxyList;
	KviIrcProxy        *m_pCurrentProxy;
public:
	void load(KviConfig *cfg);
	void save(KviConfig *cfg);
	void clear();
	void copyFrom(KviIrcProxyManager *m);
	KviIrcProxy * currentProxy();
	KviIrcProxy * getProxyByName(const char *szName);
	void updateProxyIp(const char *szName,const char *szIp);
	bool setCurrentProxy(KviIrcProxy *prx);
	bool removeProxy(KviIrcProxy *prx);
	void appendProxy(KviIrcProxy *prx);
	QList<KviIrcProxy> * proxyList(){ return m_pProxyList; };
};

#endif //!_KVI_SERVER_H_INCLUDED_
