#ifndef _KVI_DCC_SEND_H_INCLUDED_
#define _KVI_DCC_SEND_H_INCLUDED_

//
//   File : kvi_dcc_send.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dcc_send.h)
//   Last major modification : Thu Feb 11 1999 20:06:34 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_thread.h"
#include "kvi_string.h"
#include "kvi_dcc_manager.h"

#include <qprogressbar.h>
#include <qlabel.h>
#include <qfile.h>
#include <qdatetime.h>

class KviDccSend;

typedef struct KviDccSendStruct
{
	KviStr          nick;
	KviStr          username;
	KviStr          host;
	KviStr          filePath;
	KviStr          originalFileName;
	unsigned long   fileLength;
	unsigned long   uAddress;
	KviStr          szAddress;
	KviStr          tmpBuffer;
	unsigned short  uPort;
	unsigned long   receivedBytes; //Absolute
	unsigned long   realBytesCount; //relative (resume)
	unsigned long   sentBytes; //Absolute
	unsigned long   realSentBytesCount; //relative (resume)
	unsigned int    ackedBytes;
	unsigned long   stalledCount;
	int             blockSize;
	QTime           startTime;
	KviDccSend     *dccSendParent;
	QFile          *file;
	bool            bListening;
	pthread_mutex_t resumeMutex;
	bool            bFastSend;
	bool            bGetSession; //dcc send or get ?
	bool            bSendZeroAck; // simulate bug in get sessions
	unsigned short  uPortToListenOn; 
};

class KviChanLabel;

class KviDccSend : public KviWindow
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviDccSend(KviFrame *lpFrm,const char *name);
	~KviDccSend();
public:		// Fields
	QProgressBar * m_pProgress;
	KviChanLabel       * m_pFileLabel; // Styles hack (just for the class name)
	KviChanLabel       * m_pStatLabel;
	KviDccSendStruct * m_dccSendStruct;
	bool           m_bThreadRunning;
	pthread_t      m_thread;
public:		// Methods
	void acceptDccSendRequest(KviDccSendRequestStruct *dccSend);
	void initiateGet();
	bool youAreListening(unsigned short uPort,const char *nick);
	void requestDccSend(KviDccSendRequestStruct *dccSend);
	bool resumeForCurrentSend(unsigned long uResumePos);
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	void applyLabelsOptions();
	void setFileProgress(int prog);
	void destroyDccSendStruct();
	virtual bool event(QEvent *e);
};

#endif //_KVI_DCC_SEND_H_INCLUDED_
