#ifndef _KVI_POPUPMENU_H_INCLUDED_
#define _KVI_POPUPMENU_H_INCLUDED_

//
//   File : kvi_popupmenu.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_popupmenu.h)
//   Last major modification : Wed Apr 21 1999 21:36:10 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qpopupmenu.h>
#include <qlist.h>
#include <qwidget.h>
#include <qfile.h>
#include <qpalette.h>

#include "kvi_string.h"

class KviPopupMenu;

typedef struct KviPopupMenuData
{
	KviStr buffer;
	KviStr text;
	KviStr image;
	KviPopupMenu *menu;
	int    id;
};

//
// An item with id=0 , menu=0 and buffer = " " is a separator.
// Normal menu item buffers have the initial spaces stripped at
// insertion time
//

class KviCommand;
class KviWindow;

class KviPopupMenu : public QPopupMenu
{
	friend class KviPopupEditor;
	friend class KviUToolBarEditor;
	Q_OBJECT
public:
	KviPopupMenu(QWidget * parent,const char * name);
	~KviPopupMenu();
private:
	QList<KviPopupMenuData> * m_pDataList;
	KviPopupMenu *m_pParent;
	KviWindow *m_pParentWindow;
	bool m_bInTestMode;
public:
	bool m_bLocked; //Protects against self-modification
	void clearAll();
	const KviStr text(int id);
	int insertNormalItem(const char *name,const char *img,const char *buffer);
	void insertPopupItem(const char *name,const char *img,KviPopupMenu *menu);
	void insertSeparatorItem();
	void doPopup(const QWidget *receiver,const char *memberSlot);
	void doPopup(const QWidget *receiver,const char *memberSlot,QPoint pos);
	void doTestPopup(const QWidget *receiver,const char *memberSlot);
	void reloadMenu(const QWidget *parentWindow);
	void copyFromPopup(KviPopupMenu *popup);
	static bool saveAllPopups(const char *filename);
	static bool loadAllPopups(const char *filename,KviStr &error);
	virtual void setFont(const QFont &font);
	void setPaletteRecursive(const QPalette &pal);
	//needed for UserToolBar
	void buildDataBuffer(KviStr &str);
//	void buildPDataBuffer(KviStr &str, char *name =0);
	bool loadFromDataBuffer(KviStr &buffer,KviStr &error);
private:
	void itemClickedRedirect(const KviStr &buffer,int id);
//	void testItemClickedRedirect(int id);
	void save(QFile *f,const char *popupName);
	bool load(QFile *f,const char *popupName,KviStr &error);
public slots:
	void localItemClicked(int id);
signals:
	void itemClicked(const KviStr &buffer);
	void testItemClicked(int id);
};

#endif //!_KVI_POPUPMENU_H_INCLUDED_
