//
//   File : libkviawaysystem.cpp
//   Last major modification : Tue Oct 26 17:03:43 1999 by Ted Podgurski
//   With the help of Kbird from #EFnet #KVirc :)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Ted Podgurski (tedp@toocool.com)
//   Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __KVIRC_PLUGIN__
#include "kvirc_plugin.h"
#include "kvi_options.h"
#include "kvi_locale.h"
#include "kvi_ircsocket.h"
#include <time.h>

// =======================================
// Global variables
// =======================================
static bool away;
static time_t awaytimer;
static char awaymsg[80];
static char abc[120];

bool away_plugin_command(KviPluginCommandStruct *cmd)
{       
	if(away == true){
		cmd->window->output(KVI_OUT_ECHO, "%c4,4 %c0,2 AWAY mode is already ENABLED (Try using /back) %c4,4 ", KVI_TEXT_COLOR, KVI_TEXT_COLOR, KVI_TEXT_COLOR);
		return false;
	}
	if(cmd->params->count() > 1){
	    away = true;
        KviStr *tmp = cmd->params->first();
        for (tmp=cmd->params->next(); tmp; tmp=cmd->params->next() ){
            strcat(awaymsg, tmp->m_ptr);
            strcat(awaymsg, " ");
        }
        sprintf(abc, "RAW -s AWAY :%s", awaymsg);
        cmd->frame->m_pUserParser->parseCommand(abc, cmd->frame->m_pWinList->first());
	    sprintf(abc, "AME is away:%c %s", KVI_TEXT_BOLD, awaymsg);
	    cmd->frame->m_pUserParser->parseCommand(abc, cmd->frame->m_pWinList->first());
        time(&awaytimer);
        return true;
    } else {
	    cmd->window->output(KVI_OUT_ECHO, "%c4,4 %c0,2 Usage : /Away %c<Message> %c4,4 ", KVI_TEXT_COLOR, KVI_TEXT_COLOR, KVI_TEXT_BOLD, KVI_TEXT_COLOR);
        away = false;
        return true;
    }
}


bool back_plugin_command(KviPluginCommandStruct *cmd)
{
    time_t backtime;
    int diff;
    int hours=0;
    int minutes=0;
    int seconds=0;
    if(away == false){
        cmd->window->output(KVI_OUT_ECHO, "%c4,4 %c0,2 AWAY mode is DISABLED (Try using /away) %c4,4 ", KVI_TEXT_COLOR, KVI_TEXT_COLOR, KVI_TEXT_COLOR);
        return false;
    }
    sprintf(abc, "RAW -s AWAY");
    cmd->frame->m_pUserParser->parseCommand(abc, cmd->frame->m_pWinList->first());
    time(&backtime);
    diff = (int)difftime(backtime, awaytimer);
    hours = diff / (60 *60);
    diff = diff % (60 * 60);
    minutes = diff / 60;
    diff = diff % 60;
    seconds = diff;
    sprintf(abc, "AME is back: [Gone %dh:%dm:%ds]", hours,minutes,seconds);
	cmd->frame->m_pUserParser->parseCommand(abc, cmd->frame->m_pWinList->first());
    away = false;
    *awaymsg = '\0';
    return true;
}

// =======================================
// init routine
// =======================================
bool alchemyas_plugin_init(KviPluginCommandStruct * cmd)
{
    kvirc_plugin_register_command(cmd->handle,"AWAY",away_plugin_command);
	kvirc_plugin_register_command(cmd->handle,"BACK",back_plugin_command);
    away = false;
    return true;
}

// =======================================
// plugin definition structure
// =======================================
KviPlugin kvirc_plugin =
{
    "Away System" ,
    "A small away system plugin" ,
    "0.1" ,
    "Ted Podgurski <tedp@toocool.com>" ,
	"/away and /back" ,
    alchemyas_plugin_init ,
    0,
    0,
    0
};
