//
//   THIS IS A "READY TO EDIT" SOURCE FOR YOUR FIRST PLUGIN
//   Copyright (C) 1999-2000 PLACE YOUR NAME HERE (your@email)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define __KVIRC_PLUGIN__

#include "kvirc_plugin.h"
#include "libkvimydialog.h"

#include <qdialog.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>

//
// This is the constructor for the simple dialog
//
MyDialog::MyDialog(KviPluginCommandStruct *kcmd)
:QDialog(0,"mydialog")
{
	setCaption("MyDialog");
	m_pWin=kcmd->window;
	QGridLayout *g = new QGridLayout(this,4,2);
	m_pE1 = new QLineEdit(this);
	m_pE2 = new QLineEdit(this);
	m_pE3 = new QLineEdit(this);
	g->addMultiCellWidget(m_pE1,0,0,0,1);
	g->addMultiCellWidget(m_pE2,1,1,0,1);
	g->addMultiCellWidget(m_pE3,2,2,0,1);

	QPushButton *b = new QPushButton("test",this,"mydialog_testbutton");
	connect(b,SIGNAL(clicked()),this,SLOT(btn_pressed()));
	g->addWidget(b,3,0);

	b = new QPushButton("btn2",this,"mydialog_testbutton");
	connect(b,SIGNAL(clicked()),this,SLOT(btn2_pressed()));
	g->addWidget(b,3,1);
}

void MyDialog::btn_pressed()
{
m_pWin->output(KVI_OUT_INTERNAL,"MYDIALOG: test");
m_pWin->output(KVI_OUT_INTERNAL,m_pE1->text().latin1());
m_pWin->output(KVI_OUT_INTERNAL,m_pE2->text().latin1());
m_pWin->output(KVI_OUT_INTERNAL,m_pE3->text().latin1());
}

void MyDialog::btn2_pressed()
{
m_pWin->output(KVI_OUT_INTERNAL,"MYDIALOG: button 2");
m_pWin->output(KVI_OUT_INTERNAL,m_pE1->text().latin1());
m_pWin->output(KVI_OUT_INTERNAL,m_pE2->text().latin1());
m_pWin->output(KVI_OUT_INTERNAL,m_pE3->text().latin1());
}


MyDialog::~MyDialog()
{
}

//
// This is a global in the plugin
//
MyDialog *d=0;

//
// this is what the command MYDIALOG DOES
//
bool mydialog_plugin_command_mydialog(KviPluginCommandStruct *cmd)
{
	if (!d)
		d= new MyDialog(cmd);
	d->show();
	return true;
}


//
// init routine: Registers the command MYDIALOG
//

bool mydialog_plugin_init(KviPluginCommandStruct *cmd)
{
	kvirc_plugin_register_command(cmd->handle,"MYDIALOG",mydialog_plugin_command_mydialog);
	return true; // success
}

//
// cleanup routine: don't forget to delete the objects you have created :)
//
void mydialog_plugin_cleanup()
{
	if(d) {
		delete (d);
		d =0;
	}

	kvirc_plugin_unregister_meta_object("MyDialog");
}

/*
	@document: doc_plugin_mydialog.kvihelp
	@title: The KVIrc MyDialog plugin
		This plugin is for demonstration only. Its purpose is to show how to implement
		Dialogs in plugins.<br>
		<docsubtitle>Note</docsubtitle>
		...<br>
		...<br>
		...<br>
*/

//
// Tells Kvirc where to find the help page.
//
void mydialog_plugin_help()
{
	kvirc_plugin_show_help_page("doc_plugin_mydialog.kvihelp");
}

//
// Your plugin definition structure
//
KviPlugin kvirc_plugin =
{
	"mydialog" ,                                  // place here the name of your plugin. (it should the same as the library name)
	"My first KVIrc plugin (dialog)" ,            // place here an one line description of your plugin
	"0.0" ,                                       // place there the version of your plugin
	"Your name <your@email>" ,                    // place here your name and e-mail
	"This plugin shows how to use\n" \
	"qt-dialogs in plugins...",                   // place here a short description of what your plugin does
	mydialog_plugin_init ,                        // init routine
	mydialog_plugin_cleanup ,                     // cleanup routine
	0 ,                                           // you have no configuration routine yet
	mydialog_plugin_help                          // this is the way to provide help for you plugin
};

#include "m_libkvimydialog.moc"
