#ifndef _KVI_MDI_CAPTION_H_INCLUDED_
#define _KVI_MDI_CAPTION_H_INCLUDED_

// =============================================================================
//
//      --- kvi_mdi_caption.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

#include "kvi_string.h"

class QPixmap;
class QPoint;

class KviMdiChild;

/**
 * Internal class
 * @internal
 */
class KviMdiCaption : public QWidget
{
	Q_OBJECT
public:
	KviMdiCaption(KviMdiChild *parent, const char *name = 0);
	~KviMdiCaption();
public:
	QString      m_szCaption;
	bool         m_bActive;
	bool         m_bCanMove;
	KviMdiChild *m_pParent;
	QPoint       m_relativeMousePos;
	int          m_iMoveResistence;

	/**
	 * This is a POINTER to an icon 16x16. If this is 0 no icon is painted.
	 */
	QPixmap *m_pIcon;
public:
	void setActive(bool bActive);
	void setCaption(const char *text);
	bool active();
	int heightHint();
protected:
	virtual void leaveEvent(QEvent *);
	virtual void paintEvent(QPaintEvent *);
	virtual void       mousePressEvent(QMouseEvent *);
	virtual void mouseDoubleClickEvent(QMouseEvent *);
	virtual void     mouseReleaseEvent(QMouseEvent *);
	virtual void        mouseMoveEvent(QMouseEvent *);
};

#endif // _KVI_MDI_CAPTION_H_INCLUDED_
