// =============================================================================
//
//      --- kvi_frame_quickhelp.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviFrameQuickhelp"

#include <qcursor.h>
#include <qpainter.h>

#include "kvi_app.h"
#include "kvi_cursor.h"
#include "kvi_defines.h"
#include "kvi_fileutils.h"
#include "kvi_frame.h"
#include "kvi_xutils.h"

#include <X11/Xlib.h> // For XGrabServer, XGrabPointer, etc.

void KviFrame::slot_whatIsThisRequest()
{
	// Own implementation of the whatsThis idea from Qt.
	g_pApp->setOverrideCursor(KviCursor::handCursor());

	XGrabServer(qt_xdisplay());
	if( XGrabPointer(
		qt_xdisplay(), qt_xrootwin(), true, (ButtonPressMask | ButtonReleaseMask),
		GrabModeAsync, GrabModeAsync, None, None, CurrentTime) != GrabSuccess
	) {
		debug("Could not grab the pointer");
		XUngrabServer(qt_xdisplay());
		return;
	}
	XEvent ev;
	// Allow selecting a widget of our application
	// Keep track of the widget currently under the cursor

	// Highlight the first widget (should be the related toolbar button)
	QWidget *last = g_pApp->widgetAt(QCursor::pos(), true);
	QRect lastRect;
	if( last ) {
		lastRect = last->rect();
		QPainter pa(last);
		kvi_drawDragRectangle(&pa, lastRect, 1);
	}

	// Now loop until the user clicks.
	// I placed also a timeout here because
	// we do not want to block the whole system if the user
	// clicks the KviWhatIsThis Button and then runs to the
	// store down the road completely forgetting about that.
	QTime tm = QTime::currentTime();
	bool bInTime = true;

	while( !XCheckMaskEvent(qt_xdisplay(), (ButtonPressMask | ButtonReleaseMask), &ev) ) {
		QWidget *w = g_pApp->widgetAt(QCursor::pos(), true);
		if( last != w ) {
			if( last ) {
				QPainter pa(last);
				kvi_drawDragRectangle(&pa, lastRect, 1);
			}
			if( w ) {
				QPainter pa(w);
				lastRect = w->rect();
				kvi_drawDragRectangle(&pa, lastRect, 1);
			}
			last = w;
			// Reset timer if the user is still moving the mouse
			tm = QTime::currentTime();
		}
		if( tm.msecsTo(QTime::currentTime()) > KVI_WHATISTHIS_SELECTION_TIMEOUT ) {
			bInTime = false;
			break;
		}
	}
	if( last ) {
		QPainter pa(last);
		kvi_drawDragRectangle(&pa, lastRect, 1);
	}

	XUngrabPointer(qt_xdisplay(), CurrentTime);
	XUngrabServer(qt_xdisplay());
	// Now find the selected widget
	QWidget *w = g_pApp->widgetAt(QCursor::pos(), true);
	if( w && bInTime )
		helpForObject(w);
	g_pApp->restoreOverrideCursor();
}

/**
 * Look for the file "className()_name().kvihelp"
 * if not found check for "className().kvihelp"
 * if not found check if the widget has a parent and look for
 * "parent->className()_parent->name().kvihelp"
 * if not found check for "parent->className().kvihelp"
 * if not found say that there is no help for it.
 */
void KviFrame::helpForObject(QObject *w)
{
	KviStr fname;
	fname  = "qh_";
	fname += w->className();
	fname += "_";
	fname += w->name();
	fname += ".kvihelp";
	fname.toLower();

	KviStr szPath;
	g_pApp->getGlobalKVIrcDirectory(szPath, KviApp::Help, fname.ptr());
	if( kvi_fileExists(szPath.ptr()) ) {
		requestHelpOn(fname.ptr());
		return;
	}

	fname  = "qh_";
	fname += w->className();
	fname += ".kvihelp";
	fname.toLower();

	g_pApp->getGlobalKVIrcDirectory(szPath, KviApp::Help, fname.ptr());
	if( kvi_fileExists(szPath.ptr()) ) {
		requestHelpOn(fname.ptr());
		return;
	}

	if( !(w->parent()) ) {
		requestHelpOn("qh_nohelpavailable.kvihelp");
		return;
	}
	// Recursive call on the parent
	helpForObject(w->parent());
}
