// =============================================================================
//
//      --- kvi_maintoolbar.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviMainToolbar"

#include "kvi_app.h"
#include "kvi_debug.h"
#include "kvi_defines.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_maintoolbar.h"

static const QString tb_connected("connect_established.png");
static const QString tb_connecting("connect_creating.png");
static const QString tb_disconnected("connect_no.png");

/**
 * ============ KviMainToolBar ============
 */
KviMainToolBar::KviMainToolBar(KviFrame *parent)
	: KviToolBar("Main Toolbar", parent, parent, Qt::DockTop, false, "mainToolBar")
{
	m_connectButton        = 100;
	m_dirBrowserButton     = 101;
	m_disconnectButton     = 102;
	m_generalOptionsButton = 103;
	m_helpBrowserButton    = 104;
	m_regUsersButton       = 105;
	m_scriptCenterButton   = 106;
	m_serverOptionsButton  = 107;
	m_userOptionsButton    = 108;
	m_whatIsThisButton     = 109;

	setPreferOwnIcons(true);
	insertButton(
		tb_disconnected, m_connectButton, SIGNAL(clicked()), parent, SLOT(slot_connectToServer()), true,
		_i18n_("Connect"), _i18n_("Start or stop an IRC connection")
	);

	insertLineSeparator();

	insertButton(
		tb_configUser, m_userOptionsButton, SIGNAL(clicked()), g_pApp, SLOT(slot_doUserOptionsDialog()), true,
		_i18n_("User Configuration"), _i18n_("Display the user configuration dialog")
	);
	insertButton(
		tb_configServer, m_serverOptionsButton, SIGNAL(clicked()), g_pApp, SLOT(slot_doServerOptionsDialog()), true,
		_i18n_("Server Options"), _i18n_("Display the server options dialog")
	);
	insertButton(
		tb_configGeneral, m_generalOptionsButton, SIGNAL(clicked()), g_pApp, SLOT(slot_generalOptionsDialog()), true,
		_i18n_("General Options"), _i18n_("Display the general options dialog")
	);
	insertButton(
		tb_regUsers, m_regUsersButton, SIGNAL(clicked()), g_pApp, SLOT(slot_doRegUsersDialog()), true,
		_i18n_("Registered Users"), _i18n_("Display the registered users dialog")
	);
	insertButton(
		tb_scriptCenter, m_scriptCenterButton, SIGNAL(clicked()), parent, SLOT(slot_showScriptCenter()), true,
		_i18n_("Script Center"), _i18n_("Display the script center")
	);

	insertLineSeparator();

	insertButton(
		tb_dirBrowser, m_dirBrowserButton, SIGNAL(clicked()), parent, SLOT(toggleDirBrowser()), true,
		_i18n_("Directory Browser"), _i18n_("Show or hide the directory browser")
	);
	setToggle(m_dirBrowserButton, true);
	insertButton(
		tb_helpBrowser, m_helpBrowserButton, SIGNAL(clicked()), parent, SLOT(toggleHelpBrowser()), true,
		_i18n_("Help Browser"), _i18n_("Show or hide the help browser")
	);
	setToggle(m_helpBrowserButton, true);
	insertButton(
		tb_whatIsThis, m_whatIsThisButton, SIGNAL(clicked()), parent, SLOT(slot_whatIsThisRequest()), true,
		_i18n_("What is This?"), _i18n_("Enter mode to display help on a clicked item")
	);

	setBackgroundMode(PaletteBackground);
}

/**
 * ============ ~KviMainToolBar ============
 */
KviMainToolBar::~KviMainToolBar()
{
	// Nothing here
}

/**
 * ============= setConnectButtonState ===========
 */
void KviMainToolBar::setConnectButtonState(int state)
{
	switch( state ) {
		case KVI_CONNECT_CONNECTING: {
			setButtonIcon(m_connectButton, tb_connecting);
			setButtonText(m_connectButton, _i18n_("Abort Connection"));
			break;
		}
		case KVI_CONNECT_CONNECTED: {
			setButtonIcon(m_connectButton, tb_connected);
			setButtonText(m_connectButton, _i18n_("Disconnect"));
			break;
		}
		default: { // KVI_CONNECT_DISCONNECTED
			setButtonIcon(m_connectButton, tb_disconnected);
			setButtonText(m_connectButton, _i18n_("Connect"));
			break;
		}
	}
}

void KviMainToolBar::setDirButtonState(bool state)
{
	setButton(m_dirBrowserButton, state);
}

void KviMainToolBar::setHelpButtonState(bool state)
{
	setButton(m_helpBrowserButton, state);
}

#include "m_kvi_maintoolbar.moc"
