// =============================================================================
//
//      --- kvi_options_front.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsFront"

#include <qlayout.h>

#include "kvi_defines.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_options_front.h"
#include "kvi_string.h"

KviOptionsFront::KviOptionsFront(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE)
{
	QGridLayout *g = new QGridLayout(
		this, 1, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);
	KviLabel *l = new KviLabel(
		_CHAR_2_QSTRING(_i18n_( \
			"<h1><b><center>General Options</center></b></h1><br>" \
			"<hr><br>" \
			"<center>Select a category from the list view on the left<br>" \
			"to view the related options.<br>" \
			"When you have finished, click OK to accept your changes<br>" \
			"or Cancel to discard them.</center>" \
		)),
		this
	);
	l->setAlignment(AlignCenter);
	g->addWidget(l, 0, 0);
}

KviOptionsFront::~KviOptionsFront()
{
	// Nothing here
}

#include "m_kvi_options_front.moc"
