// =============================================================================
//
//      --- kvi_stat_chan.cpp ---
//
//   This is a plugin for KVIrc 2. It allows you to see
//   statistics of your IRC sessions - total words said etc.
//   More features are still to come.
//
//   (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviStatChan"

#include "kvi_stat_chan.h"

KviStatChan::KviStatChan(
	const char *_name,
	unsigned int _joins, unsigned int _words, unsigned int _kicks,
	unsigned int _bans, unsigned int _topics, unsigned int _actions
)
{
	m_name    = _name;
	m_joins   = _joins;
	m_words   = _words;
	m_kicks   = _kicks;
	m_bans    = _bans;
	m_topics  = _topics;
	m_actions = _actions;
}

KviStatChan::~KviStatChan()
{
	// Nothing here
}

void KviStatChan::addJoins  (int num)      { m_joins   += num; }
void KviStatChan::addWords  (int num)      { m_words   += num; }
void KviStatChan::addKicks  (int num)      { m_kicks   += num; }
void KviStatChan::addBans   (int num)      { m_bans    += num; }
void KviStatChan::addTopics (int num)      { m_topics  += num; }
void KviStatChan::addActions(int num)      { m_actions += num; }

const char *KviStatChan::name()     const  { return m_name.ptr(); }
unsigned int KviStatChan::joins()   const  { return m_joins;      }
unsigned int KviStatChan::words()   const  { return m_words;      }
unsigned int KviStatChan::bans()    const  { return m_bans;       }
unsigned int KviStatChan::kicks()   const  { return m_kicks;      }
unsigned int KviStatChan::topics()  const  { return m_topics;     }
unsigned int KviStatChan::actions() const  { return m_actions;    }

