#ifndef _KVI_COMPLETIONBOX_QT_H_INCLUDED_
#define _KVI_COMPLETIONBOX_QT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_completionbox_qt.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qlistbox.h>

class KviCompletionBox : public QListBox
{
	Q_OBJECT
public:
	KviCompletionBox(QWidget *, const char *name = 0);
	~KviCompletionBox();

	void hide();

	void setItems(const QStringList &);
	bool activate();
	void popup(const QPoint &);
public slots:
    void down();
    void up();
    void pageDown();
    void pageUp();
    void home();
    void end();

	QStringList items() const;
	void insertItems(const QStringList &, int index = -1);
signals:
	void activated(const QString &);
protected slots:
	virtual void slotActivated(QListBoxItem *);
protected:
	QSize sizeHint() const;
	bool eventFilter(QObject *, QEvent *);
private slots:
	void slotCurrentChanged();
	void cancelled();
	void slotItemClicked(QListBoxItem *);
private:
	QWidget *m_parent;
};

#endif // _KVI_COMPLETIONBOX_QT_H_INCLUDED_
