// =============================================================================
//
//      --- kvi_imagefilepreviewwidget_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviImageFilePreviewWidget"

#include <qpixmap.h>

#include "kvi_imagefilepreviewwidget_qt.h"
#include "kvi_locale.h"
#include "kvi_string.h"

KviImageFilePreviewWidget::KviImageFilePreviewWidget(const QString &text, QWidget *parent)
	: KviLabel(text, parent)
{
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setAlignment(AlignCenter);
	setMaximumWidth(400);
	setMaximumHeight(400);
}

KviImageFilePreviewWidget::~KviImageFilePreviewWidget()
{
	// Nothing here
}

void KviImageFilePreviewWidget::showPreview(const QString &str)
{
	QPixmap pix(str);
	if( pix.isNull() )
		setText(_CHAR_2_QSTRING(_i18n_("Unrecognized image format")));
	else
		setPixmap(pix);
}

#include "m_kvi_imagefilepreviewwidget_qt.moc"
