#ifndef _KVI_LISTWINDOW_H_INCLUDED_
#define _KVI_LISTWINDOW_H_INCLUDED_

// =============================================================================
//
//      --- kvi_listwindow.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_listview.h"
#include "kvi_window.h"

class KviLabel;
class KviLineEdit;
class KviListView;
class KviPushButton;

typedef struct KviChanListEntry
{
	KviStr channel;
	int    nUsers;
	KviStr topic;
};

class KviListWindow : public KviWindow
{
	Q_OBJECT
public:
	KviListWindow(KviFrame *lpFrm);
	~KviListWindow();
public:
	QSplitter                  *m_pVerSplitter;
	KviListView                *m_pListView;
	QWidget                    *m_pPanel;
	KviLineEdit                *m_pListParams;
	KviPushButton              *m_pRequestList;
	KviLineEdit                *m_pChannelRegexp;
	KviLineEdit                *m_pTopicRegexp;
	KviLineEdit                *m_pMinUsers;
	KviLineEdit                *m_pMaxUsers;
	KviPushButton              *m_pApplyFilter;
	QPtrList<KviChanListEntry> *m_pChanList;
	KviLabel                   *m_pDisplayedItems;
	bool                        m_bInRequest;
	KviStr                      m_szLastServer;
	KviStr                      m_szLastDate;
	QTimer                     *m_pChanListLoadTimer;
	KviStr                      m_szChanListData;
	const char                 *m_pChanListData;
public:
	void endOfList();
	void startOfList();
	void processListEntry(const char *msg);
	void notifyDisconnected();
protected:
	virtual QPixmap *myIconPtr();

	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual void setProperties(KviWindowProperty *);
	virtual void saveProperties();

	void clearChanList();
	void brokenListEntry(const char *msg);
	void updateDisplayedItems();
	void saveChanList();
	void loadChanList();
protected slots:
	void loadChanListChunk();
	void applyFilter();
	void requestList();
	void joinChannel(KviListViewItem *);
};

#endif // _KVI_LISTWINDOW_H_INCLUDED_
