#ifndef _KVI_OPTIONS_PLUGINS_H_INCLUDED_
#define _KVI_OPTIONS_PLUGINS_H_INCLUDED_

// =============================================================================
//
//      --- kvi_options_plugins.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_optionswidget.h"

#include "kvi_settings.h"

class QCheckBox;

class KviLabel;
class KviListBox;
class KviPushButton;

class KviOptionsPlugins : public KviOptionsWidget
{
	Q_OBJECT
public:
	KviOptionsPlugins(QWidget *parent);
	~KviOptionsPlugins();
protected:
#ifdef COMPILE_PLUGIN_SUPPORT
	KviListBox    *m_pPluginBox;
	KviLabel      *m_pPluginModuleNameLabel;
	KviLabel      *m_pPluginDescriptionLabel;
	KviLabel      *m_pPluginAuthorLabel;
	KviLabel      *m_pPluginVersionLabel;
	KviLabel      *m_pPluginServiceNameLabel;
	KviPushButton *m_pUnloadPlugin;
	KviPushButton *m_pConfigurePlugin;
	KviPushButton *m_pHelpOnPlugin;
	QCheckBox     *m_pPluginAutoloadCheck;
#endif
public:
	virtual void commitChanges();
#ifdef COMPILE_PLUGIN_SUPPORT
	void fillPluginBox(unsigned int selectIdx = 0);
#endif

protected slots:
	// MOC always wants the skeletons of the slots
	void pluginListItemSelected(const QString &str);
	void pluginAutoloadToggled(bool bActive);
	void pluginLoad();
	void pluginUnload();
	void pluginConfigure();
	void pluginHelp();
};

#endif // _KVI_OPTIONS_PLUGINS_H_INCLUDED_
