#ifndef _KVI_IMAGE_WINDOW_H_INCLUDED_
#define _KVI_IMAGE_WINDOW_H_INCLUDED_

// =============================================================================
//
//   This is a plugin for the KVIrc IRC client
//   Copyright (C) 1999-2000 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_window.h"

class QPixmap;
class KviToolBar;

class KviImageView;

class KviImageWindow : public KviWindow
{
	Q_OBJECT
public:
	KviImageWindow(KviFrame *lpFrm);
	~KviImageWindow();
public:
	KviImageView *m_pImageView;
	KviToolBar   *m_pToolBar;
public:
	bool loadImage(const char *fName);
protected slots:
	void zoomIn();
	void zoomIn5();
	void zoomIn10();
	void zoomIn50();
	void zoomIn100();
	void zoomOut();
	void zoomOut5();
	void zoomOut10();
	void zoomOut50();
	void zoomOut100();
	void noZoom();
	void openFile();
protected:
	virtual QPixmap *myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
};

#endif // _KVI_IMAGE_WINDOW_H_INCLUDED_
