/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef KDIALUP_H
#define KDIALUP_H

#include <qobject.h> 

class KProcess;
class KwlanTrayWin;
class KwlanInterface;

class QString;
//class KwlanSuProcess;
//class KProcess;

class KDialup : public QObject
{
    Q_OBJECT
        
        
    public:
        KDialup(QObject * parent = 0, const char * name = 0 );
        ~KDialup();
    signals:
        void logEvent(QString event);
        void connectionEstablished();
        
    public slots:
        void connectNetwork(QString network);
        void slotConnect();
        void disconnectNetwork(QString network);
        void pppdStatus(KProcess *proc, char *buffer, int buflen);
        void interfaceEnable(bool enable);
        void close();
        void slotProcessExited(KProcess *);
    private:
        bool m_connected;
        bool m_storePassword;
        bool m_connecting;
        QString m_pppdPath;
        QString m_pppInterface;
        QString m_network;
        KwlanTrayWin *m_traywin;
        KwlanInterface *m_interface;


};

#endif
