/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GeoXY.h,v 1.3 2002/04/23 09:28:18 com Exp $
*/

#ifndef GEOXY_H
#define GEOXY_H


extern "C" {
#include <gis.h>
}
#include <qrect.h>

/**
 *
 *
 **/

class GeoXY {
public:
  
  GeoXY();

  ///the default constructor
  GeoXY(struct Cell_head* window, QRect& win);

  ///the destructor
  virtual ~GeoXY();

  void set(struct Cell_head* window, QRect& win);

  /** returns distance in meters between screen coords */
  double distance(int x1, int y1, int x2, int y2);

  double D_get_u_to_a_yconv();

  double D_get_u_to_a_xconv();

  double D_get_a_to_d_xconv();

  double D_get_a_to_d_yconv();

  double D_get_u_to_d_xconv();

  double D_get_u_to_d_yconv();

  double D_get_u_west();

  double D_get_u_east();

  double D_get_u_north();

  double D_get_u_south();

  double D_get_a_west();

  double D_get_a_east();

  double D_get_a_north();

  double D_get_a_south();

  double D_get_d_west();

  double D_get_d_east();

  double D_get_d_north();

  double D_get_d_south();

  double D_u_to_a_row( double U_row );

  double D_u_to_a_col(double U_col );

  double D_a_to_d_row(double A_row );

  double D_a_to_d_col(double A_col );

  double D_u_to_d_row(double U_row );

  double D_u_to_d_col( double U_col );

  double D_d_to_u_row(double D_row );

  double D_d_to_u_col(double D_col );

  double D_d_to_a_row(double D_row );

  double D_d_to_a_col(double D_col );

  double D_get_ns_resolution();

  double D_get_ew_resolution();
  
protected:
  
private:
  

  /* UTM coordinates.          (0,0) towards SW */
  double U_west   ;  /*  western edge  (UTM/meters)  */
  double U_east   ;  /*  eastern edge  (UTM/meters)  */
  double U_south  ;  /*  southern edge (UTM/meters)  */
  double U_north  ;  /*  northern edge (UTM/meters)  */
  /* map array coordinates.    (0,0) towards NW */
  double A_west   ;  /*  western edge  (array)       */
  double A_east   ;  /*  eastern edge  (array)       */
  double A_south  ;  /*  southern edge (array)       */
  double A_north  ;  /*  northern edge (array)       */
  /* dot (pixle)  coordinates. (0,0) towards NW */
  double D_west   ;  /*  western edge  (screen dots) */
  double D_east   ;  /*  eastern edge  (screen dots) */
  double D_south  ;  /*  southern edge (screen dots) */
  double D_north  ;  /*  northern edge (screen dots) */
	
  /* Conversion factors */
  double U_to_A_xconv, U_to_A_yconv ;     /* UTM to Array */
  double A_to_D_xconv, A_to_D_yconv ;     /* Array to Dot */
  double U_to_D_xconv, U_to_D_yconv ;     /* UTM to Dot   */

  /* others */
  double ew_resolution ;
  double ns_resolution ;
  int ARRAY_ROWS ;
  int ARRAY_COLS ;


};	// end of class GeoXY



#endif /* GEOXY_H */
