//LabPlot : ListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qfiledialog.h>
#include <klocale.h>
#include "ListDialog.h"
#include "DumpDialog.h"
#include "EditDialog.h"
#include "InfoDialog.h"
#include "VTKDialog.h"
#include "GRASSDialog.h"
#include "DataDialog.h"
#include "FunctionDialog.h"

ListDialog::ListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: Dialog(p, name), p(p), s(s)
{
	if(p) {
		type = p->getPlot(p->API())->Type();

		lv = new GraphListView(vbox);
		
		// popup menu
		menu = new QPopupMenu( lv );
		menu->insertItem( i18n( "Show/Hide" ),this,SLOT(toggleShown()) );
		menu->insertItem( i18n( "Delete" ),this,SLOT(deleteGraph()) );
		menu->insertItem( i18n( "Change" ),this,SLOT(changeGraph()) );
		menu->insertItem( i18n( "Edit" ),this,SLOT(editGraph()) );
		menu->insertItem( i18n( "Open Spreadsheet" ),this,SLOT(openSpreadsheet()) );
		menu->insertItem( i18n( "Export" ),this,SLOT(dumpGraph()) );
		menu->insertItem( i18n( "Statistics" ),this,SLOT(statGraph()) );
		
		connect(lv, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint& , int ) ),
			this, SLOT( Menu(QListViewItem *, const QPoint& , int) ) );
	
		updateList();
	}
}

void ListDialog::updateList() {
	lv->clear();
	lv->setSorting(-1);
		
	GraphList *graphlist = p->getPlot(p->API())->getGraphList();
	for (int i= graphlist->getNumber()-1;i>=0;i--) {
		QStringList s;
		if (type == P2D) {
			GRAPHType st = graphlist->getStruct(i);
			if (st == GRAPH2D) {		// x-y
				Graph2D *g = graphlist->getGraph2D(i);
				s = g->Info();
			}
			else if (st == GRAPH3D) {	// x-y-dy
				lv->showZ();
				Graph3D *g = graphlist->getGraph3D(i);
				s = g->Info();
			}
			else if (st == GRAPH4D) {	// x-y-dx-dy, x-y-dy1-dy2
				lv->showZ();lv->showT();
				Graph4D *g = graphlist->getGraph4D(i);
				s = g->Info();
			}
		}
		else if (type == P3D ){
			GRAPHType st = graphlist->getStruct(i);
			if (st == GRAPH3D) {
				lv->showZ();
				Graph3D *g = graphlist->getGraph3D(i);
				s = g->Info();
			}
			else if (st == GRAPHM){
				GraphM *g = graphlist->getGraphM(i);
				s = g->Info();
			}
		}
		else if (type == PSURFACE) {
			GRAPHType st = graphlist->getStruct(i);
			if (st == GRAPHM) {
				GraphM *g = graphlist->getGraphM(i);
				s = g->Info();
			}
			else if (st == GRAPHIMAGE){
				GraphIMAGE *g = graphlist->getGraphIMAGE(i);
				s = g->Info();
			}
		}
		else if (type == PPIE || type == PPOLAR) {
			Graph2D *g = graphlist->getGraph2D(i);
			s = g->Info();
		}
		else if (type == PGRASS) {
			GraphGRASS *g = graphlist->getGraphGRASS(i);
			s = g->Info();
		}
		else if (type == PVTK) {
			GraphVTK *g = graphlist->getGraphVTK(i);
			s = g->Info();
		}
		else if (type == PTERNARY) {
			lv->showZ();
			Graph3D *g = graphlist->getGraph3D(i);
			s = g->Info();
		}
		else if (type == PQWT3D) {
			GRAPHType st = graphlist->getStruct(i);
			if (st == GRAPHM) {
				GraphM *g = graphlist->getGraphM(i);
				s = g->Info();
			}
			else if (st == GRAPH3D) {
				Graph3D *g = graphlist->getGraph3D(i);
				s = g->Info();
			}
		}
		QListViewItem *lvi = new QListViewItem(lv);
		for (unsigned int j = 0;j < s.count();j++) {
			lvi->setText(j,s[j]);
		}
	}
	
	// select at least last item
	lv->setSelected(lv->currentItem(),TRUE);
	
	p->getMainWin()->setModified();
}

// toggle shown of selected graph
void ListDialog::toggleShown() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());

			Graph *g = p->getPlot(p->API())->getGraphList()->getGraph(item);
			if(g->isShown())
				g->setShown(FALSE);
			else
				g->setShown(TRUE);
		}
	}
	
	updateList();
	p->updatePixmap();
	p->resetRanges();
}

// delete selected graph
void ListDialog::deleteGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			p->getPlot(p->API())->getGraphList()->delGraph(item);
		}
	}
	
	p->resetRanges();

	updateList();
	p->updatePixmap();
}

void ListDialog::changeGraph() {
	Plot *plot = p->getPlot(p->API());
	PType type = plot->Type();
	
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);

			if(type == PVTK) 
				(new VTKDialog(p,name,item))->show();
			else if (type == PGRASS)
				(new GRASSDialog(p,name,item))->show();
			else {	// everything else
				if(plot->getGraphList()->getGraph(item)->Source()==SDATA)		// data
					(new DataDialog(p,name,this,item,plot->Type()))->show();
				else		// function
					(new FunctionDialog(p,name,this,item,plot->Type()))->show();
			}
		}
	}
}

//! dump the selected graph data to a file
void ListDialog::dumpGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);
			(new DumpDialog(p->getMainWin(),name,item))->show();
		}
	}
}

//! edit the selected graph data
void ListDialog::editGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);
			
			if(p->getPlot(p->API())->getGraphList()->getStruct(item) == GRAPHIMAGE)
				continue;	// image not editable
			
			(new EditDialog(p,name,item,this))->show();
		}
	}
}

void ListDialog::openSpreadsheet() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());

			GraphList *gl = p->getPlot(p->API())->getGraphList();
			GRAPHType s = gl->getStruct(item);

			Spreadsheet *spreadsheet = p->getMainWin()->newSpreadsheet();
			QTable *table = spreadsheet->Table();
			if(s != GRAPHIMAGE)	// here Number = NX*NY !
				table->setNumRows(gl->getGraph(item)->Number());
			
			if (s == GRAPH2D) {
				Graph2D *g = gl->getGraph2D(item);
				Point *data = g->Data();
				for(int i=0;i<g->Number();i++) {
					table->setText(i,0,QString::number(data[i].X()));
					table->setText(i,1,QString::number(data[i].Y()));
				}
			}
			else if (s == GRAPH3D) {
				Graph3D *g = gl->getGraph3D(item);
				Point3D *data = g->Data();
				table->setNumCols(3);
				table->horizontalHeader()->setLabel( 2, QString( "C [Z]" ) );
				for(int i=0;i<g->Number();i++) {
					table->setText(i,0,QString::number(data[i].X()));
					table->setText(i,1,QString::number(data[i].Y()));
					table->setText(i,2,QString::number(data[i].Z()));
				}
			}
			else if (s == GRAPHM) {
				GraphM *g = gl->getGraphM(item);
				double *data = g->Data();
				table->setNumCols(g->NX());
				table->setNumRows(g->NY());
				// set label for all columns
				for (int i=1;i<table->numCols();i++)
					table->horizontalHeader()->setLabel( i, QChar(i+65)+QString( " [Y]" ) );
				
				for(int i=0;i<g->NY();i++)
					for(int j=0;j<g->NX();j++)
						table->setText(i,j,QString::number(data[j+g->NX()*i]));
			}
			else if (s == GRAPH4D) {
				Graph4D *g = gl->getGraph4D(item);
				Point4D *data = g->Data();
				table->setNumCols(4);
				table->horizontalHeader()->setLabel( 2, QString( "C [Y]" ) );
				table->horizontalHeader()->setLabel( 3, QString( "D [Y]" ) );
				for(int i=0;i<g->Number();i++) {
					table->setText(i,0,QString::number(data[i].X()));
					table->setText(i,1,QString::number(data[i].Y()));
					table->setText(i,2,QString::number(data[i].Z()));
					table->setText(i,3,QString::number(data[i].T()));
				}
			}
			else if (s == GRAPHIMAGE) {
				GraphIMAGE *g = gl->getGraphIMAGE(item);
				QPixmap pm = g->Pixmap();
				table->setNumCols(pm.width());
				table->setNumRows(pm.height());
				// set label for all columns
				for (int i=1;i<table->numCols();i++)
					table->horizontalHeader()->setLabel( i, QChar(i+65)+QString( " [Y]" ) );
				
				QImage image = pm.convertToImage();
				
				for (int i=0;i<pm.width();i++) {
					for (int j=0;j<pm.height();j++) {
						table->setText(j,i,QString::number(qGray(image.pixel(i,j))));
					}
				}
			}
		}
	}
	MainWin *mw = p->getMainWin();
	mw->setActiveSheet(mw->NrWorksheets()+mw->NrSpreadsheets()-1);
}

//! show selected graph info and statistics
void ListDialog::statGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);
			
			(new InfoDialog(p,name,item))->show();
		}
	}
}

// update range (ale-ble) when selecting another graph
void ListDialog::updateRange() {
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->getNumber()==0)
		return;
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType s = gl->getStruct(item);
	LRange range=0;

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		range = g->Range(0);
		ale->setText(QString::number(range.rMin()));
		ble->setText(QString::number(range.rMax()));
	}
}
