/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/

/*
 * morphgraytest.c
 *
 *      (1) Tests basic grayscale morphology, including speed
 *
 *      (2) Tests composite operations: tophat and hdome
 *           (for these, use the image aneurisms8.jpg)
 *
 *      Note that the combination of a gray closing with
 *      a white tophat does very well!
 */

#include <stdio.h>
#include <stdlib.h>
#include "allheaders.h"

#define     SIZE         179
#define     SHAPE        MORPH_SQUARE
#define     HEIGHT       100

    /* 1 for linear erosion,dilation;
       2 for linear open,close and square erosion, dilation
       4 for square open,close */
#define     TIMING_FACTOR       4


main(int    argc,
     char **argv)
{
char        *filein, *fileout;
l_int32      w, h, same;
PIX         *pixs, *pixd, *pixd1, *pixd2;
PIX         *pixt, *pixt2, *pixt3, *pixt3a, *pixt4;
PIXCMAP     *cmap;
static char  mainName[] = "morphgraytest";

    if (argc != 3)
	exit(ERROR_INT(" Syntax:  morphgraytest filein fileout", mainName, 1));

    filein = argv[1];
    fileout = argv[2];

    if ((pixs = pixRead(filein)) == NULL)
	exit(ERROR_INT("pix not made", mainName, 1));

    w = pixGetWidth(pixs);
    h = pixGetHeight(pixs);

	/* choose an operation */
#if 0
    pixd = pixDilateGray(pixs, SIZE, SHAPE);
    pixWrite(fileout, pixd, IFF_JFIF_JPEG);
    pixDestroy(&pixd);
#elif 0
    pixd = pixErodeGray(pixs, SIZE, SHAPE);
    pixWrite(fileout, pixd, IFF_JFIF_JPEG);
    pixDestroy(&pixd);
#elif 0
    pixd = pixOpenGray(pixs, SIZE, SHAPE);
    pixWrite(fileout, pixd, IFF_JFIF_JPEG);
    pixDestroy(&pixd);
#elif 0
    pixd = pixCloseGray(pixs, SIZE, SHAPE);
    pixWrite(fileout, pixd, IFF_JFIF_JPEG);
    pixDestroy(&pixd);
#endif


#if 0
    startTimer();
    pixd = pixCloseGray(pixs, SIZE, SHAPE);
    fprintf(stderr, " Speed is %6.2f MPix/sec\n",
          (float)(TIMING_FACTOR * w * h) / (1000000. * stopTimer()));

    pixWrite(fileout, pixd, IFF_PNG);
    pixDestroy(&pixd);
#endif

#if 0
	/* test tophat duality: black and white */
    pixd = pixTophat(pixs, SIZE, SHAPE, BLACK);
    pixWrite(fileout, pixd, IFF_PNG);

    pixInvert(pixs, pixs);
    pixd2 = pixTophat(pixs, SIZE, SHAPE, WHITE);
    pixEqual(pixd, pixd2, &same);
    if (same == 1)
	fprintf(stderr, "Correct: Images are duals\n");
    else
	fprintf(stderr, "Error: Images are not duals\n");
    pixDestroy(&pixd2);
    pixDestroy(&pixd);
#endif

#if 0
	/* look at tophat result
	 * Parameters: SIZE = 9
	 *             SHAPE = SQUARE  */
    pixd = pixTophat(pixs, SIZE, SHAPE, WHITE);
    pixd2 = pixMaxDynamicRange(pixd, LINEAR_SCALE);
    pixWrite(fileout, pixd2, IFF_PNG);
    pixDestroy(&pixd2);
    pixDestroy(&pixd);
#endif

#if 0
	/* look at closing plus white tophat result
	 * Parameters: SIZE = 19
	 *             SHAPE = SQUARE  */
    pixd = pixCloseGray(pixs, SIZE, SHAPE);
    pixd1 = pixTophat(pixd, SIZE, SHAPE, WHITE);
    pixd2 = pixMaxDynamicRange(pixd1, LINEAR_SCALE);
    pixWrite(fileout, pixd2, IFF_PNG);
    pixDestroy(&pixd1);
    pixDestroy(&pixd2);
    pixDestroy(&pixd);
#endif

#if 0
	/* look at closing plus white tophat result
	 * Parameters: SIZE = 79
	 *             SHAPE = SQUARE  */
    pixd = pixCloseGray(pixs, 1, SHAPE);
    pixd1 = pixTophat(pixd, SIZE, SHAPE, WHITE);
    pixd2 = pixMaxDynamicRange(pixd1, LINEAR_SCALE);
    pixWrite(fileout, pixd2, IFF_PNG);
    pixDestroy(&pixd1);
    pixDestroy(&pixd2);
    pixDestroy(&pixd);
#endif

#if 0
	/* look at hdome result
	 * Parameter: HEIGHT = 100  */
    pixd = pixHDome(pixs, HEIGHT);
    pixd2 = pixMaxDynamicRange(pixd, LINEAR_SCALE);
    pixWrite(fileout, pixd2, IFF_PNG);
    pixDestroy(&pixd2);
    pixDestroy(&pixd);
#endif

#if 0
	/* look at contrast enhancement
	 * Parameters: SIZE = 9
	 *             SHAPE = SQUARE  */

    pixd1 = pixInitAccumulate(w, h, 0x8000);
    pixAccumulate(pixd1, pixs, ADD);
    pixMultConstAccumulate(pixd1, 3., 0x8000); 
    pixd2 = pixOpenGray(pixs, SIZE, SHAPE);
    pixAccumulate(pixd1, pixd2, SUBTRACT);
    pixDestroy(&pixd2);
    pixd2 = pixCloseGray(pixs, SIZE, SHAPE);
    pixAccumulate(pixd1, pixd2, SUBTRACT);
    pixDestroy(&pixd2);
    pixd = pixFinalAccumulate(pixd1, 0x8000, 8);
    pixd2 = pixMaxDynamicRange(pixd, LINEAR_SCALE);
    pixWrite(fileout, pixd, IFF_PNG);
    pixDestroy(&pixd);
    pixDestroy(&pixd1);
    pixDestroy(&pixd2);
#endif

#if 1
        /* Tophat result on feynman stamp, to extract diagrams */
    pixDestroy(&pixs);
    pixs = pixRead("feynman-stamp.jpg");

        /* Make output image to hold five intermediate images */
    w = pixGetWidth(pixs);
    h = pixGetHeight(pixs);
    pixd = pixCreate(5 * w + 18, h + 6, 32);  /* composite output image */
    pixSetAllArbitrary(pixd, 0x0000ff00);  /* set to blue */

        /* Paste in the input image */
    pixt = pixRemoveColormap(pixs, REMOVE_CMAP_TO_FULL_COLOR);
    pixRasterop(pixd, 3, 3, w, h, PIX_SRC, pixt, 0, 0);  /* 1st one */
    pixDisplay(pixt, 100, 100);
    pixWrite("junkgray", pixt, IFF_JFIF_JPEG);
    pixDestroy(&pixt);

        /* Paste in the grayscale version */
    cmap = pixGetColormap(pixs);
    if (cmap)
	pixt = pixRemoveColormap(pixs, REMOVE_CMAP_TO_GRAYSCALE);
    else
        pixt = pixConvertRGBToGray(pixs, 0.33, 0.34, 0.33);
    pixt2 = pixConvertTo32(pixt);  /* 8 --> 32 bpp */
    pixRasterop(pixd, w + 6, 3, w, h, PIX_SRC, pixt2, 0, 0);  /* 2nd one */
    pixDestroy(&pixt2);

        /* Paste in a log dynamic range scaled version of the white tophat */
    pixt2 = pixTophat(pixt, 3, MORPH_SQUARE, TOPHAT_WHITE);
    pixt3a = pixMaxDynamicRange(pixt2, L_LOG_SCALE);
    pixt3 = pixConvertTo32(pixt3a);
    pixRasterop(pixd, 2 * w + 9, 3, w, h, PIX_SRC, pixt3, 0, 0);  /* 3rd */
    pixWrite("junktophat", pixt2, IFF_JFIF_JPEG);
    pixDisplay(pixt2, 100, 250);
    pixDestroy(&pixt3);
    pixDestroy(&pixt3a);
    pixDestroy(&pixt);

        /* Stretch the range and threshold to binary; paste it in */
    pixt3a = pixGammaTRC(NULL, pixt2, 1.0, 0, 80);
    pixt3 = pixThresholdToBinary(pixt3a, 70);
    pixt4 = pixConvertTo32(pixt3);
    pixRasterop(pixd, 3 * w + 12, 3, w, h, PIX_SRC, pixt4, 0, 0);  /* 4th */
    pixWrite("junkbin", pixt3, IFF_PNG);
    pixDisplay(pixt3, 100, 400);
    pixDestroy(&pixt2);
    pixDestroy(&pixt3a);
    pixDestroy(&pixt4);

        /* Invert; this is the final result */
    pixInvert(pixt3, pixt3);
    pixt4 = pixConvertTo32(pixt3);
    pixRasterop(pixd, 4 * w + 15, 3, w, h, PIX_SRC, pixt4, 0, 0);  /* 5th */
    pixWrite("junkbininvert", pixt3, IFF_PNG);
    pixDisplay(pixt3, 100, 550);
    pixWrite("junkall", pixd, IFF_JFIF_JPEG);
    pixDestroy(&pixt3);
    pixDestroy(&pixt4);
    pixDestroy(&pixd);
#endif

    pixDestroy(&pixs);
    exit(0);
}

