/***************************************************************************
                          ai_tools.h  -  description
                             -------------------
    begin                : Wed Mar 28 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __AI_TOOLS_H
#define __AI_TOOLS_H

#define AI_DEBUG

/*
====================================================================
This is a collection of tools to help analysing the situation the
AI is in and to find the best action for the currently selected
unit (which is done in ai.c:ai_get_action().
====================================================================
*/

/*
====================================================================
Create a static list of all units that belong to the player_id.
====================================================================
*/
Unit** get_player_units( Engine *engine, int player_id, int *unit_count );

/*
====================================================================
Check if either ammo or fuel dropped below a sperrbestand (not much
left :-)
====================================================================
*/
int ai_low_ammo();
int ai_low_fuel();
/*
====================================================================
Check if cur_unit may supply anything.
====================================================================
*/
int ai_may_supply();

/*
====================================================================
Check flags of current unit.
====================================================================
*/
int ai_is_flying();

/*
====================================================================
Scan the surrounding for an airfield and check if it's in
fuel-range of cur_unit. If so return 1 and setup an MOVE action
heading for this airfield (if it's not reached in one turn
this function will be called again)
====================================================================
*/
int ai_find_airfield( AI_Action *action );

/*
====================================================================
Find a target for this unit. Depending on type movement is
allowed or not allowed. The taken action (ATTACK, MOVE_ATTACK)
is set and 1 is returned if successful.
Note: AI_ALLOW_MOVE is only allowed for flying units.
====================================================================
*/
enum { AI_ALLOW_MOVE = 0, AI_DENY_MOVE };
int ai_find_target( Engine *engine, int type, AI_Action *action );

#endif
