/***************************************************************************
                          cpanel.h  -  description
                             -------------------
    begin                : Sun Mar 5 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

#ifndef CPANEL_H
#define CPANEL_H

#include <qframe.h>
#include <qtabbar.h>
#include <qpainter.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qbuttongroup.h>

#include <qlineedit.h>

#include "parameter.h"
#include "cdisplay.h"
/**Contains all the Controlelements for receiving and xmitting
  *@author Volker Schroer
  */
extern Parameter settings;
class CPanel : public QFrame  {
 Q_OBJECT
public: 
	CPanel(QWidget *parent, const char *name = 0);
	~CPanel();

CDisplay	*display; // Display for FFT/Input and so on in the middle of the Panel

// Elements on the right side of the Panel
QPushButton *CWID;
QPushButton *Tune;
QPushButton *Clear;
QPushButton *ClearQsoInfo;
QLineEdit	*theircall;
QLineEdit *Name;
QButtonGroup *Macros;
QPushButton *UserDefined;

private:

QTabBar *header;    // Header of Display for selecting  the kind of Display
 QTab *spectrum;
 QTab *waterfall;
 QTab *input;
// QTab *datasync;
//	int tablist[4];
	int tablist[3];

/** Displayelement for maxfreq */
QSpinBox *lmaxfreq;
/** Displayelement for minfreq */
QSpinBox *lminfreq;
/** Select smoothing Filter for FFT */
QRadioButton *slow;
QLabel *TheirCallL;
QLabel *NameL;
QGroupBox *QSOInfo;


/** Buttons for Macros and so on */
QPushButton *QSOStart; 	//QSOStart
QPushButton *QSOBTU;		//BTU
QPushButton *Final;			//QSO Final
QPushButton *CQ;				// CQ
QPushButton *SendFile;	// Send Special File


protected:


/** Handling Resizing */
void resizeEvent(QResizeEvent *);
/** Calculating Size of Frame and depending Windows*/

public slots:
void viewchanged(int);



///void getTheirCall();
void saveTheirCall(const QString &);
void NameChanged();
void saveName(const QString &);
  /** copies the marked string from the active RX window to Remote Call or Name
depending on which window has the focus
If no windo has the focus the Remote call is taken */
  void setString(const QString  &String);
signals:
protected slots: // Protected slots
  /** Clears the Fields fin QSOInfo */
  void clearQsoInfo();
};

#endif
