/***************************************************************************
                          rttydemodulator.cpp  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "rttydemodulator.h"

RTTYDemodulator::RTTYDemodulator():CDemodulator()
{
ShiftOn = false;
NumberOfStopBits = 2;
parity = 0;
x1=0;

NxSamples = 0;

twiddles = NULL;
bins = NULL;
history = NULL;
FrequencyNumber = NULL;
// Disable PhaseDisplay

}
RTTYDemodulator::~RTTYDemodulator()
{
if (twiddles != NULL)
  delete twiddles;

if (bins != NULL)
	delete bins;

if (history != NULL )
	delete history;
if (FrequencyNumber != NULL)
	delete FrequencyNumber;
}
/** returns the asci char corresponding to the baudot code */
char RTTYDemodulator::baudot_code(char data)
{
/** Table of letters */

static const char letters[32] =	{0x00,'E','\n','A',' ','S','I','U',
								 '\n','D','R','J','N','F','C','K',
								 'T','Z','L','W','H','Y','P','Q',
								 'O','B','G','^','M','X','V','^'};


/** Table of symbols */
static const char symbols[32] = {0x00,'3','\n','-',' ',',','8','7',
 '\n','$','4','#',',','',':','(',
 '5','+',')','2','','6','0','1',
'9','7','','^','.','/','=','^'};

char c;

	switch (data)
	 {
		case 0x1f :
				ShiftOn = false;  //LTRS
				c = 0;
				break;
		case 0x1b :
		 		ShiftOn = true;   //FIGS
		 		c = 0;
		  	break;
		default:	if (!ShiftOn)
								c=letters[data];
							 else
							 c=symbols[data];
						 break;
 		}


if ( c == ' ')				// Unshift on Space
	ShiftOn =false;	

return c;
}

bool RTTYDemodulator::Init(double FS,int NumberOfSamples)
{

int i;
float x;

Baudrate=45;
NumberOfBits=5;
NxSamples=NumberOfSamples;
SamplesPerBit=int (FS/Baudrate+0.5);
SampleRate=FS;
Status = WaitingForMark;
actSample=0;
data=0;
BitsInData=0;
bitcounter=0;
c=0;
count=0;

FrequencyChanged = false;


ave1=0.0;
ave2=0.0;



if ( (twiddles = new float_complex [SamplesPerBit]) == NULL )
	return false;

if ( (bins = new float_complex[NumberofTones]) == NULL )
	return false;

if ( (history = new float[SamplesPerBit] ) == NULL )
	return false;
if ( (FrequencyNumber=new int[NumberofTones]) == NULL )
	return false;
ptr = 0;

setRxFrequency(1000.);

// Initialize the coefficients for the slfft

for (i=0;i < SamplesPerBit; i++)
	{
		x =2*i * M_PI*Baudrate/FS;
		twiddles[i] = float_complex( cos(x), sin(x) ) ;
	}

for (i=0;i<SamplesPerBit; i++)
{
history[i]= 0.;
}
for(i=0;i<NumberofTones;i++)
		bins[i]= float_complex(0.,0.);
return true;
}

void RTTYDemodulator::ProcessInput(double *input)
{





char c1;

bool bit;

DataAvailable = true;	// Just read the data
actSample = 0;				// Start processing, counter will be incremented while processing
											// the next value
data=input;	
while (DataAvailable)
	{
		switch (Status)
			{
				case WaitingForMark:
						while ( DataAvailable ) 				// Waiting for Mark
		 					if (ProcessNextSample() > 0)
							{
								Status = WaitingForSpace;   // We seem to have found Mark, so we can wait for
								break;                     // Space
							}
				break;
				
				case WaitingForSpace:   	           // Mark seems to be found, now waiting for transition																																
						while ( DataAvailable )					 // Waiting for transition
							if (ProcessNextSample() < 0 ) 		
							{
								Status  = CheckingStartBit;  // Transition seems to be found	
								bitcounter = SamplesPerBit/2;
								CalcQuality();
								break;
							}
						break;				
							
				case CheckingStartBit:

					while ( DataAvailable  )
							if ( --bitcounter > 0)
								ProcessNextSample();
							else
					if ( ProcessNextSample() > 0 ) 		// 0.5 bit processed
							{
								Status  = WaitingForSpace; // Was'nt the correct start bit, as we found Mark
								break;                     // here , so go and look for another Space
							}	
						else
							{		
///								Status = SkipRestOfStartBit;   // We are tight behind the midle of the Startbit
								Status = CollectingByte;   // We are tight behind the midle of the Startbit

///							bitcounter = SamplesPerBit/4;
///								bitcounter =1;
///                CalcQuality();
								Frequencykor = 0;
								bitcounter =5;
                CalcQuality();
                reset();
								break;
							}
						
					break;				// We've reached the end of the available data or completed Status

        case SkipRestOfStartBit:
					while ( DataAvailable && (--bitcounter > 0) )
						if  ( ProcessNextSample() > 0 )		// Oops, already Mark
							{
								Status = CollectingByte;
								bitcounter = 5;
								reset();
								count = 10;										// This is only aguess
								break;
							}
					if ( bitcounter == 0 )			// Normal end of skip
						{
								Status = CollectingByte;
								bitcounter = 5;
								reset();
								break;
						}
					break;
				case CollectingByte:
					while( DataAvailable && (bitcounter > 0) )
						{
							bit=get_next_bit();							
							if ( DataAvailable )
								{
									if (bit)
										BitsInData++;
									bitcounter--;
									c >>=1;
									if (bit)
										c |= 128;
								}									
							else
								break;			// No more data to be processed at the moment	
							
						}
					if ( bitcounter == 0 ) // Data 'byte' completed
						{
							c >>= (8- NumberOfBits);
							Status = CheckingParity;
							c1=c;
							c1 = baudot_code(c1);  // FIGS or LTRS result in c1 = 0 !
							if ( c1 > 0 )
								emit newSymbol( c1 );
						}	
							
					break;	
					
				case CheckingParity:

					if (parity)
						{
							bit=get_next_bit();
							if (	DataAvailable )
								{
									if (bit)
										BitsInData++;
									if (parity == 1 ) // even
										{
										if ( BitsInData & 1)	// error						
											{
											emit newSymbol('<');
											emit newSymbol('P');
											emit newSymbol('>');
											}
										}
									else							// odd
										{
										if (! (BitsInData & 1))	// error						
											{
											emit newSymbol('<');
											emit newSymbol('P');
											emit newSymbol('>');
											}
										}
									
									}
									else
										break;
								}	
								Status =WaitingForStopBits;
								BitsInData = 0;
//								bitcounter=NumberOfStopBits;
								bitcounter =1;
							
				break;	
									
				case WaitingForStopBits:
					while ( DataAvailable && bitcounter >0 )
						{
						bit = get_next_bit();
						if ( DataAvailable)		// We've got a bit
							{
								bitcounter --;
								if  (!bit)		// Framing Error
									{
									emit newSymbol('<');
									emit newSymbol('F');
									emit newSymbol('>');
      						Status = CollectingByte;   // Lets try whether this was already the start bit
///									Status = WaitingForMark;
									bitcounter=NumberOfBits;
									c=0;
									if ( (Frequencykor != 0) && UseAfc && (ave1 > 0.35))
									{
										emit rxFrequencyChanged( RxFrequency + Frequencykor);
                    setRxFrequency ( RxFrequency + Frequencykor);
										Frequencykor =0;
									}
			            break;
									}
								else
							{
										
								c=0;
///								Status=WaitingForSpace;
								Status=WaitingForMark;

								if ( ( Frequencykor != 0) && UseAfc && ( ave1 >0.35 ))
									{
										emit rxFrequencyChanged( RxFrequency + Frequencykor);
                    setRxFrequency ( RxFrequency + Frequencykor);
										Frequencykor =0;
                  }
								break;
							}	

							}
						}
				
				break;
				
				case ThrowHalfBit:
					while ( DataAvailable && --bitcounter > 0)
						ProcessNextSample();
					if ( bitcounter == 0 )
						Status = WaitingForMark;
				break;			
						
		}	// End switch	
	}	// End While
}

int RTTYDemodulator::ProcessNextSample()
{
float x;
float z[NumberofTones];
int i,index;
if ( actSample<NxSamples )
	{
	DataAvailable = true;
	x= (float) data[actSample];
	actSample++;
  slfft(x);
	for (i=0;i < NumberofTones; i++)
		z[i] = abs(bins[i]);

index=0;
x= z[0];
for (i=1;i <NumberofTones;i++)
	{
	if (z[i]> x)
		{
			index = i;
			x = z[i];
		}
	}
	if ( index > 3)
		return 1;
	else
		return -1;
	}
else
	DataAvailable = false;
	
return 0;		
}



bool RTTYDemodulator::get_next_bit()
{

int x;
float z[NumberofTones],y;
int i, index;

/*while (DataAvailable)
	{
 	if (count != SamplesPerBit )
			{
				if ( actSample<NxSamples )
				{
					z= (float) data[actSample];
					count++;
					actSample++;
  				slfft(z);
				}
				else
					DataAvailable = false;
				x = 0;
			}
	else
		{
			x = ProcessNextSample();
			CalcQuality();
      reset();
			break;
  	}
	}*/
while (DataAvailable)
	{
	if ( actSample < NxSamples)
		{
			y= (float) data[actSample];
			count++;
			actSample++;
			slfft(y);
			if ( count == SamplesPerBit)
				{
					if (UseAfc)
						{
							for (i=0;i < NumberofTones; i++)
								z[i] = abs(bins[i]);

							index=0;
							y	= z[0];
							for (i=1;i <NumberofTones;i++)
								{
									if (z[i]> y)
									{
										index = i;
										y = z[i];
									}
								}
							if ( z[1] > z[5] )
								x = -1;
							else
								x =1;
							switch (index)
								{
									case 1:       // Frequency is ok
									case 5:
										break;
									case 0:				// Frequency is too high
									case 4:
										Frequencykor -= 1;
										break;
									case 2: 			// Frequency is too low
									case 6:
										Frequencykor += 1;
										break;
									default:
										break;
								}	
									
						}
					else
						if ( abs(bins[1]) > abs(bins[5]) )
							x= -1;
						else
							x =1;
          CalcQuality();
					reset();
					break;
				}
		}
	 else
		{
			DataAvailable = false;
			x = 0;
		}
	}
return ( (x > 0 ) ? true : false) ;	
}

void RTTYDemodulator::slfft(float x)
{
float old;

///old = x - history[ptr];
old = history[ptr];

history[ptr] = x;
ptr = (ptr +1) % SamplesPerBit;

for (int i=0; i <NumberofTones;i++)
  	bins[i] = bins[i]*twiddles[FrequencyNumber[i]] +x - old;
	
}

void RTTYDemodulator::setRxFrequency(double freq)
{
int i;
if ( freq != RxFrequency)
	{
		RxFrequency=freq;
		for(i=0; i < NumberofTones; i++)
			bins[i]=float_complex(0.0,0.0);

		FrequencyNumber[1]= (RxFrequency*SamplesPerBit)/SampleRate+0.5;
		FrequencyNumber[0] = FrequencyNumber[1] - 1;
		FrequencyNumber[2] = FrequencyNumber[1] + 1;
		FrequencyNumber[3] = FrequencyNumber[2] + 1;
		FrequencyNumber[5]= ( (RxFrequency+170) *SamplesPerBit)/SampleRate+0.5;
		FrequencyNumber[4] = FrequencyNumber[5] - 1;
		FrequencyNumber[6] = FrequencyNumber[5] + 1;
   }
}

void RTTYDemodulator::CalcQuality()
{
ave2=ave1;
float sum,diff;
sum=abs(bins[1])+abs(bins[5]);
diff=abs( abs(bins[1])-abs(bins[5]));
//ave1=0.8*ave1 + 0.2 * abs(y0-y1)/(y0+y1);
if ( sum > 0.5 )
	ave1=0.7*ave1 + 0.25 * ave2 + 0.05 * diff/sum;
else
	ave1 = 0.5*ave1 + 0.3 *ave2;
emit setSquelchValue((int)(100*ave1));
}




void RTTYDemodulator::reset()
{
int i;

for(i=0;i<NumberofTones;i++)
			bins[i]=float_complex(0.0,0.0);
for(i=0;i < SamplesPerBit; i++)	
			history[i]=0.;
count =0;
x1=0;

}
