/**
 * \file math_diminset.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Andr Pnitz
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "math_diminset.h"
#include "coordcache.h"
#include "debug.h"


MathDimInset::MathDimInset()
{}


int MathDimInset::ascent() const
{
	return dim_.asc;
}


int MathDimInset::descent() const
{
	return dim_.des;
}


int MathDimInset::width() const
{
	return dim_.wid;
}


void MathDimInset::setPosCache(PainterInfo const &, int x, int y) const
{
	//lyxerr << "MathDimInset: cache to " << x << " " << y << std::endl;
	theCoords.insets().add(this, x, y);
}
