-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--
-------------------------------------------------------------------------------

with Ada.Numerics.Discrete_Random,
     Quick_Sort,
     Text_Io;
use  Text_Io;
procedure TestQSort is

   package Rand is new Ada.Numerics.Discrete_Random (Integer);

   type Integer_Array is array (Natural range <>) of Integer;

   procedure Int_Qsort is new Quick_Sort (Natural, Integer, Integer_Array);

   Int_Array : Integer_Array (1 .. 10);

   Gen       : Rand.Generator;

begin
   Put_Line ("Generate Random Numbers");
   Rand.Reset (Gen);
   for I in Int_Array'Range loop
      Int_Array (I) := Rand.Random (Gen);
   end loop;
   Put_Line ("Starting with:");
   for I in Int_Array'Range loop
      Put_Line (Integer'Image (Int_Array (I)));
   end loop;

   Put_Line ("Now sorting Random Numbers");
   Int_Qsort (Int_Array);

   Put_Line ("Result:");
   for I in Int_Array'Range loop
      Put_Line (Integer'Image (Int_Array (I)));
   end loop;
end TestQSort;
