-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--  April, 2 1998 H.-F. Vogt
--
-------------------------------------------------------------------------------


-- ----------------------------------------------------------------------------
--
--  Hello_World program
--
--  example program to adabindx
--
-- ----------------------------------------------------------------------------
with X_Lib,
     X_Lib.Tasking,
     X_Misc_Utils,
     X_Toolkit,
     Xm_Widgets,
     Xm_Widgets.Primitive.Label.Push_Button,
     Xm_Widgets.Manager.Bulletin_Board.Message_Box,
     Hello_World_Global;
procedure Hello_World is

   use X_Misc_Utils,
       X_Toolkit,
       Xm_Widgets,
       Xm_Widgets.Primitive.Label,
       Xm_Widgets.Primitive.Label.Push_Button,
       Xm_Widgets.Manager.Bulletin_Board.Message_Box,
       Hello_World_Global;

   Xmstr   : Xm_String;

begin
   -- be sure only one task communicates with the X-Server, so that
   -- non-tasksafe Xlibs can also be used
   X_Lib.Tasking.Resource.Seize;

   -- begin communication with the X-Server
   Xt_App_Initialize (Appshell, App_Con, "HelloWorld");

   -- allow the "editres"-Utility to inspect the resources of this program
   Xt_Add_Event_Handler (Appshell, X_Lib.No_Events, True,
      X_Edit_Res_Check_Messages'Access, Null_Xt_Pointer);

   -- create a push button, if pushed, pop open a dialog
   Argl := Null_Arg_List;
   Xmstr := Xm_String_Create_L_To_R ("Hello Ada-World");
   Append_Set (Argl, Xm_N_Label_String, Xmstr);
   the_push := Xm_Create_Push_Button (Appshell, "the_push", Argl);
   Xt_Manage_Child (the_push);
   Xm_String_Free (Xmstr);

   Argl := Null_Arg_List;
   Append_Set (Argl, Xm_N_Width, Integer'(200));
   Append_Set (Argl, Xm_N_Height, Integer'(150));
   Xt_Set_Values (the_push, Argl);

   -- link callback procedure to the label
   Xt_Add_Callback (the_push, Xm_N_Activate_Callback, Hello_World_Global.Show_Dialog_CB'Access);

   -- realize the widget tree
   Xt_Realize_Widget (Appshell);

   -- let the X-Toolkit organize the reactions upon keypress and other events
   Xt_App_Main_Loop (App_Con);

end Hello_World;
