-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2002 Hans-Frieder Vogt                                --
--                                                                           --
--  Adabindx is free software; you can redistribute it and/or modify it      --
--  under the terms of the GNU General Public License as published by the    --
--  Free Software Foundation; either version 2 of the License, or (at your   --
--  option) any later version.                                               --
--                                                                           --
--  This program is distributed in the hope that it will be useful, but      --
--  WITHOUT ANY WARRANTY; without even the implied warranty of               --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--  As a special exception, if other files instantiate generics from this    --
--  unit, or you link this unit with other files to produce an executable,   --
--  this unit does not by itself cause the resulting executable to be        --
--  covered by the GNU General Public License. This exception does not       --
--  however invalidate any other reasons why the executable file might be    --
--  covered by the GNU General Public License.                               --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                  and by The Open Group                                    --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          Nov 14, 1998 HFVogt: X_List_Extensions is in X_Lib.Extensions now!
--          9 Feb 2002 H.-F. Vogt: sort extension before listing them
--
-------------------------------------------------------------------------------

with X_Toolkit,
     X_Lib.Extensions,
--     X_Lib.Tasking,
     Ada.Text_Io,
     Bubble_Sort,
     String_List;
use  X_Toolkit,
     X_Lib,
     Ada.Text_Io,
     String_List;
procedure Show_Extensions is

   Appshell : Widget;
   Display  : Display_Pointer;
   App_Con  : Xt_App_Context;

   Exts : Element_Access_List;

   type String_Access is access all String;
   type String_Array  is array (Natural range <>) of String_Access;

   function "<" (Left, Right : in String_Access) return Boolean is
   begin
      return Left.all < Right.all;
   end "<";

   --  sort routine
   procedure String_Sort is
      new Bubble_Sort (Natural, String_Access, String_Array, "<");

begin
--   X_Lib.Tasking.Resource.Seize;

   Xt_App_Initialize (Appshell, App_Con, "ShowHosts");
   Display := Xt_Display (Appshell);

   Exts := Extensions.X_List_Extensions (Display);
   declare
      Arry : String_Array (1 .. Length (Exts));
   begin
      for I in Arry'Range loop
         Arry (I) := new String'(Element (Exts, I));
      end loop;
      String_Sort (Arry);
      for I in Arry'Range loop
         Ada.Text_Io.Put_Line (Arry (I).all);
      end loop;
   end;

end Show_Extensions;
