--***********************************************************************
--									*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that the above copyright notice and this paragraph are	*
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

-- modified for use with Adabindx 10.8.1997
-- Hans-Frieder Vogt (vogt@ilaws6.luftfahrt.uni-stuttgart.de)

with COLORS;
package RUBIKS_CUBE is

    subtype COLOR_TYPE is COLORS.COLOR;

    type FACE_TYPE is range 0..5;

    type CUBE_TYPE is array(FACE_TYPE) of COLOR_TYPE;

    type CUBE_POSITION_TYPE is range 0..26;

    type RUBIKS_CUBE_TYPE is array(CUBE_POSITION_TYPE) of CUBE_TYPE;

    type AXIS_TYPE is (I,J,K);

    type LEVEL_TYPE is range -1..1;

    type TURN_TYPE is (CLOCKWISE, ANTICLOCKWISE);

    function TO_FACE(I,J,K : LEVEL_TYPE) return FACE_TYPE;
	-- only 1 of I,J,K may be non-zero

    function TO_CUBE_POSITION(I,J,K : LEVEL_TYPE) return CUBE_POSITION_TYPE;

    function ROTATE(
	R : RUBIKS_CUBE_TYPE;
	A : AXIS_TYPE;
	L : LEVEL_TYPE;
	T : TURN_TYPE) return RUBIKS_CUBE_TYPE;

end;
