# $Id: qt.m4,v 1.2 2002/10/29 00:39:36 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for QT 2-3


AC_DEFUN(AQ_CHECK_QT,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   $1 = "yes" if QT is needed, "no" if QT is optional
dnl   $2 = subdirs to include when QT is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_qt - set to "yes" if QT exists
dnl     qt_includes - path to includes
dnl     qt_libs - path to libraries
dnl     qt_app - qt apps given as the argument to this funtion
dnl     qt_install_dir - install directory for qt3 applications
dnl     qt_generation - major version of qt
dnl     qt_generation - major version of qt
dnl   Defines:
dnl     HAVE_QT
dnl USED MACROS:
dnl  AQ_CHECK_QT2
dnl  AQ_CHECK_QT3
dnl NOTES:
dnl  This macro is not called by AQ_CHECK_KDE as you would expect.
dnl  Each KDE check (like AQ_CHECK_KDE2 and AQ_CHECK_KDE3) directly
dnl  calls the macro for its appropriate QT version:
dnl  - AQ_CHECK_KDE2 calls AQ_CHECK_QT2
dnl  - AQ_CHECK_KDE3 calls AQ_CHECK_QT3
dnl  AQ_CHECK_KDE simply calls AQ_CHECK_KDE3 and/or AQ_CHECK_KDE2, so this
dnl  macro here is only for your conveniance, to be used if you want to build
dnl  QT applications instead of KDE apps.

ops="$1"
lsd="$2"

dnl check if qt apps are desired
AC_MSG_CHECKING(if QT applications should be compiled)
AC_ARG_ENABLE(qt,
  [  --enable-qt         enable compilation of qt applications (default=yes)],
  enable_qtapps="$enableval",
  enable_qtapps="yes")
AC_MSG_RESULT($enable_qtapps)

if test "$enable_qtapps" = "no"; then
   qt_libs=""
   qt_includes=""
   qt_app=""
   qt_moc=""
   qt_uic=""
   have_qt="no"
else
   dnl check for QT3
   have_qt="no"
   have_qt3="no"
   AQ_CHECK_QT3("no",[$lsd])
   if test "$have_qt3" = "yes"; then
   	qt_app="$qt3_app"
        qt_libs="$qt3_libs"
        qt_includes="$qt3_includes"
   	qt_moc="$qt3_moc"
   	qt_uic="$qt3_uic"
        qt_generation="3"
        have_qt="yes"
   else
   	dnl check for QT2
   	have_qt2="no"
   	AQ_CHECK_QT2("no",[$lsd])
   	if test "$have_qt2" = "yes"; then
   		qt_app="$qt2_app"
        	qt_libs="$qt2_libs"
        	qt_includes="$qt2_includes"
   		qt_moc="$qt2_moc"
   		qt_uic="$qt2_uic"
        	qt_generation="2"
        	have_qt="yes"
   	fi
   fi
   dnl check if qt found
   AC_MSG_CHECKING(for QT version to be used)
   if test "$have_qt" != "yes"; then
   	if test "$ops" = "yes"; then
        	AC_MSG_ERROR([
  I could not find a suitable QT version while checking for QT2 and QT3.
  If you do not want QT applications to be compiled please use 
  --disable-qt.])
  	else
        	AC_MSG_RESULT(none)
   	fi
   else
   	AC_MSG_RESULT(version $qt_generation)
        AC_DEFINE(HAVE_QT)
        AC_DEFINE_UNQUOTED(QT_GENERATION,$qt_generation)
   fi
dnl end of if "$enable_qtapps"
fi

AC_SUBST(qt_app)
AC_SUBST(qt_libs)
AC_SUBST(qt_includes)
AC_SUBST(qt_moc)
AC_SUBST(qt_uic)
AC_SUBST(qt_generation)
])
