/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.IterableMap;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.apache.commons.collections.iterators.EntrySetMapIterator;
import org.apache.commons.collections.iterators.UnmodifiableMapIterator;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.collections.map.UnmodifiableEntrySet;
import org.apache.commons.collections.set.UnmodifiableSet;

public final class UnmodifiableMap
extends AbstractMapDecorator
implements IterableMap,
Unmodifiable,
Serializable {
    private static final long serialVersionUID = 2737023427269031941L;

    public static final Map decorate(Map map) {
        if (map instanceof Unmodifiable) {
            return map;
        }
        return new UnmodifiableMap(map);
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public final Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public final void putAll(Map mapToCopy) {
        throw new UnsupportedOperationException();
    }

    public final Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public final MapIterator mapIterator() {
        if (this.map instanceof IterableMap) {
            MapIterator it = ((IterableMap)this.map).mapIterator();
            return UnmodifiableMapIterator.decorate(it);
        }
        EntrySetMapIterator it = new EntrySetMapIterator(this.map);
        return UnmodifiableMapIterator.decorate(it);
    }

    public final Set entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    public final Set keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    public final Collection values() {
        Collection coll = super.values();
        return UnmodifiableCollection.decorate(coll);
    }

    private UnmodifiableMap(Map map) {
        super(map);
    }
}

