/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 36 "./parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>
#include <assert.h>

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperatorType
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_TYPE_AND;
	case 'O':
		return GDA_SQL_OPERATOR_TYPE_OR;
	case 'N':
		return GDA_SQL_OPERATOR_TYPE_NOT;
	case '=':
		return GDA_SQL_OPERATOR_TYPE_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_TYPE_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_TYPE_IN;
		else if (op[1] == 'I')
			return GDA_SQL_OPERATOR_TYPE_ILIKE;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_TYPE_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_TYPE_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_TYPE_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_TYPE_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_TYPE_CONCAT;
		else
			return GDA_SQL_OPERATOR_TYPE_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_TYPE_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_TYPE_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_TYPE_STAR;
	case '/':
		return GDA_SQL_OPERATOR_TYPE_DIV;
	case '%':
		return GDA_SQL_OPERATOR_TYPE_REM;
	case '&':
		return GDA_SQL_OPERATOR_TYPE_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperatorType
string_to_op_type (GValue *value)
{
	GdaSqlOperatorType op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator_type == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator_type = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperatorType op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret = NULL;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 208 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    gda_sql_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is gda_sql_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    gda_sql_parserARG_SDECL     A static variable declaration for the %extra_argument
**    gda_sql_parserARG_PDECL     A parameter declaration for the %extra_argument
**    gda_sql_parserARG_STORE     Code to store %extra_argument into yypParser
**    gda_sql_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 209
#define YYACTIONTYPE unsigned short int
#define gda_sql_parserTOKENTYPE GValue *
typedef union {
  int yyinit;
  gda_sql_parserTOKENTYPE yy0;
  GSList * yy33;
  CaseBody yy51;
  gboolean yy100;
  GSList* yy105;
  GdaTransactionIsolation yy197;
  Distinct * yy249;
  GdaSqlStatement * yy252;
  GdaSqlSelectFrom * yy259;
  GdaSqlOperatorType yy295;
  GdaSqlExpr * yy302;
  GdaSqlParamSpec * yy303;
  GdaSqlExpr* yy354;
  GdaSqlSelectJoinType yy367;
  Limit yy408;
  GdaSqlSelectTarget * yy414;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define gda_sql_parserARG_SDECL GdaSqlParserIface *pdata;
#define gda_sql_parserARG_PDECL ,GdaSqlParserIface *pdata
#define gda_sql_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define gda_sql_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 361
#define YYNRULE 196
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1354)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    39,   38,  242,  361,  239,  558,  143,   22,  121,  323,
 /*    10 */   101,  362,   36,   41,   41,   41,   41,   37,   37,   37,
 /*    20 */    37,   37,  134,   45,   45,  357,   48,   50,   50,   49,
 /*    30 */    47,   47,   42,  240,  349,  348,  161,  347,  346,  345,
 /*    40 */   344,  190,  133,   43,   44,  199,   13,  234,  334,   76,
 /*    50 */    40,   40,   36,   41,   41,   41,   41,   37,   37,   37,
 /*    60 */    37,   37,  352,   45,   45,  318,  171,   50,   50,   49,
 /*    70 */    47,   47,   42,  291,  317,  313,  224,  223,  196,  195,
 /*    80 */   194,  225,  259,  258,  189,  218,   39,   38,   66,   76,
 /*    90 */   242,  314,  239,  278,  191,   21,   51,  215,   93,   41,
 /*   100 */    41,   41,   41,   37,   37,   37,   37,   37,    1,   45,
 /*   110 */    45,  226,  309,   50,   50,   49,   47,   47,   42,  174,
 /*   120 */   352,  240,  349,  211,  214,  169,  168,  167,  351,   43,
 /*   130 */    44,  199,   13,  234,  334,   76,   40,   40,   36,   41,
 /*   140 */    41,   41,   41,   37,   37,   37,   37,   37,  222,   45,
 /*   150 */    45,  307,  129,   50,   50,   49,   47,   47,   42,   39,
 /*   160 */    38,  242,   37,  300,   45,   45,  353,  193,   50,   50,
 /*   170 */    49,   47,   47,   42,  328,   76,  347,  346,  345,  344,
 /*   180 */   141,   71,  169,  168,  167,  358,  351,  221,  360,  359,
 /*   190 */    76,  180,  267,  169,  168,  167,    6,  257,  274,  169,
 /*   200 */   168,  167,   43,   44,  199,   13,  234,  334,  335,   40,
 /*   210 */    40,   36,   41,   41,   41,   41,   37,   37,   37,   37,
 /*   220 */    37,  372,   45,   45,  353,   48,   50,   50,   49,   47,
 /*   230 */    47,   42,   39,   38,  305,  372,  372,  343,  280,   37,
 /*   240 */    37,   37,   37,   37,  352,   45,   45,  128,   76,   50,
 /*   250 */    50,   49,   47,   47,   42,  364,  285,  231,   28,  342,
 /*   260 */    26,  283,   34,  364,  364,  364,  284,  169,  168,  167,
 /*   270 */   220,   76,  282,  281,   46,   43,   44,  199,   13,  234,
 /*   280 */   334,  352,   40,   40,   36,   41,   41,   41,   41,   37,
 /*   290 */    37,   37,   37,   37,  216,   45,   45,  192,  338,   50,
 /*   300 */    50,   49,   47,   47,   42,  179,  298,   39,   38,  242,
 /*   310 */   351,  239,  238,  188,  239,  371,  200,  102,  170,  324,
 /*   320 */   102,   76,  357,   50,   50,   49,   47,   47,   42,  371,
 /*   330 */   371,  397,  280,  287,  136,  127,   48,  276,  275,  274,
 /*   340 */   240,  349,  230,  240,  349,   76,  333,  351,  353,   75,
 /*   350 */    43,   44,  199,   13,  234,  334,  352,   40,   40,   36,
 /*   360 */    41,   41,   41,   41,   37,   37,   37,   37,   37,   80,
 /*   370 */    45,   45,   64,  178,   50,   50,   49,   47,   47,   42,
 /*   380 */   242,  151,  239,  322,  198,  353,   39,   38,  102,  242,
 /*   390 */   357,  239,  209,  301,  336,    3,   76,   61,    2,  142,
 /*   400 */    73,  280,  169,  168,  167,  263,  262,  325,  228,   11,
 /*   410 */    74,  240,  349,   54,  149,  169,  168,  167,  261,  260,
 /*   420 */   240,  349,  351,  331,  131,  122,  352,  352,   27,   43,
 /*   430 */    44,  199,   13,  234,  334,   20,   40,   40,   36,   41,
 /*   440 */    41,   41,   41,   37,   37,   37,   37,   37,   55,   45,
 /*   450 */    45,   10,  146,   50,   50,   49,   47,   47,   42,   18,
 /*   460 */   353,  177,  360,  359,  176,   39,   38,   53,  242,   48,
 /*   470 */   239,  242,  197,  239,  319,   76,  102,  330,  357,   88,
 /*   480 */   242,  357,  201,  294,   80,  132,  130,  337,  148,  135,
 /*   490 */    82,  204,  351,  351,  144,  272,  312,  142,  152,  240,
 /*   500 */   349,  274,  240,  349,  332,  329,  311,   24,   43,   44,
 /*   510 */   199,   13,  234,  334,  142,   40,   40,   36,   41,   41,
 /*   520 */    41,   41,   37,   37,   37,   37,   37,  310,   45,   45,
 /*   530 */   353,  353,   50,   50,   49,   47,   47,   42,  181,  250,
 /*   540 */    39,   38,  242,  289,  239,  242,  187,  239,  308,  238,
 /*   550 */   102,  239,  306,   88,   76,  357,   48,   63,  321,  242,
 /*   560 */   357,  300,  118,   57,  304,  185,  169,  168,  167,   49,
 /*   570 */    47,   47,   42,  240,  349,  397,  240,  349,   60,  292,
 /*   580 */   240,  349,   55,   43,   44,  199,   13,  234,  334,   76,
 /*   590 */    40,   40,   36,   41,   41,   41,   41,   37,   37,   37,
 /*   600 */    37,   37,   16,   45,   45,  249,  288,   50,   50,   49,
 /*   610 */    47,   47,   42,   39,   38,  242,  293,  239,  242,  186,
 /*   620 */   239,  337,   48,  102,  154,   42,  106,  248,  242,   76,
 /*   630 */   137,  184,  169,  168,  167,  242,  182,  354,  285,  242,
 /*   640 */   277,  235,   76,  283,   74,  280,  240,  349,  284,  240,
 /*   650 */   349,  213,  156,  357,   56,  125,   43,   35,  199,   13,
 /*   660 */   234,  334,  316,   40,   40,   36,   41,   41,   41,   41,
 /*   670 */    37,   37,   37,   37,   37,  337,   45,   45,  212,  192,
 /*   680 */    50,   50,   49,   47,   47,   42,   39,   38,  242,  356,
 /*   690 */   239,  242,  217,  239,  182,  242,  120,  239,  355,  138,
 /*   700 */   175,  150,   76,  105,  183,   70,  357,  273,  242,  207,
 /*   710 */   302,  357,  269,  274,  242,  357,  147,  357,  274,  240,
 /*   720 */   349,  357,  240,  349,    9,  265,  240,  349,  247,   43,
 /*   730 */    33,  199,   13,  234,  334,  352,   40,   40,   36,   41,
 /*   740 */    41,   41,   41,   37,   37,   37,   37,   37,    8,   45,
 /*   750 */    45,    7,   68,   50,   50,   49,   47,   47,   42,   39,
 /*   760 */    38,  285,  242,  266,  239,  242,  283,  239,   58,  274,
 /*   770 */   139,  284,  242,   87,  145,   76,  242,  256,  203,  242,
 /*   780 */    15,  202,   14,  274,  173,  172,   81,  290,   79,   78,
 /*   790 */   242,  160,  297,  240,  349,   51,  240,  349,   76,  216,
 /*   800 */   337,  351,  192,   44,  199,   13,  234,  334,  352,   40,
 /*   810 */    40,   36,   41,   41,   41,   41,   37,   37,   37,   37,
 /*   820 */    37,  296,   45,   45,  140,   25,   50,   50,   49,   47,
 /*   830 */    47,   42,   39,   38,  242,  159,  239,  227,  242,  353,
 /*   840 */   239,  242,  119,  239,  158,   19,  110,  229,   76,  107,
 /*   850 */   352,  320,  157,   23,  155,   17,  219,  123,  303,  236,
 /*   860 */   279,   55,  216,  271,   72,  240,  349,  295,   52,  240,
 /*   870 */   349,  268,  240,  349,  351,  264,  174,  199,   13,  234,
 /*   880 */   334,   65,   40,   40,   36,   41,   41,   41,   41,   37,
 /*   890 */    37,   37,   37,   37,  210,   45,   45,  205,   69,   50,
 /*   900 */    50,   49,   47,   47,   42,  242,   59,  239,  206,  246,
 /*   910 */    77,  208,  353,  165,   67,  244,  351,  331,  352,   83,
 /*   920 */    30,   76,  166,  352,  242,  153,  239,  236,  233,  299,
 /*   930 */   241,  242,  116,  239,  245,  350,  240,  349,  242,  114,
 /*   940 */   239,  254,   31,   32,  341,  253,  113,  252,  237,  126,
 /*   950 */   286,   29,    4,  124,  353,  240,  349,  352,  270,  255,
 /*   960 */   251,  243,  240,  349,  315,  242,  559,  239,  559,  240,
 /*   970 */   349,  330,  559,  112,  559,  242,  559,  239,  559,  559,
 /*   980 */   559,  559,  142,  117,  351,  331,  352,  559,   30,  351,
 /*   990 */   559,  559,  326,  559,   12,  236,  240,  349,  332,  329,
 /*  1000 */   232,  559,  559,  327,  559,  559,  240,  349,  559,  559,
 /*  1010 */    31,   32,  559,  242,  559,  239,  559,  340,  559,   29,
 /*  1020 */     5,  104,  353,  351,  559,  559,  559,  353,  559,  559,
 /*  1030 */   559,  559,  559,  559,  559,  559,  559,  559,  559,  330,
 /*  1040 */   559,  242,  559,  239,  240,  349,  559,  559,  559,  115,
 /*  1050 */   559,  339,  351,  331,  352,  559,   30,  559,  559,  559,
 /*  1060 */   559,  353,   12,  236,  559,  559,  332,  329,  232,  559,
 /*  1070 */   559,  327,  240,  349,  242,  559,  239,  559,   31,   32,
 /*  1080 */   341,  559,  103,  559,  242,  559,  239,   29,    5,  559,
 /*  1090 */   353,  559,  109,  559,  559,  242,  559,  239,  559,  559,
 /*  1100 */   559,  559,  559,  164,  559,  240,  349,  330,  559,  242,
 /*  1110 */   559,  239,  559,  559,  559,  240,  349,  163,  559,  559,
 /*  1120 */   351,  331,  352,  559,   30,  559,  240,  349,  559,  559,
 /*  1130 */    12,  236,  559,  559,  332,  329,  232,  559,  559,  327,
 /*  1140 */   240,  349,  242,  559,  239,  559,   31,   32,  559,  559,
 /*  1150 */   108,  559,  559,  559,  559,   29,    4,  559,  353,  242,
 /*  1160 */   559,  239,  559,  242,  559,  239,  559,  162,  242,  559,
 /*  1170 */   239,   86,  559,  240,  349,  330,  100,  242,  559,  239,
 /*  1180 */   559,  559,  559,  559,  559,   99,  142,  559,  351,  331,
 /*  1190 */   240,  349,   30,  559,  240,  349,  559,  559,   12,  240,
 /*  1200 */   349,  559,  332,  329,  232,  559,  559,  327,  240,  349,
 /*  1210 */   242,  559,  239,  559,   31,   32,  559,  559,   85,  559,
 /*  1220 */   242,  559,  239,   29,    5,  242,  353,  239,   98,  559,
 /*  1230 */   559,  559,  559,   84,  559,  559,  559,  242,  559,  239,
 /*  1240 */   559,  240,  349,  330,  559,   97,  559,  242,  559,  239,
 /*  1250 */   559,  240,  349,  559,  559,   96,  240,  349,  559,  242,
 /*  1260 */   559,  239,  559,  559,  559,  559,   12,   62,  240,  349,
 /*  1270 */   332,  329,  232,  559,  242,  327,  239,  559,  240,  349,
 /*  1280 */   559,  559,   95,  559,  559,  559,  242,  559,  239,  559,
 /*  1290 */   240,  349,  559,  242,   94,  239,  559,  559,  559,  559,
 /*  1300 */   559,   92,  242,  559,  239,  240,  349,  242,  559,  239,
 /*  1310 */    91,  242,  559,  239,  559,   90,  559,  240,  349,   89,
 /*  1320 */   559,  242,  559,  239,  240,  349,  559,  559,  559,  111,
 /*  1330 */   559,  559,  559,  240,  349,  559,  559,  559,  240,  349,
 /*  1340 */   559,  559,  240,  349,  559,  559,  559,  559,  559,  559,
 /*  1350 */   559,  559,  240,  349,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    26,   27,  170,    0,  172,  160,  161,   33,  163,  104,
 /*    10 */   178,    0,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    20 */    86,   87,  142,   89,   90,  180,  121,   93,   94,   95,
 /*    30 */    96,   97,   98,  201,  202,  153,  204,  155,  156,  157,
 /*    40 */   158,   23,  142,   69,   70,   71,   72,   73,   74,  115,
 /*    50 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    60 */    86,   87,    1,   89,   90,    5,  152,   93,   94,   95,
 /*    70 */    96,   97,   98,  132,   14,  105,  106,  107,  108,  109,
 /*    80 */   110,  111,   64,   65,   66,  144,   26,   27,  121,  115,
 /*    90 */   170,  121,  172,   53,   54,  121,  129,   57,  178,   79,
 /*   100 */    80,   81,   82,   83,   84,   85,   86,   87,  103,   89,
 /*   110 */    90,  191,  105,   93,   94,   95,   96,   97,   98,   58,
 /*   120 */     1,  201,  202,   62,   63,  112,  113,  114,   67,   69,
 /*   130 */    70,   71,   72,   73,   74,  115,   76,   77,   78,   79,
 /*   140 */    80,   81,   82,   83,   84,   85,   86,   87,  141,   89,
 /*   150 */    90,  105,  142,   93,   94,   95,   96,   97,   98,   26,
 /*   160 */    27,  170,   87,  172,   89,   90,  105,  176,   93,   94,
 /*   170 */    95,   96,   97,   98,  153,  115,  155,  156,  157,  158,
 /*   180 */   183,  120,  112,  113,  114,  104,   67,  141,  118,  119,
 /*   190 */   115,  104,  164,  112,  113,  114,  199,  169,  170,  112,
 /*   200 */   113,  114,   69,   70,   71,   72,   73,   74,  104,   76,
 /*   210 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   220 */    87,  104,   89,   90,  105,  121,   93,   94,   95,   96,
 /*   230 */    97,   98,   26,   27,  105,  118,  119,  104,  121,   83,
 /*   240 */    84,   85,   86,   87,    1,   89,   90,  142,  115,   93,
 /*   250 */    94,   95,   96,   97,   98,  104,   13,   73,  146,  104,
 /*   260 */   148,   18,   78,  112,  113,  114,   23,  112,  113,  114,
 /*   270 */   141,  115,   58,   59,  103,   69,   70,   71,   72,   73,
 /*   280 */    74,    1,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   290 */    84,   85,   86,   87,   51,   89,   90,   54,  104,   93,
 /*   300 */    94,   95,   96,   97,   98,  163,    1,   26,   27,  170,
 /*   310 */    67,  172,  170,  174,  172,  104,  174,  178,  152,  104,
 /*   320 */   178,  115,  180,   93,   94,   95,   96,   97,   98,  118,
 /*   330 */   119,   51,  121,  164,  165,  166,  121,   55,   56,  170,
 /*   340 */   201,  202,  200,  201,  202,  115,   17,   67,  105,  143,
 /*   350 */    69,   70,   71,   72,   73,   74,    1,   76,   77,   78,
 /*   360 */    79,   80,   81,   82,   83,   84,   85,   86,   87,  103,
 /*   370 */    89,   90,    8,  163,   93,   94,   95,   96,   97,   98,
 /*   380 */   170,   17,  172,  104,  174,  105,   26,   27,  178,  170,
 /*   390 */   180,  172,  126,  104,  104,  103,  115,  178,  103,  133,
 /*   400 */   120,  121,  112,  113,  114,   64,   65,  104,  189,  136,
 /*   410 */   121,  201,  202,   49,   50,  112,  113,  114,   64,   65,
 /*   420 */   201,  202,   67,   68,   60,   61,    1,    1,  147,   69,
 /*   430 */    70,   71,   72,   73,   74,  121,   76,   77,   78,   79,
 /*   440 */    80,   81,   82,   83,   84,   85,   86,   87,  143,   89,
 /*   450 */    90,  136,  104,   93,   94,   95,   96,   97,   98,  121,
 /*   460 */   105,  163,  118,  119,  163,   26,   27,  103,  170,  121,
 /*   470 */   172,  170,  174,  172,  190,  115,  178,  122,  180,  178,
 /*   480 */   170,  180,  172,  121,  103,   60,   60,  203,  124,  179,
 /*   490 */   128,  127,   67,   67,  130,  164,  105,  133,  167,  201,
 /*   500 */   202,  170,  201,  202,  149,  150,  105,  147,   69,   70,
 /*   510 */    71,   72,   73,   74,  133,   76,   77,   78,   79,   80,
 /*   520 */    81,   82,   83,   84,   85,   86,   87,  105,   89,   90,
 /*   530 */   105,  105,   93,   94,   95,   96,   97,   98,  163,  104,
 /*   540 */    26,   27,  170,  163,  172,  170,  174,  172,  105,  170,
 /*   550 */   178,  172,  105,  178,  115,  180,  121,  178,  104,  170,
 /*   560 */   180,  172,  192,  193,  105,  176,  112,  113,  114,   95,
 /*   570 */    96,   97,   98,  201,  202,   51,  201,  202,  103,  200,
 /*   580 */   201,  202,  143,   69,   70,   71,   72,   73,   74,  115,
 /*   590 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   600 */    86,   87,  140,   89,   90,  104,  104,   93,   94,   95,
 /*   610 */    96,   97,   98,   26,   27,  170,  198,  172,  170,  174,
 /*   620 */   172,  203,  121,  178,  104,   98,  178,  104,  170,  115,
 /*   630 */   172,   52,  112,  113,  114,  170,  163,  172,   13,  170,
 /*   640 */    54,  172,  115,   18,  121,  121,  201,  202,   23,  201,
 /*   650 */   202,   68,  194,  180,  165,  166,   69,   70,   71,   72,
 /*   660 */    73,   74,  190,   76,   77,   78,   79,   80,   81,   82,
 /*   670 */    83,   84,   85,   86,   87,  203,   89,   90,  121,   54,
 /*   680 */    93,   94,   95,   96,   97,   98,   26,   27,  170,  163,
 /*   690 */   172,  170,  161,  172,  163,  170,  178,  172,  163,  178,
 /*   700 */   163,   68,  115,  178,  163,  125,  180,  164,  170,  121,
 /*   710 */   172,  180,  164,  170,  170,  180,  172,  180,  170,  201,
 /*   720 */   202,  180,  201,  202,  103,  122,  201,  202,    1,   69,
 /*   730 */    70,   71,   72,   73,   74,    1,   76,   77,   78,   79,
 /*   740 */    80,   81,   82,   83,   84,   85,   86,   87,  103,   89,
 /*   750 */    90,  103,  128,   93,   94,   95,   96,   97,   98,   26,
 /*   760 */    27,   13,  170,  164,  172,  170,   18,  172,  131,  170,
 /*   770 */   178,   23,  170,  178,  172,  115,  170,  164,  172,  170,
 /*   780 */    77,  172,   77,  170,  207,  207,  181,  132,  181,  181,
 /*   790 */   170,  177,  172,  201,  202,  129,  201,  202,  115,   51,
 /*   800 */   203,   67,   54,   70,   71,   72,   73,   74,    1,   76,
 /*   810 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   820 */    87,  201,   89,   90,  205,  146,   93,   94,   95,   96,
 /*   830 */    97,   98,   26,   27,  170,  185,  172,  138,  170,  105,
 /*   840 */   172,  170,  178,  172,  186,  137,  178,  135,  115,  178,
 /*   850 */     1,  188,  187,  134,  195,  140,  139,  123,  196,   10,
 /*   860 */   166,  143,   51,  166,  168,  201,  202,  198,  120,  201,
 /*   870 */   202,  120,  201,  202,   67,  169,   58,   71,   72,   73,
 /*   880 */    74,  168,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   890 */    84,   85,   86,   87,  171,   89,   90,   69,  173,   93,
 /*   900 */    94,   95,   96,   97,   98,  170,  103,  172,  121,  177,
 /*   910 */   103,  175,  105,  178,  171,  162,   67,   68,    1,  182,
 /*   920 */    71,  115,  184,    1,  170,  167,  172,   10,  206,  198,
 /*   930 */   170,  170,  178,  172,  177,  170,  201,  202,  170,  178,
 /*   940 */   172,  170,   93,   94,   95,  170,  178,  170,  170,  167,
 /*   950 */   165,  102,  103,  167,  105,  201,  202,    1,  165,  170,
 /*   960 */   170,  162,  201,  202,  197,  170,  208,  172,  208,  201,
 /*   970 */   202,  122,  208,  178,  208,  170,  208,  172,  208,  208,
 /*   980 */   208,  208,  133,  178,   67,   68,    1,  208,   71,   67,
 /*   990 */   208,  208,   75,  208,  145,   10,  201,  202,  149,  150,
 /*  1000 */   151,  208,  208,  154,  208,  208,  201,  202,  208,  208,
 /*  1010 */    93,   94,  208,  170,  208,  172,  208,   95,  208,  102,
 /*  1020 */   103,  178,  105,   67,  208,  208,  208,  105,  208,  208,
 /*  1030 */   208,  208,  208,  208,  208,  208,  208,  208,  208,  122,
 /*  1040 */   208,  170,  208,  172,  201,  202,  208,  208,  208,  178,
 /*  1050 */   208,   95,   67,   68,    1,  208,   71,  208,  208,  208,
 /*  1060 */   208,  105,  145,   10,  208,  208,  149,  150,  151,  208,
 /*  1070 */   208,  154,  201,  202,  170,  208,  172,  208,   93,   94,
 /*  1080 */    95,  208,  178,  208,  170,  208,  172,  102,  103,  208,
 /*  1090 */   105,  208,  178,  208,  208,  170,  208,  172,  208,  208,
 /*  1100 */   208,  208,  208,  178,  208,  201,  202,  122,  208,  170,
 /*  1110 */   208,  172,  208,  208,  208,  201,  202,  178,  208,  208,
 /*  1120 */    67,   68,    1,  208,   71,  208,  201,  202,  208,  208,
 /*  1130 */   145,   10,  208,  208,  149,  150,  151,  208,  208,  154,
 /*  1140 */   201,  202,  170,  208,  172,  208,   93,   94,  208,  208,
 /*  1150 */   178,  208,  208,  208,  208,  102,  103,  208,  105,  170,
 /*  1160 */   208,  172,  208,  170,  208,  172,  208,  178,  170,  208,
 /*  1170 */   172,  178,  208,  201,  202,  122,  178,  170,  208,  172,
 /*  1180 */   208,  208,  208,  208,  208,  178,  133,  208,   67,   68,
 /*  1190 */   201,  202,   71,  208,  201,  202,  208,  208,  145,  201,
 /*  1200 */   202,  208,  149,  150,  151,  208,  208,  154,  201,  202,
 /*  1210 */   170,  208,  172,  208,   93,   94,  208,  208,  178,  208,
 /*  1220 */   170,  208,  172,  102,  103,  170,  105,  172,  178,  208,
 /*  1230 */   208,  208,  208,  178,  208,  208,  208,  170,  208,  172,
 /*  1240 */   208,  201,  202,  122,  208,  178,  208,  170,  208,  172,
 /*  1250 */   208,  201,  202,  208,  208,  178,  201,  202,  208,  170,
 /*  1260 */   208,  172,  208,  208,  208,  208,  145,  178,  201,  202,
 /*  1270 */   149,  150,  151,  208,  170,  154,  172,  208,  201,  202,
 /*  1280 */   208,  208,  178,  208,  208,  208,  170,  208,  172,  208,
 /*  1290 */   201,  202,  208,  170,  178,  172,  208,  208,  208,  208,
 /*  1300 */   208,  178,  170,  208,  172,  201,  202,  170,  208,  172,
 /*  1310 */   178,  170,  208,  172,  208,  178,  208,  201,  202,  178,
 /*  1320 */   208,  170,  208,  172,  201,  202,  208,  208,  208,  178,
 /*  1330 */   208,  208,  208,  201,  202,  208,  208,  208,  201,  202,
 /*  1340 */   208,  208,  201,  202,  208,  208,  208,  208,  208,  208,
 /*  1350 */   208,  208,  201,  202,
};
#define YY_SHIFT_USE_DFLT (-121)
#define YY_SHIFT_COUNT (244)
#define YY_SHIFT_MIN   (-120)
#define YY_SHIFT_MAX   (1121)
static const short yy_shift_ofst[] = {
 /*     0 */   364,  849, 1053, 1053, 1053, 1053,  985, 1121, 1121, 1121,
 /*    10 */  1121, 1121, 1121,  917, 1121, 1121, 1121, 1121, 1121, 1121,
 /*    20 */  1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121,
 /*    30 */  1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121,
 /*    40 */  1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1121,
 /*    50 */  1121, 1121,  243,  364,   61,  355,  280,  807,  119,  119,
 /*    60 */   119,   60,   60,  439,  748,  734,  119,  119,  119,  266,
 /*    70 */   119,  119,  119,  119,  119,  119,  119,  381,  381,  381,
 /*    80 */   381,  381, -121, -121,  -26,  360,  281,  206,  133,  514,
 /*    90 */   514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
 /*   100 */   514,  514,  514,  660,  587,  514,  514,  733,  806,  806,
 /*   110 */   806,  -66,  -66,  -66,  -66,   20,  156,   75,  -30,  230,
 /*   120 */   474,   70,  426,  425,  625,  211,  625,  117,  956,  922,
 /*   130 */   119,  119,  119,  119,  119,  -33,  524,  305,  527,  527,
 /*   140 */   112,  362,  -59,  344,  828,  666,  787,  803,  828,  751,
 /*   150 */   818,  751,  811,  811,  718,  717,  715,  719,  712,  708,
 /*   160 */   699,  679,  683,  683,  683,  683,  666,  655,  655,  655,
 /*   170 */  -121, -121,   21, -118,   18,  520,  454,  303,  290,  155,
 /*   180 */   151,   87,   81,   13,   40,  523,  501,  435,  348,  354,
 /*   190 */   341,  282,  214,  289,  129,   46,    7,  215,  104,  184,
 /*   200 */   -95,  705,  703,  637,  624,  727,  648,  645,  588,  621,
 /*   210 */   580,  633,  603,  557,  583,  586,  579,  502,  462,  475,
 /*   220 */   459,  447,  443,  422,  401,  391,  338,  315,  314,  273,
 /*   230 */   279,  295,  166,  329,  292,  194,  171,  105,   10,    5,
 /*   240 */   -86, -100, -120,   11,    3,
};
#define YY_REDUCE_USE_DFLT (-169)
#define YY_REDUCE_COUNT (171)
#define YY_REDUCE_MIN   (-168)
#define YY_REDUCE_MAX   (1151)
static const short yy_reduce_ofst[] = {
 /*     0 */  -155,  142,  298,  210,  375,  301,  379,  445,  372,  139,
 /*    10 */   -80,  219, -168, 1151, 1141, 1137, 1132, 1123, 1116, 1104,
 /*    20 */  1089, 1077, 1067, 1055, 1050, 1040, 1007,  998,  993,  989,
 /*    30 */   972,  939,  925,  914,  904,  871,  843,  805,  795,  768,
 /*    40 */   761,  754,  735,  671,  668,  664,  595,  592,  525,  521,
 /*    50 */   518,  448,  169,  531,   28,  620,  331,  458,  310,  389,
 /*    60 */    -9,  472,  284,  418,  489,  613,  609,  606,  602,  541,
 /*    70 */   544,  599,  548,  543,  538,  469,  465,  537,  535,  526,
 /*    80 */   473,  380,  370,   -3,  597,  597,  597,  597,  597,  597,
 /*    90 */   597,  597,  597,  597,  597,  597,  597,  597,  597,  597,
 /*   100 */   597,  597,  597,  597,  597,  597,  597,  597,  597,  597,
 /*   110 */   597,  597,  597,  597,  597,  597,  597,  597,  767,  597,
 /*   120 */   597,  799,  790,  789,  793,  786,  785,  782,  765,  778,
 /*   130 */   777,  775,  771,  765,  760,  757,  758,  731,  597,  597,
 /*   140 */   722,  738,  737,  753,  743,  732,  736,  725,  723,  713,
 /*   150 */   706,  696,  697,  694,  669,  662,  659,  663,  665,  658,
 /*   160 */   650,  619,  597,  597,  597,  597,  614,  608,  607,  605,
 /*   170 */   578,  577,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   557,  493,  493,  493,  557,  557,  557,  493,  493,  493,
 /*    10 */   557,  557,  532,  557,  557,  557,  557,  557,  557,  557,
 /*    20 */   557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*    30 */   557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*    40 */   557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*    50 */   557,  557,  403,  557,  403,  557,  403,  557,  557,  557,
 /*    60 */   557,  449,  449,  486,  367,  403,  557,  557,  557,  557,
 /*    70 */   557,  403,  403,  403,  557,  557,  557,  557,  557,  557,
 /*    80 */   557,  557,  459,  478,  440,  557,  557,  557,  557,  431,
 /*    90 */   430,  490,  461,  492,  491,  451,  442,  441,  534,  535,
 /*   100 */   533,  531,  495,  557,  557,  494,  428,  512,  521,  520,
 /*   110 */   511,  524,  517,  516,  515,  519,  514,  518,  455,  508,
 /*   120 */   505,  557,  557,  557,  557,  397,  557,  397,  557,  557,
 /*   130 */   557,  557,  557,  557,  557,  427,  373,  486,  506,  507,
 /*   140 */   536,  454,  487,  557,  418,  427,  415,  422,  418,  395,
 /*   150 */   383,  395,  557,  557,  486,  458,  462,  439,  443,  450,
 /*   160 */   452,  557,  522,  510,  509,  513,  427,  436,  436,  436,
 /*   170 */   546,  546,  557,  557,  557,  557,  557,  557,  557,  557,
 /*   180 */   525,  557,  557,  417,  557,  557,  557,  557,  557,  388,
 /*   190 */   387,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*   200 */   557,  557,  557,  557,  557,  557,  557,  557,  416,  557,
 /*   210 */   557,  557,  557,  381,  557,  557,  557,  557,  489,  557,
 /*   220 */   557,  557,  557,  557,  557,  557,  453,  557,  444,  557,
 /*   230 */   557,  557,  557,  557,  557,  557,  557,  555,  554,  499,
 /*   240 */   497,  555,  554,  557,  557,  429,  426,  419,  423,  421,
 /*   250 */   420,  412,  411,  410,  414,  413,  386,  385,  390,  389,
 /*   260 */   394,  393,  392,  391,  384,  382,  380,  379,  396,  378,
 /*   270 */   377,  376,  370,  369,  404,  402,  401,  400,  399,  374,
 /*   280 */   398,  409,  408,  407,  406,  405,  375,  368,  363,  433,
 /*   290 */   437,  488,  480,  479,  477,  476,  485,  484,  475,  474,
 /*   300 */   425,  457,  424,  456,  473,  472,  471,  470,  469,  468,
 /*   310 */   467,  466,  465,  464,  463,  460,  446,  448,  447,  445,
 /*   320 */   438,  525,  502,  500,  528,  529,  538,  545,  543,  542,
 /*   330 */   541,  540,  539,  530,  537,  526,  527,  523,  503,  483,
 /*   340 */   482,  481,  501,  498,  550,  549,  548,  547,  544,  496,
 /*   350 */   556,  553,  552,  551,  504,  435,  434,  432,  364,  366,
 /*   360 */   365,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      ILIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
    0,  /*    TEXTUAL => nothing */
   67,  /*     STRING => TEXTUAL */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  gda_sql_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "ILIKE",       
  "MATCH",         "PLAN",          "QUERY",         "KEY",         
  "OF",            "OFFSET",        "PRAGMA",        "RAISE",       
  "REPLACE",       "RESTRICT",      "ROW",           "TEMP",        
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "IF",          
  "DELIMITER",     "COMMIT",        "ROLLBACK",      "ISOLATION",   
  "LEVEL",         "SERIALIZABLE",  "READ",          "COMMITTED",   
  "UNCOMMITTED",   "REPEATABLE",    "WRITE",         "ONLY",        
  "SAVEPOINT",     "RELEASE",       "COMMENT",       "FORCE",       
  "WAIT",          "NOWAIT",        "BATCH",         "TEXTUAL",     
  "STRING",        "OR",            "AND",           "NOT",         
  "IS",            "IN",            "ISNULL",        "NOTNULL",     
  "DIFF",          "EQ",            "BETWEEN",       "GT",          
  "LEQ",           "LT",            "GEQ",           "REGEXP",      
  "REGEXP_CI",     "NOT_REGEXP",    "NOT_REGEXP_CI",  "SIMILAR",     
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "COLLATE",     
  "UMINUS",        "UPLUS",         "BITNOT",        "LP",          
  "RP",            "JOIN",          "INNER",         "NATURAL",     
  "LEFT",          "RIGHT",         "FULL",          "CROSS",       
  "UNION",         "EXCEPT",        "INTERSECT",     "PGCAST",      
  "ILLEGAL",       "SQLCOMMENT",    "SEMI",          "END_OF_FILE", 
  "TRANSACTION",   "COMMA",         "INTEGER",       "TO",          
  "INSERT",        "INTO",          "VALUES",        "DELETE",      
  "FROM",          "WHERE",         "UPDATE",        "SET",         
  "ALL",           "SELECT",        "LIMIT",         "ORDER",       
  "BY",            "HAVING",        "GROUP",         "USING",       
  "ON",            "OUTER",         "DOT",           "AS",          
  "DISTINCT",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "NULL",          "FLOAT",         "UNSPECVAL",   
  "LSBRACKET",     "RSBRACKET",     "SIMPLEPARAM",   "PNAME",       
  "PDESCR",        "PTYPE",         "PNULLOK",       "error",       
  "stmt",          "cmd",           "eos",           "compound",    
  "nm_opt",        "transtype",     "transilev",     "opt_comma",   
  "trans_opt_kw",  "ora_commit_write",  "nm",            "opt_on_conflict",
  "fullname",      "inscollist_opt",  "exprlist",      "ins_extra_values",
  "inscollist",    "where_opt",     "expr",          "setlist",     
  "selectcmd",     "opt_compound_all",  "distinct",      "selcollist",  
  "from",          "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sortlist",      "sortorder",     "nexprlist",   
  "seltablist",    "stl_prefix",    "seltarget",     "on_cond",     
  "using_opt",     "jointype",      "as",            "sclp",        
  "starname",      "value",         "pvalue",        "uni_op",      
  "case_operand",  "case_exprlist",  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP exprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP exprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY nexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "nexprlist ::= nexprlist COMMA expr",
 /* 131 */ "nexprlist ::= expr",
 /* 132 */ "exprlist ::=",
 /* 133 */ "exprlist ::= exprlist COMMA expr",
 /* 134 */ "exprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP exprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr ILIKE expr",
 /* 157 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 158 */ "expr ::= expr BETWEEN expr AND expr",
 /* 159 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 160 */ "expr ::= NOT expr",
 /* 161 */ "expr ::= BITNOT expr",
 /* 162 */ "expr ::= expr uni_op",
 /* 163 */ "expr ::= expr IS expr",
 /* 164 */ "expr ::= LP compound RP",
 /* 165 */ "expr ::= expr IN LP exprlist RP",
 /* 166 */ "expr ::= expr IN LP compound RP",
 /* 167 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 168 */ "expr ::= expr NOT IN LP compound RP",
 /* 169 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 170 */ "case_operand ::= expr",
 /* 171 */ "case_operand ::=",
 /* 172 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 173 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 174 */ "case_else ::= ELSE expr",
 /* 175 */ "case_else ::=",
 /* 176 */ "uni_op ::= ISNULL",
 /* 177 */ "uni_op ::= IS NOTNULL",
 /* 178 */ "value ::= NULL",
 /* 179 */ "value ::= STRING",
 /* 180 */ "value ::= INTEGER",
 /* 181 */ "value ::= FLOAT",
 /* 182 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 183 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 184 */ "pvalue ::= SIMPLEPARAM",
 /* 185 */ "paramspec ::=",
 /* 186 */ "paramspec ::= paramspec PNAME",
 /* 187 */ "paramspec ::= paramspec PDESCR",
 /* 188 */ "paramspec ::= paramspec PTYPE",
 /* 189 */ "paramspec ::= paramspec PNULLOK",
 /* 190 */ "nm ::= JOIN",
 /* 191 */ "nm ::= ID",
 /* 192 */ "nm ::= TEXTUAL",
 /* 193 */ "fullname ::= nm",
 /* 194 */ "fullname ::= nm DOT nm",
 /* 195 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to gda_sql_parser and gda_sql_parserFree.
*/
void *gda_sql_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  gda_sql_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
      /* TERMINAL Destructor */
    case 1: /* ID */
    case 2: /* ABORT */
    case 3: /* AFTER */
    case 4: /* ANALYZE */
    case 5: /* ASC */
    case 6: /* ATTACH */
    case 7: /* BEFORE */
    case 8: /* BEGIN */
    case 9: /* CASCADE */
    case 10: /* CAST */
    case 11: /* CONFLICT */
    case 12: /* DATABASE */
    case 13: /* DEFERRED */
    case 14: /* DESC */
    case 15: /* DETACH */
    case 16: /* EACH */
    case 17: /* END */
    case 18: /* EXCLUSIVE */
    case 19: /* EXPLAIN */
    case 20: /* FAIL */
    case 21: /* FOR */
    case 22: /* IGNORE */
    case 23: /* IMMEDIATE */
    case 24: /* INITIALLY */
    case 25: /* INSTEAD */
    case 26: /* LIKE */
    case 27: /* ILIKE */
    case 28: /* MATCH */
    case 29: /* PLAN */
    case 30: /* QUERY */
    case 31: /* KEY */
    case 32: /* OF */
    case 33: /* OFFSET */
    case 34: /* PRAGMA */
    case 35: /* RAISE */
    case 36: /* REPLACE */
    case 37: /* RESTRICT */
    case 38: /* ROW */
    case 39: /* TEMP */
    case 40: /* TRIGGER */
    case 41: /* VACUUM */
    case 42: /* VIEW */
    case 43: /* VIRTUAL */
    case 44: /* REINDEX */
    case 45: /* RENAME */
    case 46: /* CTIME_KW */
    case 47: /* IF */
    case 48: /* DELIMITER */
    case 49: /* COMMIT */
    case 50: /* ROLLBACK */
    case 51: /* ISOLATION */
    case 52: /* LEVEL */
    case 53: /* SERIALIZABLE */
    case 54: /* READ */
    case 55: /* COMMITTED */
    case 56: /* UNCOMMITTED */
    case 57: /* REPEATABLE */
    case 58: /* WRITE */
    case 59: /* ONLY */
    case 60: /* SAVEPOINT */
    case 61: /* RELEASE */
    case 62: /* COMMENT */
    case 63: /* FORCE */
    case 64: /* WAIT */
    case 65: /* NOWAIT */
    case 66: /* BATCH */
    case 67: /* TEXTUAL */
    case 68: /* STRING */
    case 69: /* OR */
    case 70: /* AND */
    case 71: /* NOT */
    case 72: /* IS */
    case 73: /* IN */
    case 74: /* ISNULL */
    case 75: /* NOTNULL */
    case 76: /* DIFF */
    case 77: /* EQ */
    case 78: /* BETWEEN */
    case 79: /* GT */
    case 80: /* LEQ */
    case 81: /* LT */
    case 82: /* GEQ */
    case 83: /* REGEXP */
    case 84: /* REGEXP_CI */
    case 85: /* NOT_REGEXP */
    case 86: /* NOT_REGEXP_CI */
    case 87: /* SIMILAR */
    case 88: /* ESCAPE */
    case 89: /* BITAND */
    case 90: /* BITOR */
    case 91: /* LSHIFT */
    case 92: /* RSHIFT */
    case 93: /* PLUS */
    case 94: /* MINUS */
    case 95: /* STAR */
    case 96: /* SLASH */
    case 97: /* REM */
    case 98: /* CONCAT */
    case 99: /* COLLATE */
    case 100: /* UMINUS */
    case 101: /* UPLUS */
    case 102: /* BITNOT */
    case 103: /* LP */
    case 104: /* RP */
    case 105: /* JOIN */
    case 106: /* INNER */
    case 107: /* NATURAL */
    case 108: /* LEFT */
    case 109: /* RIGHT */
    case 110: /* FULL */
    case 111: /* CROSS */
    case 112: /* UNION */
    case 113: /* EXCEPT */
    case 114: /* INTERSECT */
    case 115: /* PGCAST */
    case 116: /* ILLEGAL */
    case 117: /* SQLCOMMENT */
    case 118: /* SEMI */
    case 119: /* END_OF_FILE */
    case 120: /* TRANSACTION */
    case 121: /* COMMA */
    case 122: /* INTEGER */
    case 123: /* TO */
    case 124: /* INSERT */
    case 125: /* INTO */
    case 126: /* VALUES */
    case 127: /* DELETE */
    case 128: /* FROM */
    case 129: /* WHERE */
    case 130: /* UPDATE */
    case 131: /* SET */
    case 132: /* ALL */
    case 133: /* SELECT */
    case 134: /* LIMIT */
    case 135: /* ORDER */
    case 136: /* BY */
    case 137: /* HAVING */
    case 138: /* GROUP */
    case 139: /* USING */
    case 140: /* ON */
    case 141: /* OUTER */
    case 142: /* DOT */
    case 143: /* AS */
    case 144: /* DISTINCT */
    case 145: /* CASE */
    case 146: /* WHEN */
    case 147: /* THEN */
    case 148: /* ELSE */
    case 149: /* NULL */
    case 150: /* FLOAT */
    case 151: /* UNSPECVAL */
    case 152: /* LSBRACKET */
    case 153: /* RSBRACKET */
    case 154: /* SIMPLEPARAM */
    case 155: /* PNAME */
    case 156: /* PDESCR */
    case 157: /* PTYPE */
    case 158: /* PNULLOK */
{
#line 9 "./parser.y"
if ((yypminor->yy0)) {
#ifdef GDA_DEBUG_NO
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 g_print ("___ token destructor /%s/\n", str)
		 g_free (str);
#endif
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}
#line 1391 "parser.c"
}
      break;
    case 160: /* stmt */
{
#line 280 "./parser.y"
g_print ("Statement destroyed by parser: %p\n", (yypminor->yy252)); gda_sql_statement_free ((yypminor->yy252));
#line 1398 "parser.c"
}
      break;
    case 161: /* cmd */
    case 163: /* compound */
    case 180: /* selectcmd */
{
#line 303 "./parser.y"
gda_sql_statement_free ((yypminor->yy252));
#line 1407 "parser.c"
}
      break;
    case 173: /* inscollist_opt */
    case 176: /* inscollist */
    case 196: /* using_opt */
{
#line 480 "./parser.y"
if ((yypminor->yy105)) {g_slist_foreach ((yypminor->yy105), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy105));}
#line 1416 "parser.c"
}
      break;
    case 174: /* exprlist */
    case 191: /* nexprlist */
{
#line 766 "./parser.y"
if ((yypminor->yy33)) {g_slist_foreach ((yypminor->yy33), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy33));}
#line 1424 "parser.c"
}
      break;
    case 175: /* ins_extra_values */
{
#line 469 "./parser.y"
GSList *list;
		for (list = (yypminor->yy105); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy105));

#line 1437 "parser.c"
}
      break;
    case 177: /* where_opt */
    case 178: /* expr */
    case 186: /* having_opt */
    case 195: /* on_cond */
    case 202: /* pvalue */
{
#line 502 "./parser.y"
gda_sql_expr_free ((yypminor->yy302));
#line 1448 "parser.c"
}
      break;
    case 179: /* setlist */
{
#line 522 "./parser.y"
GSList *list;
	for (list = (yypminor->yy105); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy105));

#line 1463 "parser.c"
}
      break;
    case 182: /* distinct */
{
#line 752 "./parser.y"
if ((yypminor->yy249)) {if ((yypminor->yy249)->expr) gda_sql_expr_free ((yypminor->yy249)->expr); g_free ((yypminor->yy249));}
#line 1470 "parser.c"
}
      break;
    case 183: /* selcollist */
    case 199: /* sclp */
{
#line 709 "./parser.y"
g_slist_foreach ((yypminor->yy33), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy33));
#line 1478 "parser.c"
}
      break;
    case 184: /* from */
    case 192: /* seltablist */
    case 193: /* stl_prefix */
{
#line 635 "./parser.y"
gda_sql_select_from_free ((yypminor->yy259));
#line 1487 "parser.c"
}
      break;
    case 185: /* groupby_opt */
{
#line 630 "./parser.y"
if ((yypminor->yy105)) {g_slist_foreach ((yypminor->yy105), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy105));}
#line 1494 "parser.c"
}
      break;
    case 187: /* orderby_opt */
    case 189: /* sortlist */
{
#line 599 "./parser.y"
if ((yypminor->yy33)) {g_slist_foreach ((yypminor->yy33), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy33));}
#line 1502 "parser.c"
}
      break;
    case 188: /* limit_opt */
{
#line 592 "./parser.y"
gda_sql_expr_free ((yypminor->yy408).count); gda_sql_expr_free ((yypminor->yy408).offset);
#line 1509 "parser.c"
}
      break;
    case 194: /* seltarget */
{
#line 694 "./parser.y"
gda_sql_select_target_free ((yypminor->yy414));
#line 1516 "parser.c"
}
      break;
    case 204: /* case_operand */
    case 206: /* case_else */
{
#line 931 "./parser.y"
gda_sql_expr_free ((yypminor->yy354));
#line 1524 "parser.c"
}
      break;
    case 205: /* case_exprlist */
{
#line 936 "./parser.y"
g_slist_foreach ((yypminor->yy51).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy51).when_list);
	g_slist_foreach ((yypminor->yy51).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy51).then_list);
#line 1532 "parser.c"
}
      break;
    case 207: /* paramspec */
{
#line 974 "./parser.y"
gda_sql_param_spec_free ((yypminor->yy303));
#line 1539 "parser.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from gda_sql_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void gda_sql_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int gda_sql_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   gda_sql_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 25 "./parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1724 "parser.c"
   gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 160, 2 },
  { 160, 2 },
  { 161, 3 },
  { 163, 3 },
  { 162, 1 },
  { 162, 1 },
  { 161, 1 },
  { 161, 3 },
  { 161, 4 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 3 },
  { 161, 5 },
  { 161, 5 },
  { 161, 4 },
  { 161, 4 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 3 },
  { 161, 5 },
  { 161, 3 },
  { 161, 4 },
  { 161, 2 },
  { 161, 3 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 168, 0 },
  { 168, 1 },
  { 167, 0 },
  { 167, 1 },
  { 166, 3 },
  { 166, 4 },
  { 166, 4 },
  { 166, 4 },
  { 164, 0 },
  { 164, 1 },
  { 165, 1 },
  { 165, 1 },
  { 165, 1 },
  { 165, 2 },
  { 165, 2 },
  { 161, 2 },
  { 161, 3 },
  { 161, 2 },
  { 161, 4 },
  { 161, 5 },
  { 161, 9 },
  { 161, 10 },
  { 161, 6 },
  { 171, 0 },
  { 171, 2 },
  { 175, 5 },
  { 175, 4 },
  { 173, 0 },
  { 173, 3 },
  { 176, 3 },
  { 176, 1 },
  { 161, 4 },
  { 177, 0 },
  { 177, 2 },
  { 161, 6 },
  { 179, 5 },
  { 179, 3 },
  { 163, 1 },
  { 163, 4 },
  { 163, 4 },
  { 163, 4 },
  { 181, 0 },
  { 181, 1 },
  { 180, 9 },
  { 188, 0 },
  { 188, 2 },
  { 188, 4 },
  { 188, 4 },
  { 187, 0 },
  { 187, 3 },
  { 189, 4 },
  { 189, 2 },
  { 190, 1 },
  { 190, 1 },
  { 190, 0 },
  { 186, 0 },
  { 186, 2 },
  { 185, 0 },
  { 185, 3 },
  { 184, 0 },
  { 184, 2 },
  { 192, 4 },
  { 196, 4 },
  { 196, 0 },
  { 193, 0 },
  { 193, 2 },
  { 195, 2 },
  { 195, 0 },
  { 197, 1 },
  { 197, 1 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 3 },
  { 197, 2 },
  { 197, 3 },
  { 197, 2 },
  { 197, 3 },
  { 194, 2 },
  { 194, 2 },
  { 194, 4 },
  { 199, 2 },
  { 199, 0 },
  { 183, 3 },
  { 183, 2 },
  { 200, 1 },
  { 200, 3 },
  { 200, 5 },
  { 198, 2 },
  { 198, 2 },
  { 198, 0 },
  { 182, 0 },
  { 182, 1 },
  { 182, 1 },
  { 182, 3 },
  { 191, 3 },
  { 191, 1 },
  { 174, 0 },
  { 174, 3 },
  { 174, 1 },
  { 178, 1 },
  { 178, 1 },
  { 178, 3 },
  { 178, 1 },
  { 178, 4 },
  { 178, 4 },
  { 178, 4 },
  { 178, 6 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 5 },
  { 178, 6 },
  { 178, 2 },
  { 178, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 5 },
  { 178, 5 },
  { 178, 6 },
  { 178, 6 },
  { 178, 5 },
  { 204, 1 },
  { 204, 0 },
  { 205, 5 },
  { 205, 4 },
  { 206, 2 },
  { 206, 0 },
  { 203, 1 },
  { 203, 2 },
  { 201, 1 },
  { 201, 1 },
  { 201, 1 },
  { 201, 1 },
  { 202, 4 },
  { 202, 4 },
  { 202, 1 },
  { 207, 0 },
  { 207, 2 },
  { 207, 2 },
  { 207, 2 },
  { 207, 2 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 172, 1 },
  { 172, 3 },
  { 172, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  gda_sql_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* stmt ::= cmd eos */
#line 281 "./parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy252;}
#line 2034 "parser.c"
        break;
      case 1: /* stmt ::= compound eos */
#line 282 "./parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy252->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy252;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy252);
	}
}
#line 2052 "parser.c"
        break;
      case 2: /* cmd ::= LP cmd RP */
      case 3: /* compound ::= LP compound RP */ yytestcase(yyruleno==3);
#line 296 "./parser.y"
{yygotominor.yy252 = yymsp[-1].minor.yy252;  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2060 "parser.c"
        break;
      case 4: /* eos ::= SEMI */
#line 299 "./parser.y"
{
  yy_destructor(yypParser,118,&yymsp[0].minor);
}
#line 2067 "parser.c"
        break;
      case 5: /* eos ::= END_OF_FILE */
#line 300 "./parser.y"
{
  yy_destructor(yypParser,119,&yymsp[0].minor);
}
#line 2074 "parser.c"
        break;
      case 6: /* cmd ::= BEGIN */
#line 308 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(yypParser,8,&yymsp[0].minor);
}
#line 2080 "parser.c"
        break;
      case 7: /* cmd ::= BEGIN TRANSACTION nm_opt */
#line 309 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2089 "parser.c"
        break;
      case 8: /* cmd ::= BEGIN transtype TRANSACTION nm_opt */
#line 313 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-2].minor.yy0);
						      gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2099 "parser.c"
        break;
      case 9: /* cmd ::= BEGIN transtype nm_opt */
#line 318 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-1].minor.yy0);
					  gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
}
#line 2108 "parser.c"
        break;
      case 10: /* cmd ::= BEGIN transilev */
#line 323 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-1].minor);
}
#line 2116 "parser.c"
        break;
      case 11: /* cmd ::= BEGIN TRANSACTION transilev */
#line 327 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2125 "parser.c"
        break;
      case 12: /* cmd ::= BEGIN TRANSACTION transtype */
#line 331 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2134 "parser.c"
        break;
      case 13: /* cmd ::= BEGIN TRANSACTION transtype opt_comma transilev */
#line 335 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-2].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,120,&yymsp[-3].minor);
}
#line 2144 "parser.c"
        break;
      case 14: /* cmd ::= BEGIN TRANSACTION transilev opt_comma transtype */
#line 340 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[0].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[-2].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,120,&yymsp[-3].minor);
}
#line 2154 "parser.c"
        break;
      case 15: /* cmd ::= BEGIN transtype opt_comma transilev */
#line 345 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-2].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2163 "parser.c"
        break;
      case 16: /* cmd ::= BEGIN transilev opt_comma transtype */
#line 350 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[0].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[-2].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2172 "parser.c"
        break;
      case 17: /* cmd ::= END trans_opt_kw nm_opt */
#line 355 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,17,&yymsp[-2].minor);
}
#line 2180 "parser.c"
        break;
      case 18: /* cmd ::= COMMIT nm_opt */
#line 359 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-1].minor);
}
#line 2188 "parser.c"
        break;
      case 19: /* cmd ::= COMMIT TRANSACTION nm_opt */
#line 363 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2197 "parser.c"
        break;
      case 20: /* cmd ::= COMMIT FORCE STRING */
#line 367 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,63,&yymsp[-1].minor);
  yy_destructor(yypParser,68,&yymsp[0].minor);
}
#line 2205 "parser.c"
        break;
      case 21: /* cmd ::= COMMIT FORCE STRING COMMA INTEGER */
#line 368 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-4].minor);
  yy_destructor(yypParser,63,&yymsp[-3].minor);
  yy_destructor(yypParser,68,&yymsp[-2].minor);
  yy_destructor(yypParser,121,&yymsp[-1].minor);
  yy_destructor(yypParser,122,&yymsp[0].minor);
}
#line 2215 "parser.c"
        break;
      case 22: /* cmd ::= COMMIT COMMENT STRING */
#line 369 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,62,&yymsp[-1].minor);
  yy_destructor(yypParser,68,&yymsp[0].minor);
}
#line 2223 "parser.c"
        break;
      case 23: /* cmd ::= COMMIT COMMENT STRING ora_commit_write */
#line 370 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-3].minor);
  yy_destructor(yypParser,62,&yymsp[-2].minor);
  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 2231 "parser.c"
        break;
      case 24: /* cmd ::= COMMIT ora_commit_write */
#line 371 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-1].minor);
}
#line 2237 "parser.c"
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt_kw nm_opt */
#line 373 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-2].minor);
}
#line 2245 "parser.c"
        break;
      case 26: /* ora_commit_write ::= WRITE IMMEDIATE */
#line 377 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,23,&yymsp[0].minor);
}
#line 2253 "parser.c"
        break;
      case 27: /* ora_commit_write ::= WRITE BATCH */
#line 378 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,66,&yymsp[0].minor);
}
#line 2261 "parser.c"
        break;
      case 28: /* ora_commit_write ::= WRITE WAIT */
#line 379 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2269 "parser.c"
        break;
      case 29: /* ora_commit_write ::= WRITE NOWAIT */
#line 380 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2277 "parser.c"
        break;
      case 30: /* ora_commit_write ::= WRITE IMMEDIATE WAIT */
#line 381 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2286 "parser.c"
        break;
      case 31: /* ora_commit_write ::= WRITE IMMEDIATE NOWAIT */
#line 382 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2295 "parser.c"
        break;
      case 32: /* ora_commit_write ::= WRITE BATCH WAIT */
#line 383 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2304 "parser.c"
        break;
      case 33: /* ora_commit_write ::= WRITE BATCH NOWAIT */
#line 384 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2313 "parser.c"
        break;
      case 35: /* trans_opt_kw ::= TRANSACTION */
#line 387 "./parser.y"
{
  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2320 "parser.c"
        break;
      case 37: /* opt_comma ::= COMMA */
#line 390 "./parser.y"
{
  yy_destructor(yypParser,121,&yymsp[0].minor);
}
#line 2327 "parser.c"
        break;
      case 38: /* transilev ::= ISOLATION LEVEL SERIALIZABLE */
#line 393 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,52,&yymsp[-1].minor);
  yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 2335 "parser.c"
        break;
      case 39: /* transilev ::= ISOLATION LEVEL REPEATABLE READ */
#line 394 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,54,&yymsp[0].minor);
}
#line 2344 "parser.c"
        break;
      case 40: /* transilev ::= ISOLATION LEVEL READ COMMITTED */
#line 395 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,55,&yymsp[0].minor);
}
#line 2353 "parser.c"
        break;
      case 41: /* transilev ::= ISOLATION LEVEL READ UNCOMMITTED */
#line 396 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,56,&yymsp[0].minor);
}
#line 2362 "parser.c"
        break;
      case 42: /* nm_opt ::= */
      case 57: /* opt_on_conflict ::= */ yytestcase(yyruleno==57);
      case 125: /* as ::= */ yytestcase(yyruleno==125);
#line 398 "./parser.y"
{yygotominor.yy0 = NULL;}
#line 2369 "parser.c"
        break;
      case 43: /* nm_opt ::= nm */
      case 44: /* transtype ::= DEFERRED */ yytestcase(yyruleno==44);
      case 45: /* transtype ::= IMMEDIATE */ yytestcase(yyruleno==45);
      case 46: /* transtype ::= EXCLUSIVE */ yytestcase(yyruleno==46);
      case 120: /* starname ::= STAR */ yytestcase(yyruleno==120);
      case 179: /* value ::= STRING */ yytestcase(yyruleno==179);
      case 180: /* value ::= INTEGER */ yytestcase(yyruleno==180);
      case 181: /* value ::= FLOAT */ yytestcase(yyruleno==181);
      case 190: /* nm ::= JOIN */ yytestcase(yyruleno==190);
      case 191: /* nm ::= ID */ yytestcase(yyruleno==191);
      case 192: /* nm ::= TEXTUAL */ yytestcase(yyruleno==192);
      case 193: /* fullname ::= nm */ yytestcase(yyruleno==193);
#line 399 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2385 "parser.c"
        break;
      case 47: /* transtype ::= READ WRITE */
#line 404 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy0, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy0, "READ_WRITE");
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,58,&yymsp[0].minor);
}
#line 2395 "parser.c"
        break;
      case 48: /* transtype ::= READ ONLY */
#line 408 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy0, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy0, "READ_ONLY");
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,59,&yymsp[0].minor);
}
#line 2405 "parser.c"
        break;
      case 49: /* cmd ::= SAVEPOINT nm */
#line 416 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2413 "parser.c"
        break;
      case 50: /* cmd ::= RELEASE SAVEPOINT nm */
#line 420 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,61,&yymsp[-2].minor);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2422 "parser.c"
        break;
      case 51: /* cmd ::= RELEASE nm */
#line 424 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,61,&yymsp[-1].minor);
}
#line 2430 "parser.c"
        break;
      case 52: /* cmd ::= ROLLBACK trans_opt_kw TO nm */
#line 428 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,123,&yymsp[-1].minor);
}
#line 2439 "parser.c"
        break;
      case 53: /* cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm */
#line 432 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-4].minor);
  yy_destructor(yypParser,123,&yymsp[-2].minor);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2449 "parser.c"
        break;
      case 54: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP */
#line 439 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy252, yymsp[-5].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy252, yymsp[-4].minor.yy105);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy252, yymsp[-1].minor.yy33);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy252, yymsp[-7].minor.yy0);
  yy_destructor(yypParser,124,&yymsp[-8].minor);
  yy_destructor(yypParser,125,&yymsp[-6].minor);
  yy_destructor(yypParser,126,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2465 "parser.c"
        break;
      case 55: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values */
#line 447 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy252, yymsp[-6].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy252, yymsp[-5].minor.yy105);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy252, yymsp[-2].minor.yy33);
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy252, yymsp[0].minor.yy105);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy252, yymsp[-8].minor.yy0);
  yy_destructor(yypParser,124,&yymsp[-9].minor);
  yy_destructor(yypParser,125,&yymsp[-7].minor);
  yy_destructor(yypParser,126,&yymsp[-4].minor);
  yy_destructor(yypParser,103,&yymsp[-3].minor);
  yy_destructor(yypParser,104,&yymsp[-1].minor);
}
#line 2482 "parser.c"
        break;
      case 56: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound */
#line 456 "./parser.y"
{
        yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy252, yymsp[-2].minor.yy0);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy252, yymsp[-1].minor.yy105);
        gda_sql_statement_insert_take_select (yygotominor.yy252, yymsp[0].minor.yy252);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy252, yymsp[-4].minor.yy0);
  yy_destructor(yypParser,124,&yymsp[-5].minor);
  yy_destructor(yypParser,125,&yymsp[-3].minor);
}
#line 2495 "parser.c"
        break;
      case 58: /* opt_on_conflict ::= OR ID */
#line 466 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 2501 "parser.c"
        break;
      case 59: /* ins_extra_values ::= ins_extra_values COMMA LP exprlist RP */
#line 476 "./parser.y"
{yygotominor.yy105 = g_slist_append (yymsp[-4].minor.yy105, yymsp[-1].minor.yy33);  yy_destructor(yypParser,121,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2509 "parser.c"
        break;
      case 60: /* ins_extra_values ::= COMMA LP exprlist RP */
#line 477 "./parser.y"
{yygotominor.yy105 = g_slist_append (NULL, yymsp[-1].minor.yy33);  yy_destructor(yypParser,121,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2517 "parser.c"
        break;
      case 61: /* inscollist_opt ::= */
      case 97: /* using_opt ::= */ yytestcase(yyruleno==97);
#line 481 "./parser.y"
{yygotominor.yy105 = NULL;}
#line 2523 "parser.c"
        break;
      case 62: /* inscollist_opt ::= LP inscollist RP */
#line 482 "./parser.y"
{yygotominor.yy105 = yymsp[-1].minor.yy105;  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2530 "parser.c"
        break;
      case 63: /* inscollist ::= inscollist COMMA fullname */
#line 486 "./parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy0);
						    yygotominor.yy105 = g_slist_append (yymsp[-2].minor.yy105, field);
  yy_destructor(yypParser,121,&yymsp[-1].minor);
}
#line 2540 "parser.c"
        break;
      case 64: /* inscollist ::= fullname */
#line 491 "./parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy0);
				yygotominor.yy105 = g_slist_prepend (NULL, field);
}
#line 2548 "parser.c"
        break;
      case 65: /* cmd ::= DELETE FROM fullname where_opt */
#line 497 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy252, yymsp[-1].minor.yy0);
						  gda_sql_statement_delete_take_condition (yygotominor.yy252, yymsp[0].minor.yy302);  yy_destructor(yypParser,127,&yymsp[-3].minor);
  yy_destructor(yypParser,128,&yymsp[-2].minor);
}
#line 2557 "parser.c"
        break;
      case 66: /* where_opt ::= */
      case 89: /* having_opt ::= */ yytestcase(yyruleno==89);
      case 101: /* on_cond ::= */ yytestcase(yyruleno==101);
#line 503 "./parser.y"
{yygotominor.yy302 = NULL;}
#line 2564 "parser.c"
        break;
      case 67: /* where_opt ::= WHERE expr */
#line 504 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;  yy_destructor(yypParser,129,&yymsp[-1].minor);
}
#line 2570 "parser.c"
        break;
      case 68: /* cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt */
#line 507 "./parser.y"
{
	GSList *list;
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy252, yymsp[-3].minor.yy0);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy252, yymsp[-4].minor.yy0);
	gda_sql_statement_update_take_condition (yygotominor.yy252, yymsp[0].minor.yy302);
	for (list = yymsp[-1].minor.yy105; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy252, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy105);
  yy_destructor(yypParser,130,&yymsp[-5].minor);
  yy_destructor(yypParser,131,&yymsp[-2].minor);
}
#line 2589 "parser.c"
        break;
      case 69: /* setlist ::= setlist COMMA fullname EQ expr */
#line 531 "./parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy0;
							 set->expr = yymsp[0].minor.yy302;
							 yygotominor.yy105 = g_slist_append (yymsp[-4].minor.yy105, set);
  yy_destructor(yypParser,121,&yymsp[-3].minor);
  yy_destructor(yypParser,77,&yymsp[-1].minor);
}
#line 2601 "parser.c"
        break;
      case 70: /* setlist ::= fullname EQ expr */
#line 537 "./parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy0;
					set->expr = yymsp[0].minor.yy302;
					yygotominor.yy105 = g_slist_append (NULL, set);
  yy_destructor(yypParser,77,&yymsp[-1].minor);
}
#line 2612 "parser.c"
        break;
      case 71: /* compound ::= selectcmd */
#line 548 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy252, yymsp[0].minor.yy252);
}
#line 2620 "parser.c"
        break;
      case 72: /* compound ::= compound UNION opt_compound_all compound */
#line 552 "./parser.y"
{
	yygotominor.yy252 = compose_multiple_compounds (yymsp[-1].minor.yy100 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy252, yymsp[0].minor.yy252);
  yy_destructor(yypParser,112,&yymsp[-2].minor);
}
#line 2629 "parser.c"
        break;
      case 73: /* compound ::= compound EXCEPT opt_compound_all compound */
#line 557 "./parser.y"
{
	yygotominor.yy252 = compose_multiple_compounds (yymsp[-1].minor.yy100 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy252, yymsp[0].minor.yy252);
  yy_destructor(yypParser,113,&yymsp[-2].minor);
}
#line 2638 "parser.c"
        break;
      case 74: /* compound ::= compound INTERSECT opt_compound_all compound */
#line 562 "./parser.y"
{
	yygotominor.yy252 = compose_multiple_compounds (yymsp[-1].minor.yy100 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy252, yymsp[0].minor.yy252);
  yy_destructor(yypParser,114,&yymsp[-2].minor);
}
#line 2647 "parser.c"
        break;
      case 75: /* opt_compound_all ::= */
#line 568 "./parser.y"
{yygotominor.yy100 = FALSE;}
#line 2652 "parser.c"
        break;
      case 76: /* opt_compound_all ::= ALL */
#line 569 "./parser.y"
{yygotominor.yy100 = TRUE;  yy_destructor(yypParser,132,&yymsp[0].minor);
}
#line 2658 "parser.c"
        break;
      case 77: /* selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 576 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy249) {
		gda_sql_statement_select_take_distinct (yygotominor.yy252, yymsp[-7].minor.yy249->distinct, yymsp[-7].minor.yy249->expr);
		g_free (yymsp[-7].minor.yy249);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy252, yymsp[-6].minor.yy33);
	gda_sql_statement_select_take_from (yygotominor.yy252, yymsp[-5].minor.yy259);
	gda_sql_statement_select_take_where_cond (yygotominor.yy252, yymsp[-4].minor.yy302);
	gda_sql_statement_select_take_group_by (yygotominor.yy252, yymsp[-3].minor.yy105);
	gda_sql_statement_select_take_having_cond (yygotominor.yy252, yymsp[-2].minor.yy302);
	gda_sql_statement_select_take_order_by (yygotominor.yy252, yymsp[-1].minor.yy33);
	gda_sql_statement_select_take_limits (yygotominor.yy252, yymsp[0].minor.yy408.count, yymsp[0].minor.yy408.offset);
  yy_destructor(yypParser,133,&yymsp[-8].minor);
}
#line 2677 "parser.c"
        break;
      case 78: /* limit_opt ::= */
#line 593 "./parser.y"
{yygotominor.yy408.count = NULL; yygotominor.yy408.offset = NULL;}
#line 2682 "parser.c"
        break;
      case 79: /* limit_opt ::= LIMIT expr */
#line 594 "./parser.y"
{yygotominor.yy408.count = yymsp[0].minor.yy302; yygotominor.yy408.offset = NULL;  yy_destructor(yypParser,134,&yymsp[-1].minor);
}
#line 2688 "parser.c"
        break;
      case 80: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 595 "./parser.y"
{yygotominor.yy408.count = yymsp[-2].minor.yy302; yygotominor.yy408.offset = yymsp[0].minor.yy302;  yy_destructor(yypParser,134,&yymsp[-3].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
}
#line 2695 "parser.c"
        break;
      case 81: /* limit_opt ::= LIMIT expr COMMA expr */
#line 596 "./parser.y"
{yygotominor.yy408.count = yymsp[-2].minor.yy302; yygotominor.yy408.offset = yymsp[0].minor.yy302;  yy_destructor(yypParser,134,&yymsp[-3].minor);
  yy_destructor(yypParser,121,&yymsp[-1].minor);
}
#line 2702 "parser.c"
        break;
      case 82: /* orderby_opt ::= */
#line 600 "./parser.y"
{yygotominor.yy33 = 0;}
#line 2707 "parser.c"
        break;
      case 83: /* orderby_opt ::= ORDER BY sortlist */
#line 601 "./parser.y"
{yygotominor.yy33 = yymsp[0].minor.yy33;  yy_destructor(yypParser,135,&yymsp[-2].minor);
  yy_destructor(yypParser,136,&yymsp[-1].minor);
}
#line 2714 "parser.c"
        break;
      case 84: /* sortlist ::= sortlist COMMA expr sortorder */
#line 605 "./parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy302;
							 order->asc = yymsp[0].minor.yy100;
							 yygotominor.yy33 = g_slist_append (yymsp[-3].minor.yy33, order);
  yy_destructor(yypParser,121,&yymsp[-2].minor);
}
#line 2725 "parser.c"
        break;
      case 85: /* sortlist ::= expr sortorder */
#line 611 "./parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy302;
				       order->asc = yymsp[0].minor.yy100;
				       yygotominor.yy33 = g_slist_prepend (NULL, order);
}
#line 2735 "parser.c"
        break;
      case 86: /* sortorder ::= ASC */
#line 619 "./parser.y"
{yygotominor.yy100 = TRUE;  yy_destructor(yypParser,5,&yymsp[0].minor);
}
#line 2741 "parser.c"
        break;
      case 87: /* sortorder ::= DESC */
#line 620 "./parser.y"
{yygotominor.yy100 = FALSE;  yy_destructor(yypParser,14,&yymsp[0].minor);
}
#line 2747 "parser.c"
        break;
      case 88: /* sortorder ::= */
#line 621 "./parser.y"
{yygotominor.yy100 = TRUE;}
#line 2752 "parser.c"
        break;
      case 90: /* having_opt ::= HAVING expr */
#line 627 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;  yy_destructor(yypParser,137,&yymsp[-1].minor);
}
#line 2758 "parser.c"
        break;
      case 91: /* groupby_opt ::= */
#line 631 "./parser.y"
{yygotominor.yy105 = 0;}
#line 2763 "parser.c"
        break;
      case 92: /* groupby_opt ::= GROUP BY nexprlist */
#line 632 "./parser.y"
{yygotominor.yy105 = yymsp[0].minor.yy33;  yy_destructor(yypParser,138,&yymsp[-2].minor);
  yy_destructor(yypParser,136,&yymsp[-1].minor);
}
#line 2770 "parser.c"
        break;
      case 93: /* from ::= */
      case 98: /* stl_prefix ::= */ yytestcase(yyruleno==98);
#line 636 "./parser.y"
{yygotominor.yy259 = NULL;}
#line 2776 "parser.c"
        break;
      case 94: /* from ::= FROM seltablist */
#line 637 "./parser.y"
{yygotominor.yy259 = yymsp[0].minor.yy259;  yy_destructor(yypParser,128,&yymsp[-1].minor);
}
#line 2782 "parser.c"
        break;
      case 95: /* seltablist ::= stl_prefix seltarget on_cond using_opt */
#line 644 "./parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy259)
		yygotominor.yy259 = yymsp[-3].minor.yy259;
	else 
		yygotominor.yy259 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy259, yymsp[-2].minor.yy414);
	last = g_slist_last (yygotominor.yy259->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy302;
		join->position = g_slist_length (yygotominor.yy259->targets) - 1;
		join->use = yymsp[0].minor.yy105;
	}
}
#line 2801 "parser.c"
        break;
      case 96: /* using_opt ::= USING LP inscollist RP */
#line 662 "./parser.y"
{yygotominor.yy105 = yymsp[-1].minor.yy105;  yy_destructor(yypParser,139,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 2809 "parser.c"
        break;
      case 99: /* stl_prefix ::= seltablist jointype */
#line 666 "./parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy259 = yymsp[-1].minor.yy259;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy259));
					      join->type = yymsp[0].minor.yy367;
					      gda_sql_select_from_take_new_join (yygotominor.yy259, join);
}
#line 2819 "parser.c"
        break;
      case 100: /* on_cond ::= ON expr */
#line 676 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;  yy_destructor(yypParser,140,&yymsp[-1].minor);
}
#line 2825 "parser.c"
        break;
      case 102: /* jointype ::= COMMA */
#line 680 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,121,&yymsp[0].minor);
}
#line 2831 "parser.c"
        break;
      case 103: /* jointype ::= JOIN */
#line 681 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2837 "parser.c"
        break;
      case 104: /* jointype ::= CROSS JOIN */
#line 682 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,111,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2844 "parser.c"
        break;
      case 105: /* jointype ::= INNER JOIN */
#line 683 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,106,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2851 "parser.c"
        break;
      case 106: /* jointype ::= NATURAL JOIN */
#line 684 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(yypParser,107,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2858 "parser.c"
        break;
      case 107: /* jointype ::= LEFT JOIN */
#line 685 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,108,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2865 "parser.c"
        break;
      case 108: /* jointype ::= LEFT OUTER JOIN */
#line 686 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,108,&yymsp[-2].minor);
  yy_destructor(yypParser,141,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2873 "parser.c"
        break;
      case 109: /* jointype ::= RIGHT JOIN */
#line 687 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,109,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2880 "parser.c"
        break;
      case 110: /* jointype ::= RIGHT OUTER JOIN */
#line 688 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,109,&yymsp[-2].minor);
  yy_destructor(yypParser,141,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2888 "parser.c"
        break;
      case 111: /* jointype ::= FULL JOIN */
#line 689 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,110,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2895 "parser.c"
        break;
      case 112: /* jointype ::= FULL OUTER JOIN */
#line 690 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,110,&yymsp[-2].minor);
  yy_destructor(yypParser,141,&yymsp[-1].minor);
  yy_destructor(yypParser,105,&yymsp[0].minor);
}
#line 2903 "parser.c"
        break;
      case 113: /* seltarget ::= fullname as */
#line 695 "./parser.y"
{yygotominor.yy414 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy414, yymsp[0].minor.yy0);
				     gda_sql_select_target_take_table_name (yygotominor.yy414, yymsp[-1].minor.yy0);
}
#line 2911 "parser.c"
        break;
      case 114: /* seltarget ::= fullname ID */
#line 699 "./parser.y"
{yygotominor.yy414 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy414, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy414, yymsp[-1].minor.yy0);
}
#line 2919 "parser.c"
        break;
      case 115: /* seltarget ::= LP compound RP as */
#line 703 "./parser.y"
{yygotominor.yy414 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy414, yymsp[0].minor.yy0);
					     gda_sql_select_target_take_select (yygotominor.yy414, yymsp[-2].minor.yy252);
  yy_destructor(yypParser,103,&yymsp[-3].minor);
  yy_destructor(yypParser,104,&yymsp[-1].minor);
}
#line 2929 "parser.c"
        break;
      case 116: /* sclp ::= selcollist COMMA */
#line 713 "./parser.y"
{yygotominor.yy33 = yymsp[-1].minor.yy33;  yy_destructor(yypParser,121,&yymsp[0].minor);
}
#line 2935 "parser.c"
        break;
      case 117: /* sclp ::= */
      case 132: /* exprlist ::= */ yytestcase(yyruleno==132);
#line 714 "./parser.y"
{yygotominor.yy33 = NULL;}
#line 2941 "parser.c"
        break;
      case 118: /* selcollist ::= sclp expr as */
#line 716 "./parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy302);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy0); 
					  yygotominor.yy33 = g_slist_append (yymsp[-2].minor.yy33, field);}
#line 2950 "parser.c"
        break;
      case 119: /* selcollist ::= sclp starname */
#line 721 "./parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy0);
					yygotominor.yy33 = g_slist_append (yymsp[-1].minor.yy33, field);}
#line 2958 "parser.c"
        break;
      case 121: /* starname ::= nm DOT STAR */
      case 194: /* fullname ::= nm DOT nm */ yytestcase(yyruleno==194);
#line 727 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 2972 "parser.c"
        break;
      case 122: /* starname ::= nm DOT nm DOT STAR */
      case 195: /* fullname ::= nm DOT nm DOT nm */ yytestcase(yyruleno==195);
#line 736 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy0), 
							 g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-4].minor.yy0); g_free (yymsp[-4].minor.yy0);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,142,&yymsp[-3].minor);
  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 2989 "parser.c"
        break;
      case 123: /* as ::= AS fullname */
      case 124: /* as ::= AS value */ yytestcase(yyruleno==124);
#line 747 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,143,&yymsp[-1].minor);
}
#line 2996 "parser.c"
        break;
      case 126: /* distinct ::= */
#line 753 "./parser.y"
{yygotominor.yy249 = NULL;}
#line 3001 "parser.c"
        break;
      case 127: /* distinct ::= ALL */
#line 754 "./parser.y"
{yygotominor.yy249 = NULL;  yy_destructor(yypParser,132,&yymsp[0].minor);
}
#line 3007 "parser.c"
        break;
      case 128: /* distinct ::= DISTINCT */
#line 755 "./parser.y"
{yygotominor.yy249 = g_new0 (Distinct, 1); yygotominor.yy249->distinct = TRUE;  yy_destructor(yypParser,144,&yymsp[0].minor);
}
#line 3013 "parser.c"
        break;
      case 129: /* distinct ::= DISTINCT ON expr */
#line 756 "./parser.y"
{yygotominor.yy249 = g_new0 (Distinct, 1); yygotominor.yy249->distinct = TRUE; yygotominor.yy249->expr = yymsp[0].minor.yy302;  yy_destructor(yypParser,144,&yymsp[-2].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
}
#line 3020 "parser.c"
        break;
      case 130: /* nexprlist ::= nexprlist COMMA expr */
      case 133: /* exprlist ::= exprlist COMMA expr */ yytestcase(yyruleno==133);
#line 761 "./parser.y"
{yygotominor.yy33 = g_slist_append (yymsp[-2].minor.yy33, yymsp[0].minor.yy302);  yy_destructor(yypParser,121,&yymsp[-1].minor);
}
#line 3027 "parser.c"
        break;
      case 131: /* nexprlist ::= expr */
      case 134: /* exprlist ::= expr */ yytestcase(yyruleno==134);
#line 762 "./parser.y"
{yygotominor.yy33 = g_slist_append (NULL, yymsp[0].minor.yy302);}
#line 3033 "parser.c"
        break;
      case 135: /* expr ::= pvalue */
#line 774 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;}
#line 3038 "parser.c"
        break;
      case 136: /* expr ::= value */
      case 138: /* expr ::= fullname */ yytestcase(yyruleno==138);
#line 775 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->value = yymsp[0].minor.yy0;}
#line 3044 "parser.c"
        break;
      case 137: /* expr ::= LP expr RP */
#line 776 "./parser.y"
{yygotominor.yy302 = yymsp[-1].minor.yy302;  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3051 "parser.c"
        break;
      case 139: /* expr ::= fullname LP exprlist RP */
#line 778 "./parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy302 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy302)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    gda_sql_function_take_args_list (func, yymsp[-1].minor.yy33);
					    yygotominor.yy302->func = func;  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3063 "parser.c"
        break;
      case 140: /* expr ::= fullname LP compound RP */
#line 784 "./parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy302 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy302)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy252);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy302->func = func;  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3078 "parser.c"
        break;
      case 141: /* expr ::= fullname LP starname RP */
#line 793 "./parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy302 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy0;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy302->func = func;  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3093 "parser.c"
        break;
      case 142: /* expr ::= CAST LP expr AS fullname RP */
#line 802 "./parser.y"
{yygotominor.yy302 = yymsp[-3].minor.yy302;
						yymsp[-3].minor.yy302->cast_as = g_value_dup_string (yymsp[-1].minor.yy0);
						g_value_reset (yymsp[-1].minor.yy0);
						g_free (yymsp[-1].minor.yy0);  yy_destructor(yypParser,10,&yymsp[-5].minor);
  yy_destructor(yypParser,103,&yymsp[-4].minor);
  yy_destructor(yypParser,143,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3105 "parser.c"
        break;
      case 143: /* expr ::= expr PGCAST fullname */
#line 806 "./parser.y"
{yygotominor.yy302 = yymsp[-2].minor.yy302;
					 yymsp[-2].minor.yy302->cast_as = g_value_dup_string (yymsp[0].minor.yy0);
					 g_value_reset (yymsp[0].minor.yy0);
					 g_free (yymsp[0].minor.yy0);  yy_destructor(yypParser,115,&yymsp[-1].minor);
}
#line 3114 "parser.c"
        break;
      case 144: /* expr ::= expr PLUS|MINUS expr */
#line 811 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy302, yymsp[0].minor.yy302);}
#line 3119 "parser.c"
        break;
      case 145: /* expr ::= expr STAR expr */
#line 812 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_STAR, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,95,&yymsp[-1].minor);
}
#line 3125 "parser.c"
        break;
      case 146: /* expr ::= expr SLASH|REM expr */
      case 147: /* expr ::= expr BITAND|BITOR expr */ yytestcase(yyruleno==147);
      case 153: /* expr ::= expr GT|LEQ|GEQ|LT expr */ yytestcase(yyruleno==153);
      case 154: /* expr ::= expr DIFF|EQ expr */ yytestcase(yyruleno==154);
      case 157: /* expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr */ yytestcase(yyruleno==157);
#line 813 "./parser.y"
{yygotominor.yy302 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy302, yymsp[0].minor.yy302);}
#line 3134 "parser.c"
        break;
      case 148: /* expr ::= MINUS expr */
#line 816 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_MINUS, yymsp[0].minor.yy302);  yy_destructor(yypParser,94,&yymsp[-1].minor);
}
#line 3140 "parser.c"
        break;
      case 149: /* expr ::= PLUS expr */
#line 817 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_PLUS, yymsp[0].minor.yy302);  yy_destructor(yypParser,93,&yymsp[-1].minor);
}
#line 3146 "parser.c"
        break;
      case 150: /* expr ::= expr AND expr */
#line 819 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_AND, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3152 "parser.c"
        break;
      case 151: /* expr ::= expr OR expr */
#line 820 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_OR, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 3158 "parser.c"
        break;
      case 152: /* expr ::= expr CONCAT expr */
#line 821 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_CONCAT, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,98,&yymsp[-1].minor);
}
#line 3164 "parser.c"
        break;
      case 155: /* expr ::= expr LIKE expr */
#line 825 "./parser.y"
{yygotominor.yy302 = create_two_expr (GDA_SQL_OPERATOR_TYPE_LIKE, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,26,&yymsp[-1].minor);
}
#line 3170 "parser.c"
        break;
      case 156: /* expr ::= expr ILIKE expr */
#line 826 "./parser.y"
{yygotominor.yy302 = create_two_expr (GDA_SQL_OPERATOR_TYPE_ILIKE, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,27,&yymsp[-1].minor);
}
#line 3176 "parser.c"
        break;
      case 158: /* expr ::= expr BETWEEN expr AND expr */
#line 828 "./parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy302 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
						  yygotominor.yy302->cond = cond;
						  cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy302);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy302);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy302);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,78,&yymsp[-3].minor);
  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3194 "parser.c"
        break;
      case 159: /* expr ::= expr NOT BETWEEN expr AND expr */
#line 841 "./parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy302);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy302);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy302);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy302 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
						      yygotominor.yy302->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-4].minor);
  yy_destructor(yypParser,78,&yymsp[-3].minor);
  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3221 "parser.c"
        break;
      case 160: /* expr ::= NOT expr */
#line 862 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_NOT, yymsp[0].minor.yy302);  yy_destructor(yypParser,71,&yymsp[-1].minor);
}
#line 3227 "parser.c"
        break;
      case 161: /* expr ::= BITNOT expr */
#line 863 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_BITNOT, yymsp[0].minor.yy302);  yy_destructor(yypParser,102,&yymsp[-1].minor);
}
#line 3233 "parser.c"
        break;
      case 162: /* expr ::= expr uni_op */
#line 864 "./parser.y"
{yygotominor.yy302 = create_uni_expr (yymsp[0].minor.yy295, yymsp[-1].minor.yy302);}
#line 3238 "parser.c"
        break;
      case 163: /* expr ::= expr IS expr */
#line 866 "./parser.y"
{yygotominor.yy302 = create_two_expr (GDA_SQL_OPERATOR_TYPE_IS, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,72,&yymsp[-1].minor);
}
#line 3244 "parser.c"
        break;
      case 164: /* expr ::= LP compound RP */
#line 867 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy302, yymsp[-1].minor.yy252);  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3251 "parser.c"
        break;
      case 165: /* expr ::= expr IN LP exprlist RP */
#line 868 "./parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy302 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					   yygotominor.yy302->cond = cond;
					   cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					   cond->operands = g_slist_prepend (yymsp[-1].minor.yy33, yymsp[-4].minor.yy302);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,73,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3268 "parser.c"
        break;
      case 166: /* expr ::= expr IN LP compound RP */
#line 878 "./parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy302 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					    yygotominor.yy302->cond = cond;
					    cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy252);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy302);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,73,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3288 "parser.c"
        break;
      case 167: /* expr ::= expr NOT IN LP exprlist RP */
#line 891 "./parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy302 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					       yygotominor.yy302->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       cond->operands = g_slist_prepend (yymsp[-1].minor.yy33, yymsp[-5].minor.yy302);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-4].minor);
  yy_destructor(yypParser,73,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3306 "parser.c"
        break;
      case 168: /* expr ::= expr NOT IN LP compound RP */
#line 901 "./parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy302 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					       yygotominor.yy302->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy252);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy302);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-4].minor);
  yy_destructor(yypParser,73,&yymsp[-3].minor);
  yy_destructor(yypParser,103,&yymsp[-2].minor);
  yy_destructor(yypParser,104,&yymsp[0].minor);
}
#line 3327 "parser.c"
        break;
      case 169: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 914 "./parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy302 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy302));
	sc->base_expr = yymsp[-3].minor.yy354;
	sc->else_expr = yymsp[-1].minor.yy354;
	sc->when_expr_list = yymsp[-2].minor.yy51.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy51.then_list;
	yygotominor.yy302->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(yypParser,145,&yymsp[-4].minor);
  yy_destructor(yypParser,17,&yymsp[0].minor);
}
#line 3348 "parser.c"
        break;
      case 170: /* case_operand ::= expr */
#line 932 "./parser.y"
{yygotominor.yy354 = yymsp[0].minor.yy302;}
#line 3353 "parser.c"
        break;
      case 171: /* case_operand ::= */
      case 175: /* case_else ::= */ yytestcase(yyruleno==175);
#line 933 "./parser.y"
{yygotominor.yy354 = NULL;}
#line 3359 "parser.c"
        break;
      case 172: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 939 "./parser.y"
{
	yygotominor.yy51.when_list = g_slist_append (yymsp[-4].minor.yy51.when_list, yymsp[-2].minor.yy302);
	yygotominor.yy51.then_list = g_slist_append (yymsp[-4].minor.yy51.then_list, yymsp[0].minor.yy302);
  yy_destructor(yypParser,146,&yymsp[-3].minor);
  yy_destructor(yypParser,147,&yymsp[-1].minor);
}
#line 3369 "parser.c"
        break;
      case 173: /* case_exprlist ::= WHEN expr THEN expr */
#line 943 "./parser.y"
{
	yygotominor.yy51.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy302);
	yygotominor.yy51.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy302);
  yy_destructor(yypParser,146,&yymsp[-3].minor);
  yy_destructor(yypParser,147,&yymsp[-1].minor);
}
#line 3379 "parser.c"
        break;
      case 174: /* case_else ::= ELSE expr */
#line 950 "./parser.y"
{yygotominor.yy354 = yymsp[0].minor.yy302;  yy_destructor(yypParser,148,&yymsp[-1].minor);
}
#line 3385 "parser.c"
        break;
      case 176: /* uni_op ::= ISNULL */
#line 954 "./parser.y"
{yygotominor.yy295 = GDA_SQL_OPERATOR_TYPE_ISNULL;  yy_destructor(yypParser,74,&yymsp[0].minor);
}
#line 3391 "parser.c"
        break;
      case 177: /* uni_op ::= IS NOTNULL */
#line 955 "./parser.y"
{yygotominor.yy295 = GDA_SQL_OPERATOR_TYPE_ISNOTNULL;  yy_destructor(yypParser,72,&yymsp[-1].minor);
  yy_destructor(yypParser,75,&yymsp[0].minor);
}
#line 3398 "parser.c"
        break;
      case 178: /* value ::= NULL */
#line 959 "./parser.y"
{yygotominor.yy0 = NULL;  yy_destructor(yypParser,149,&yymsp[0].minor);
}
#line 3404 "parser.c"
        break;
      case 182: /* pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET */
#line 968 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->param_spec = yymsp[-1].minor.yy303;  yy_destructor(yypParser,151,&yymsp[-3].minor);
  yy_destructor(yypParser,152,&yymsp[-2].minor);
  yy_destructor(yypParser,153,&yymsp[0].minor);
}
#line 3412 "parser.c"
        break;
      case 183: /* pvalue ::= value LSBRACKET paramspec RSBRACKET */
#line 969 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->value = yymsp[-3].minor.yy0; yygotominor.yy302->param_spec = yymsp[-1].minor.yy303;  yy_destructor(yypParser,152,&yymsp[-2].minor);
  yy_destructor(yypParser,153,&yymsp[0].minor);
}
#line 3419 "parser.c"
        break;
      case 184: /* pvalue ::= SIMPLEPARAM */
#line 970 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3424 "parser.c"
        break;
      case 185: /* paramspec ::= */
#line 975 "./parser.y"
{yygotominor.yy303 = NULL;}
#line 3429 "parser.c"
        break;
      case 186: /* paramspec ::= paramspec PNAME */
#line 976 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					 gda_sql_param_spec_take_name (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3435 "parser.c"
        break;
      case 187: /* paramspec ::= paramspec PDESCR */
#line 978 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					 gda_sql_param_spec_take_descr (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3441 "parser.c"
        break;
      case 188: /* paramspec ::= paramspec PTYPE */
#line 980 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					 gda_sql_param_spec_take_type (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3447 "parser.c"
        break;
      case 189: /* paramspec ::= paramspec PNULLOK */
#line 982 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3453 "parser.c"
        break;
      default:
      /* (34) trans_opt_kw ::= */ yytestcase(yyruleno==34);
      /* (36) opt_comma ::= */ yytestcase(yyruleno==36);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  gda_sql_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 22 "./parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3520 "parser.c"
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "gda_sql_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void gda_sql_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  gda_sql_parserTOKENTYPE yyminor       /* The value for the token */
  gda_sql_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  gda_sql_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
