/* collection.c generated by valac, the Vala compiler
 * generated from collection.vala, do not modify */

/* collection.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};



GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add_all (GeeCollection* self, GeeCollection* collection);
gboolean gee_collection_contains_all (GeeCollection* self, GeeCollection* collection);
gboolean gee_collection_remove_all (GeeCollection* self, GeeCollection* collection);
gboolean gee_collection_retain_all (GeeCollection* self, GeeCollection* collection);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GeeSet* gee_abstract_set_get_read_only_view (GeeAbstractSet* self);
GeeCollection* gee_collection_empty (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gint gee_collection_get_size (GeeCollection* self);
gboolean gee_collection_get_is_empty (GeeCollection* self);
GeeCollection* gee_collection_get_read_only_view (GeeCollection* self);



/**
 * Determines whether this collection contains the specified item.
 *
 * @param item the item to locate in the collection
 *
 * @return     `true` if item is found, `false` otherwise
 */
#line 44 "collection.vala"
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item) {
#line 44 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->contains (self, item);
#line 169 "collection.c"
}


/**
 * Adds an item to this collection. Must not be called on read-only
 * collections.
 *
 * @param item the item to add to the collection
 *
 * @return     `true` if the collection has been changed, `false` otherwise
 */
#line 54 "collection.vala"
gboolean gee_collection_add (GeeCollection* self, gconstpointer item) {
#line 54 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->add (self, item);
#line 185 "collection.c"
}


/**
 * Removes the first occurence of an item from this collection. Must not
 * be called on read-only collections.
 *
 * @param item the item to remove from the collection
 *
 * @return     `true` if the collection has been changed, `false` otherwise
 */
#line 64 "collection.vala"
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item) {
#line 64 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->remove (self, item);
#line 201 "collection.c"
}


/**
 * Removes all items from this collection. Must not be called on
 * read-only collections.
 */
#line 70 "collection.vala"
void gee_collection_clear (GeeCollection* self) {
#line 70 "collection.vala"
	GEE_COLLECTION_GET_INTERFACE (self)->clear (self);
#line 213 "collection.c"
}


/**
 * Adds all items in the input collection to this collection.
 *
 * @param collection the collection which items will be added to this
 *                   collection.
 *
 * @return     `true` if the collection has been changed, `false` otherwise
 */
#line 80 "collection.vala"
gboolean gee_collection_add_all (GeeCollection* self, GeeCollection* collection) {
#line 80 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->add_all (self, collection);
#line 229 "collection.c"
}


/**
 * Returns `true` it this collection contains all items as the input
 * collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     `true` if the collection has been changed, `false` otherwise
 */
#line 91 "collection.vala"
gboolean gee_collection_contains_all (GeeCollection* self, GeeCollection* collection) {
#line 91 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->contains_all (self, collection);
#line 246 "collection.c"
}


/**
 * Removes the subset of items in this collection corresponding to the
 * elments in the input collection. If there is several occurrences of
 * the same value in this collection they are decremented of the number
 * of occurrences in the input collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     `true` if the collection has been changed, `false` otherwise
 */
#line 104 "collection.vala"
gboolean gee_collection_remove_all (GeeCollection* self, GeeCollection* collection) {
#line 104 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->remove_all (self, collection);
#line 265 "collection.c"
}


/**
 * Removes all items in this collection that are not contained in the input
 * collection. In other words all common items of both collections are
 * retained in this collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     `true` if the collection has been changed, `false` otherwise
 */
#line 116 "collection.vala"
gboolean gee_collection_retain_all (GeeCollection* self, GeeCollection* collection) {
#line 116 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->retain_all (self, collection);
#line 283 "collection.c"
}


/**
 * Returns an array containing all of items from this collection.
 *
 * @return an array containing all of items from this collection
 */
#line 123 "collection.vala"
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1) {
#line 123 "collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->to_array (self, result_length1);
#line 296 "collection.c"
}


/**
 * Returns an immutable empty collection.
 *
 * @return an immutable empty collection
 */
#line 135 "collection.vala"
GeeCollection* gee_collection_empty (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
#line 307 "collection.c"
	GeeCollection* result = NULL;
	GeeHashSet* _tmp0_;
	GeeCollection* _tmp1_;
	result = (_tmp1_ = (GeeCollection*) gee_abstract_set_get_read_only_view ((GeeAbstractSet*) (_tmp0_ = gee_hash_set_new (g_type, (GBoxedCopyFunc) g_dup_func, NULL, NULL, NULL))), _g_object_unref0 (_tmp0_), _tmp1_);
#line 136 "collection.vala"
	return result;
#line 314 "collection.c"
}


gint gee_collection_get_size (GeeCollection* self) {
	return GEE_COLLECTION_GET_INTERFACE (self)->get_size (self);
}


gboolean gee_collection_get_is_empty (GeeCollection* self) {
	return GEE_COLLECTION_GET_INTERFACE (self)->get_is_empty (self);
}


GeeCollection* gee_collection_get_read_only_view (GeeCollection* self) {
	return GEE_COLLECTION_GET_INTERFACE (self)->get_read_only_view (self);
}


static void gee_collection_base_init (GeeCollectionIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * The number of items in this collection.
		 */
		g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * Specifies whether this collection is empty.
		 */
		g_object_interface_install_property (iface, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		 * The read-only view of this collection.
		 */
		g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


/**
 * A generic collection of objects.
 */
GType gee_collection_get_type (void) {
	static volatile gsize gee_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gee_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeCollectionIface), (GBaseInitFunc) gee_collection_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_collection_type_id;
		gee_collection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeCollection", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_collection_type_id, GEE_TYPE_ITERABLE);
		g_once_init_leave (&gee_collection_type_id__volatile, gee_collection_type_id);
	}
	return gee_collection_type_id__volatile;
}




