/*******************************************************************************************************************************************
 cexception.h
*******************************************************************************************************************************************/

#include "cexception.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// exception garbage definition
//------------------------------------------------------------------------------------------------------------------------------------------
struct CExceptionGarbage
{
	NServices::TBuffer <CException *> Exceptions;
	CExceptionGarbage () { }
       ~CExceptionGarbage () { while (Exceptions.GetLength() > 0) delete *Exceptions[0]; }
};

static CExceptionGarbage ExceptionGarbage;

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_CAPSULE_METACLASS (CException);

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CException::CException   (const CString &inMessage, const TException inErrorCode)
	   :m_Message    (inMessage),
	    m_ErrorCode  (inErrorCode)
{ 
	ExceptionGarbage.Exceptions += this;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CException::~CException ()
{ 
	ExceptionGarbage.Exceptions -= this;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// exception message
//------------------------------------------------------------------------------------------------------------------------------------------
CString CException::GetMessage () const
{
	return m_Message;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// exception code
//------------------------------------------------------------------------------------------------------------------------------------------
TException CException::GetErrorCode () const
{
	return m_ErrorCode;
}
