/*
 * @(#)AbstractWriterServerUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.testserver;

import net.sourceforge.groboutils.autodoc.v1.*;

import java.io.Writer;
import java.io.StringWriter;
import java.io.IOException;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;


/**
 * Tests the AbstractWriterServer abstract class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     April 8, 2002
 * @version   $Date: 2003/02/10 22:52:17 $
 */
public class AbstractWriterServerUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AbstractWriterServerUTestI.class;
    
    public AbstractWriterServerUTestI( String name, ImplFactory f )
    {
        super( name, AbstractWriterServer.class, f );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }

    
    public AbstractWriterServer createAbstractWriterServer()
    {
        return (AbstractWriterServer)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testWriteTestData1() throws Exception
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        StringWriter sw = new StringWriter();
        
        // should fail gracefully
        aws.writeTestData( null, sw );
    }
    
    
    public void testWriteTestData2() throws Exception
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        StringWriter sw = new StringWriter();
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return null;
            }
        };
        
        // should fail gracefully
        aws.writeTestData( td, sw );
    }
    
    
    public void testWriteTestData3() throws Exception
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        StringWriter sw = new StringWriter();
        final TestInfo ti = new DefaultTestInfo( "a", "b" );
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return ti;
            }
        };
        
        // should work w/o error
        aws.writeTestData( td, sw );
    }
    
    
    public void testWriteTestData4() throws Exception
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        StringWriter sw = new StringWriter();
        final TestInfo ti = new DefaultTestInfo();
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return ti;
            }
        };
        
        // should fail gracefully, if it does fail.
        aws.writeTestData( td, sw );
    }
    
    
    protected void _innerOpenOutput( AbstractWriterServer aws, TestData td )
    {
        try
        {
            Writer w = aws.openOutput( td );
            assertNotNull(
                "If no exception was thrown, then openOutput must never "+
                "return null.",
                w );
            aws.closeOutput( w );
        }
        catch (IOException ioe)
        {
            // this exception is fine.
        }
    }
    
    
    public void testOpenOutput1()
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        
        try
        {
            _innerOpenOutput( aws, null );
        }
        catch (NullPointerException e)
        {
            // this is ok
        }
        catch (IllegalArgumentException e)
        {
            // this is ok
        }
    }
    
    
    public void testOpenOutput2()
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        StringWriter sw = new StringWriter();
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return null;
            }
        };
        
        
        try
        {
            _innerOpenOutput( aws, td );
        }
        catch (NullPointerException e)
        {
            // this is ok
        }
        catch (IllegalArgumentException e)
        {
            // this is ok
        }
    }
    
    
    public void testOpenOutput3()
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        StringWriter sw = new StringWriter();
        final TestInfo ti = new DefaultTestInfo();
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return ti;
            }
        };
        
        _innerOpenOutput( aws, td );
    }
    
    
    public void testOpenOutput4()
    {
        AbstractWriterServer aws = createAbstractWriterServer();
        StringWriter sw = new StringWriter();
        final TestInfo ti = new DefaultTestInfo( "a", "b" );
        TestData td = new TestData() {
            public TestInfo getTestInfo() {
                return ti;
            }
        };
        
        _innerOpenOutput( aws, td );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        suite.addInterfaceTestSuite( ServerUTestI.suite() );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

