/*
 * StateSet.java - 0.9.0    01/13/2001 - 16:51:36
 *
 * Copyright (C) 2000,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.groboclown.util.states.v1;

import java.util.Vector;


/**
 * A simple StateMachine where the transition to state mapping is 1-to-1.
 *
 * @author Matt Albrecht
 * @version 0.9.0 Alpha
 */
public class StateSet
{
    //---------------------------------------------------------------------
    // Public Static Fields
     
     
    //---------------------------------------------------------------------
    // Protected Static Fields
     
     
    //---------------------------------------------------------------------
    // Private Static Fields
     
     
    //---------------------------------------------------------------------
    // Public Fields
     
     
    //---------------------------------------------------------------------
    // Protected Fields
     
     
    //---------------------------------------------------------------------
    // Private Fields
    
    
    private StateCategory states = new StateCategory();
    private Vector statefuls = new Vector();
    private State currentState = null;
     
     
    //---------------------------------------------------------------------
    // Constructors
     
     
    /**
     * Default Constructor
     */
    public StateSet()
    {
        // do nothing
    }
     
     
     
     
     
    //---------------------------------------------------------------------
    // Public Methods
     
    /**
     * 
     */
    public State createNextState()
    {
        return this.states.getNextState();
    }
    
    
    /**
     * 
     */
    public void addStateful( Stateful s )
    {
        if (s == null)
        {
            throw new IllegalArgumentException( "no null args" );
        }
        s.initialize( this.states );
        this.statefuls.addElement( s );
    }
    
    
    /**
     * 
     */
    public void removeStateful( Stateful s )
    {
        if (s == null)
        {
            throw new IllegalArgumentException( "no null args" );
        }
        this.statefuls.removeElement( s );
    }
    
    
    /**
     * 
     */
    public void setState( State s )
    {
        if (!this.states.isOfCategory( s ))
        {
            throw new IllegalStateException("wrong state category");
        }
        this.currentState = s;
        for (int i = this.statefuls.size(); --i >= 0;)
        {
            ((Stateful)this.statefuls.elementAt(i)).setState( s );
        }
    }
    
     
    //---------------------------------------------------------------------
    // Protected Methods
     
     
    //---------------------------------------------------------------------
    // Private Methods
     
     
}
 
