#!/usr/bin/env ruby
require("gsl")
require("../gsl_test2.rb")
require("./gsl_test_sf.rb")
include GSL::Test
include Math
include GSL::Test::Sf
s = 0
m = GSL::MODE_DEFAULT
mode = GSL::MODE_DEFAULT
GSL::set_error_handler_off
  TEST_SF(s,  "GSL::Sf::clausen_e", "(M_PI/20.0)", 0.4478882448133546, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::clausen_e", "(M_PI/6.0)", 0.8643791310538927, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::clausen_e", "(M_PI/3.0)", 1.0149416064096535, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::clausen_e", "(  2.0*M_PI + M_PI/3.0)", 1.0149416064096535, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::clausen_e", "(100.0*M_PI + M_PI/3.0)", 1.0149416064096535, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(0, 1, 1, 0,  1, -1)", sqrt(1.0/2.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, 1, 2, 1, -1,  0)", sqrt(1.0/6.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(2, 4, 6, 0,  2, -2)", sqrt(8.0/105.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(4, 4, 8, 0,  0,  0)", sqrt(2.0/35.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(4, 4, 8, 2, -2,  0)", 2.0/3.0*sqrt(2.0/35.0), TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(4, 4, 8, 4, -4,  0)", 1.0/(3.0*sqrt(70.0)), TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(-1, 1, 2, 1, -1, 0)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, -1, 2, 1, -1, 0)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, 1, -2, 1, -1, 0)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, 1, 2, 2, -1, 0)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, 1, 2, 1, -2, 0)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, 1, 2, 1, -1, 3)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, 1, 3, 1, -1, 0)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(1, 4, 2, 1, -1, 0)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_3j_e", "(4, 1, 2, 1, -1, 0)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 4, 2, 2, 2)",  1.0/6.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(4, 4, 2, 4, 4, 4)", -1.0/10.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(4, 4, 2, 4, 4, 2)",  1.0/6.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(4, 4, 2, 2, 2, 2)", -0.5/sqrt(5.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(4, 4, 4, 2, 2, 2)",  sqrt(7.0/3.0)/10.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(6, 6, 6, 4, 4, 4)", -sqrt(3.0/5.0)/14.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(6, 6, 6, 4, 4, 2)", -sqrt(3.0/5.0)/7.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(-2, 2, 4, 2, 2, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, -2, 4, 2, 2, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, -4, 2, 2, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 4, -2, 2, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 4, 2, -2, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 4, 2, 2, -2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 4, 2, 2, 7)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 4, 2, 7, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 4, 7, 2, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 2, 7, 2, 2, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(2, 7, 4, 2, 2, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_6j_e", "(7, 2, 4, 2, 2, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2,  4, 3, 3, 2, 1, 1, 2)", -sqrt(1.0/6.0)/10.0, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(8, 4, 10, 7, 3, 8, 1, 1, 2)",  sqrt(7.0/3.0)/60.0, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(-4, 2, 4, 3, 3, 2, 1, 1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, -2, 4, 3, 3, 2, 1, 1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, -4, 3, 3, 2, 1, 1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, -3, 3, 2, 1, 1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, -3, 2, 1, 1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, -2, 1, 1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, 2, -1, 1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, 2, 1, -1, 2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, 2, 1, 1, -2)", GSL::NAN, GSL::NAN, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(10, 2, 4, 3, 3, 2, 1, 1, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 10, 4, 3, 3, 2, 1, 1, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 10, 3, 3, 2, 1, 1, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 10, 3, 2, 1, 1, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 10, 2, 1, 1, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, 10, 1, 1, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, 2, 10, 1, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, 2, 1, 10, 2)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::coupling_9j_e", "(4, 2, 4, 3, 3, 2, 1, 1, 10)", 0, 0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::dawson_e", "(1.0e-15)", 1.0e-15, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::dawson_e", "(0.5)", 0.4244363835020222959, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::dawson_e", "(2.0)", 0.30134038892379196603, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::dawson_e", "(1000.0)", 0.0005000002500003750009, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_1_e", "(0.1)",  0.975277750004723276, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_1_e", "(1.0)",  0.777504634112248239, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_1_e", "(10.0)", 0.164443465679946027, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_2_e", "(0.1)",  0.967083287045302664,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_2_e", "(1.0)",  0.70787847562782924,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_2_e", "(10.0)", 0.0479714980201218708, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_3_e", "(0.1)",  0.962999940487211048,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_3_e", "(1.0)",  0.674415564077814667,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_3_e", "(10.0)", 0.0192957656903454886, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_4_e", "(0.1)",  0.960555486124335944,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_4_e", "(1.0)",  0.654874068886737049,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::debye_4_e", "(10.0)", 0.00967367556027115896, TEST_TOL0, GSL::SUCCESS)
x = 0
  TEST_SF(s,  "GSL::Sf::multiply_e", "(-3.0,2.0)", -6.0,          TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::multiply_e", "(#{x}, 1.0/#{x})",  1.0,          TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::multiply_e", "(#{x}, 0.2)",    0.04*DBL_MAX, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::multiply_e", "(#{x}, 4.0)",    0.8*DBL_MAX,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_Kcomp_e", "( 0.99, #{mode})", 3.3566005233611923760, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_Kcomp_e", "( 0.50, #{mode})", 1.6857503548125960429, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_Kcomp_e", "(0.010, #{mode})", 1.5708355989121522360, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_Ecomp_e", "(0.99, #{mode})", 1.0284758090288040010, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_Ecomp_e", "(0.50, #{mode})", 1.4674622093394271555, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_Ecomp_e", "(0.01, #{mode})", 1.5707570561503852873, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_F_e", "(M_PI/3.0, 0.99, #{mode})", 1.3065333392738766762, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_F_e", "(M_PI/3.0, 0.50, #{mode})", 1.0895506700518854093, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_F_e", "(M_PI/3.0, 0.01, #{mode})", 1.0472129063770918952, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_E_e", "(M_PI/3.0, 0.99, #{mode})", 0.8704819220377943536, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_E_e", "(M_PI/3.0, 0.50, #{mode})", 1.0075555551444720293, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_E_e", "(M_PI/3.0, 0.01, #{mode})", 1.0471821963889481104, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_P_e", "(M_PI/3.0, 0.99, 0.5, #{mode})", 1.1288726598764099882, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_P_e", "(M_PI/3.0, 0.50, 0.5, #{mode})", 0.9570574331323584890, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_P_e", "(M_PI/3.0, 0.01, 0.5, #{mode})", 0.9228868127118118465, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_RF_e", "(5.0e-11, 1.0e-10, 1.0, #{mode})", 12.36441982979439, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_RF_e", "(1.0, 2.0, 3.0, #{mode})", 0.7269459354689082, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_RD_e", "(5.0e-11, 1.0e-10, 1.0, #{mode})", 34.0932594919337362, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_RD_e", "(1.0, 2.0, 3.0, #{mode})", 0.2904602810289906, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_RC_e", "(1.0, 2.0, #{mode})", 0.7853981633974482, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::ellint_RJ_e", "(2.0, 3.0, 4.0, 5.0, #{mode})", 0.1429757966715675, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(-10.0)", 2.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(-5.0000002)", 1.9999999999984625433, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(-5.0)", 1.9999999999984625402, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(-1.0)", 1.8427007929497148693, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(-0.5)", 1.5204998778130465377, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(1.0)", 0.15729920705028513066, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(3.0)", 0.000022090496998585441373, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(7.0)", 4.183825607779414399e-23, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erfc_e", "(10.0)", 2.0884875837625447570e-45, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(-1.0)", log(1.842700792949714869), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(-0.1)", 0.106576400586522485015, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(-1e-10)",  1.1283791670318505967e-10, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(0.0)", log(1.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(1e-10)", -1.128379167159174551e-10, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(0.001)", -0.0011290158896213548027, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(0.1)", -0.119304973737395598329, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(1.0)", log(0.15729920705028513066), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_erfc_e", "(10.0)", log(2.0884875837625447570e-45), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erf_e", "(-10.0)", -1.0000000000000000000, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erf_e", "(0.5)", 0.5204998778130465377, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erf_e", "(1.0)", 0.8427007929497148693, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erf_e", "(10.0)", 1.0000000000000000000, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erf_Z_e", "(1.0)",  0.24197072451914334980,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::erf_Q_e", "(10.0)", 7.619853024160526066e-24, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(-20.0)", 5.5209483621597631896e-88, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(-10.0)", 7.6945986267064193463e-23, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(-1.0)", 0.28759997093917836123, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "( 0.0)", 0.79788456080286535588, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "( 1.0)", 1.5251352761609812091, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(10.0)", 10.098093233962511963, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(20.0)", 20.049753068527850542, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(30.0)", 30.033259667433677037, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(50.0)", 50.019984031905639809, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(80.0)", 80.012496096798234468, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(150.0)", 150.00666607420571802, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(300.0)", 300.00333325926337415, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(900.0)", 900.00111110836764382, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(1001.0)", 1001.0009989990049990, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hazard_e", "(2000.0)", 2000.0004999997500003, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exp_e", "(-10.0)", exp(-10.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exp_e", "( 10.0)", exp( 10.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_err_e", "(-10.0, TEST_TOL1)", exp(-10.0), TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_err_e", "( 10.0, TEST_TOL1)", exp( 10.0), TEST_TOL1, GSL::SUCCESS)
x = 0
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(-10.0,  1.0e-06)", 1.0e-06*exp(-10.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(-10.0,  2.0)",     2.0*exp(-10.0),     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(-10.0, -2.0)",    -2.0*exp(-10.0),     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "( 10.0,  1.0e-06)", 1.0e-06*exp( 10.0), TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "( 10.0, -2.0)",    -2.0*exp( 10.0),     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(#{x}, 1.00001)",      1.00001*exp(x),     TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(#{x}, 1.000001)",     1.000001*exp(x),    TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(#{x}, 1.000000001)",  1.000000001*exp(x), TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(#{x}, 100.0)",        100.0*exp(x),       TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(#{x}, 1.0e+20)",      1.0e+20*exp(x),     TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_e", "(#{x}, exp(-#{x})*exp(M_LN2))",  2.0, TEST_TOL4, GSL::SUCCESS )
  TEST_SF(s, "GSL::Sf::exp_mult_err_e", "(-10.0, TEST_SQRT_TOL0, 2.0, TEST_SQRT_TOL0)", 2.0*exp(-10.0), TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::exp_mult_err_e", "(#{x}, TEST_SQRT_TOL0*#{x}, exp(-#{x})*exp(M_LN2), TEST_SQRT_TOL0*#{x})",  2.0, TEST_SQRT_TOL0, GSL::SUCCESS )
  TEST_SF(s,  "GSL::Sf::expm1_e", "(-10.0)", exp(-10.0)-1.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expm1_e", "(-0.001)", -0.00099950016662500845, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expm1_e", "(-1.0e-8)", -1.0e-08 + 0.5e-16, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expm1_e", "( 1.0e-8)", 1.0e-08 + 0.5e-16, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expm1_e", "( 0.001)", 0.0010005001667083417, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expm1_e", "( 10.0)", exp(10.0)-1.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_e", "(-10.0)", 0.0999954600070237515, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_e", "(-0.001)", 0.9995001666250084, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_e", "(-1.0e-8)", 1.0 - 0.5e-08, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_e", "( 1.0e-8)", 1.0 + 0.5e-08, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_e", "( 0.001)", 1.0005001667083417, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_e", "( 10.0)", 2202.5465794806716517, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_2_e", "(-10.0)", 0.18000090799859524970, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_2_e", "(-0.001)", 0.9996667499833361107, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_2_e", "(-1.0e-8)", 0.9999999966666666750, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_2_e", "( 1.0e-8)", 1.0000000033333333417, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_2_e", "( 0.001)", 1.0003334166833361115, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_2_e", "( 10.0)", 440.3093158961343303, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3, -1000.0)", 0.00299400600000000000, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3, -100.0)", 0.02940600000000000000, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3, -10.0)", 0.24599972760042142509, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3, -3.0)", 0.5444917625849191238, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3, -0.001)", 0.9997500499916678570, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3, -1.0e-8)", 0.9999999975000000050, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3,  1.0e-8)", 1.0000000025000000050, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3,  0.001)", 1.0002500500083345240, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3,  3.0)", 2.5745637607083706091, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3,  3.1)", 2.6772417068460206247, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3,  10.0)", 131.79279476884029910, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(3,  100.0)", 1.6128702850896812690e+38, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50, -1000.0)", 0.04766231609253975959, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50, -100.0)", 0.3348247572345889317, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50, -10.0)", 0.8356287051853286482, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50, -3.0)", 0.9443881609152163615, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50, -1.0)", 0.980762245565660617, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50, -1.0e-8)", 1.0 -1.0e-8/51.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50,  1.0e-8)", 1.0 +1.0e-8/51.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50,  1.0)", 1.01999216583666790, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50,  3.0)", 1.0624205757460368307, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50,  48.0)", 7.499573876877194416, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50,  50.1)", 9.311803306230992272, TEST_TOL4, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50,  100.0)", 8.175664432485807634e+07, TEST_TOL4, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(50,  500.0)", 4.806352370663185330e+146, TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500, -1000.0)", 0.3334815803127619256, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500, -100.0)", 0.8335646217536183909, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500, -10.0)", 0.9804297803131823066, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500, -3.0)", 0.9940475488850672997, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500, -1.0)", 0.9980079602383488808, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500, -1.0e-8)", 1.0 -1.0e-8/501.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  1.0e-8)", 1.0 +1.0e-8/501.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  1.0)", 1.0019999920160634252, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  3.0)", 1.0060240236632444934, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  48.0)", 1.1059355517981272174, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  100.0)", 1.2492221464878287204, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  500.0)", 28.363019877927630858, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  1000.0)", 2.4037563160335300322e+68, TEST_TOL4, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::exprel_n_e", "(500,  1600.0)", 7.899293535320607403e+226, TEST_TOL4, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(-1.0)", -1.8951178163559367555, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(1.0e-10)", 22.448635265138923980, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(1.0e-05)", 10.935719800043695615, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(0.1)", 1.82292395841939066610, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(1.0)", 0.21938393439552027368, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(10.0)", 4.156968929685324277e-06, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(50.0)", 3.783264029550459019e-24, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_e", "(300.0)", 1.710384276804510115e-133, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(-1.0)", 0.8231640121031084799, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(1.0/4294967296.0)", 0.9999999947372139168, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(1.0/65536.0)", 0.9998243233207178845, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(0.1)", 0.7225450221940205066, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(1.0)", 0.14849550677592204792, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(10.0)", 3.830240465631608762e-06, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(50.0)", 3.711783318868827367e-24, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_e", "(300.0)", 1.7047391998483433998e-133, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_e", "(-1.0)", -0.21938393439552027368, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_e", "(1.0/4294967296.0)", -21.603494112783886397, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_e", "(1.0)", 1.8951178163559367555, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(-10000.0)", -0.00010001000200060024012, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(-1000.0)", -0.0010010020060241207251, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(-10.0)", -0.11314702047341077803, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(-1.0)", -0.69717488323506606877, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(1.0e-10)", 22.448635267383787506, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(1.0e-05)", 10.935829157788483865, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(0.1)", 2.0146425447084516791, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(1.0)", 0.59634736232319407434, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(10.0)", 0.091563333939788081876, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(50.0)", 0.019615109930114870365, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(300.0)", 0.0033222955652707070644, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(1000.0)", 0.00099900199402388071500, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E1_scaled_e", "(10000.0)", 0.000099990001999400239880, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(-10000.0)", -0.00010002000600240120072, TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(-1000.0)", -0.0010020060241207250807, TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(-10.0)", -0.13147020473410778034, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(-1.0)", 0.30282511676493393123, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(1.0/4294967296.0)", 0.99999999497004455927, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(1.0/65536.0)", 0.99983957954556245453, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(0.1)", 0.79853574552915483209, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(1.0)", 0.40365263767680592566, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(10.0)", 0.084366660602119181239, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(50.0)", 0.019244503494256481735, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(300.0)", 0.0033113304187878806691, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(1000.0)", 0.00099800597611928500004, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_E2_scaled_e", "(10000.0)", 0.000099980005997601199281, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_scaled_e", "(-1000.0)", -0.00099900199402388071500, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_scaled_e", "(-1.0)", -0.59634736232319407434, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_scaled_e", "(1.0/4294967296.0)", -21.603494107753930958, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_scaled_e", "(1.0)", 0.69717488323506606877, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_Ei_scaled_e", "(1000.0)", 0.0010010020060241207251, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(-1.0)", -1.0572508753757285146, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(1.0/4294967296.0)", 2.3283064365386962891e-10, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(1.0/65536.0)", 0.00001525878906269737298, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(0.1)", 0.1000555722250569955, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(1.0)", 1.0572508753757285146, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(10.0)", 1246.1144901994233444, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(50.0)", 5.292818448565845482e+19, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Shi_e", "(300.0)", 3.248241254044332895e+127, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(-1.0)", 0.8378669409802082409, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(1.0/4294967296.0)", -21.603494113016717041, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(1.0/65536.0)", -10.513139223999384429, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(1.0/8.0)", -1.4983170827635760646, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(1.0)", 0.8378669409802082409, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(10.0)", 1246.1144860424544147, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(50.0)", 5.292818448565845482e+19, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Chi_e", "(300.0)", 3.248241254044332895e+127, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(1.0e-10)", 1.0e-10, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(1.0e-05)", 9.9999999999999975e-06, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(0.1)", 0.09997500714119079665122, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(0.5)", 0.48491714311363971332427, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(1.0)", 0.80751118213967145285833, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(2.0)", 0.89295351429387631138208, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(5.0)", 0.89297951156924921121856, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(10.0)", 0.89297951156924921121856, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::expint_3_e", "(100.0)", 0.89297951156924921121856, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(-1.0)", -0.9460830703671830149, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(1.0e-10)", 1.0e-10, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(1.0e-05)", 9.999999999944444444e-06, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(0.1)", 0.09994446110827695016, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(1.0)", 0.9460830703671830149, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(10.0)", 1.6583475942188740493, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(50.0)", 1.5516170724859358947, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(300.0)", 1.5708810882137495193, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Si_e", "(1.0e+20)", 1.5707963267948966192, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(1.0/4294967296.0)", -21.603494113016717041, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(1.0/65536.0)", -10.513139224115799751, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(1.0/8.0)", -1.5061295845296396649, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(1.0)", 0.3374039229009681347, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(10.0)", -0.04545643300445537263, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(50.0)", -0.005628386324116305440, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(300.0)", -0.003332199918592111780, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(65536.0)", 0.000010560248837656279453, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(4294967296.0)", -1.0756463261957757485e-10, TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::Ci_e", "(1099511627776.0)", -3.689865584710764214e-13, 1024.0*TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(1.0e-10)", 1.0e-10, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(1.0e-05)", 9.99999999988888888889e-06, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(0.1)", 0.09988928686033618404, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(1.0)", 0.91596559417721901505, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(2.0)", 1.57601540344632342236, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(10.0)", 3.71678149306806859029, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(50.0)", 6.16499047850274874222, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(300.0)", 8.96281388924518959990, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::atanint_e", "(1.0e+5)", 18.084471031038661920, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_m1_e", "(-10.0)", 0.00004539786870243439450, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_m1_e", "( -1.0)", 0.26894142136999512075, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_m1_e", "(  1.0)", 0.7310585786300048793, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_m1_e", "( 10.0)", 0.9999546021312975656, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_0_e", "(-10.0)", 0.00004539889921686464677, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_0_e", "( -1.0)", 0.31326168751822283405, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_0_e", "(  1.0)", 1.3132616875182228340, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_0_e", "( 10.0)", 10.000045398899216865, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "(-10.0)", 0.00004539941448447633524, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "( -2.0)", 0.13101248471442377127, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "( -1.0)", 0.3386479964034521798, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "( -0.4)", 0.5825520806897909028, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "(  0.4)", 1.1423819861584355337, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "(  1.0)", 1.8062860704447742567, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "(  1.5)", 2.5581520872227806402, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "(  2.5)", 4.689474797599761667, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "( 10.0)", 51.64488866743374196, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "( 12.0)", 73.64492792264531092, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "( 20.0)", 201.64493406478707282, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_1_e", "( 50.0)", 1251.6449340668482264, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "(-10.0)", 0.00004539967212174776662, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "( -2.0)", 0.13313272938565030508, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "( -1.0)", 0.3525648792978077590, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "( -0.4)", 0.6229402647001272120, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "(  0.4)", 1.2915805581060844533, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "(  1.0)", 2.1641656128127008622, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "(  1.5)", 3.247184513920792475, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "(  2.5)", 6.797764392735056317, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "( 10.0)", 183.11605273482105278, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "( 12.0)", 307.73921494638635166, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "( 20.0)", 1366.2320146723590157, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "( 50.0)", 20915.580036675744655, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_2_e", "(200.0)", 1.3336623201467029786e+06, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "(-10.0)", 0.00004539847236080549532, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "( -2.0)", 0.12366562180120994266, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "( -1.0)", 0.29402761761145122022, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "( -0.4)", 0.4631755336886027800, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "(  0.4)", 0.7654084737661656915, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "(  1.0)", 1.0270571254743506890, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "(  1.5)", 1.2493233478527122008, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "(  2.5)", 1.6663128834358313625, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "( 10.0)", 3.552779239536617160, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "( 12.0)", 3.897268231925439359, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "( 20.0)", 5.041018507535328603, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_mhalf_e", "( 50.0)", 7.977530858581869960, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "(-10.0)", 0.00004539920105264132755, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "( -2.0)", 0.12929851332007559106, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "( -1.0)", 0.3277951592607115477, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "( -0.4)", 0.5522452153690688947, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "(  0.4)", 1.0386797503389389277, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "(  1.0)", 1.5756407761513002308, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "(  1.5)", 2.1448608775831140360, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "(  2.5)", 3.606975377950373251, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "( 10.0)", 24.084656964637653615, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "( 12.0)", 31.540203287044242593, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "( 20.0)", 67.49151222165892049, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_half_e", "( 50.0)", 266.09281252136259343, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "(-10.0)", 0.00004539956540456176333, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "( -2.0)", 0.13224678225177236685, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "( -1.0)", 0.3466747947990574170, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "( -0.4)", 0.6056120213305040910, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "(  0.4)", 1.2258236403963668282, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "(  1.0)", 2.0022581487784644573, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "(  1.5)", 2.9277494127932173068, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "(  2.5)", 5.768879312210516582, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "( 10.0)", 101.00510084332600020, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "( 12.0)", 156.51518642795728036, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "( 20.0)", 546.5630100657601959, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_3half_e", "( 50.0)", 5332.353566687145552, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(3,  -2.0)", 0.1342199155038680215, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(3,   0.0)", 0.9470328294972459176, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(3,   0.1)", 1.0414170610956165759, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(3,   1.0)", 2.3982260822489407070, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(3,   3.0)", 12.621635313399690724, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(3, 100.0)", 4.174893231066566793e+06, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(3, 500.0)", 2.604372285319088354e+09, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(5,  -2.0)", 0.13505242246823676478, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(5,   0.0)", 0.9855510912974351041, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(5,   0.1)", 1.0876519750101492782, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(5,   1.0)", 2.6222337848692390539, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(5,   3.0)", 17.008801618012113022, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(5, 100.0)", 1.3957522531334869874e+09, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(5, 500.0)", 2.1705672808114817955e+13, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7,  -2.0)", 0.1352641105671255851, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7,   0.0)", 0.9962330018526478992, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7,   0.1)", 1.1005861815180315485, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7,   1.0)", 2.6918878172003129203, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7,   3.0)", 19.033338976999367642, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7,  10.0)", 5654.530932873610014, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7,  50.0)", 1.005005069985066278e+09, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(7, 500.0)", 9.691690268341569514e+16, TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9,  -2.0)", 0.1353174385330242691, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9,   0.0)", 0.9990395075982715656, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9,   0.1)", 1.1039997234712941212, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9,   1.0)", 2.7113648898129249947, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9,   3.0)", 19.768544008138602223, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9,  10.0)", 10388.990167312912478, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9,  50.0)", 2.85466960802601649e+10, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(9, 500.0)", 2.69273849842695876e+20, 2*TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10,  -2.0)", 0.13532635396712288092, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10,   0.0)", 0.9995171434980607541, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10,   0.1)", 1.1045818238852612296, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10,   1.0)", 2.7147765350346120647, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10,   3.0)", 19.917151938411675171, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10,  10.0)", 12790.918595516495955, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10,  50.0)", 1.3147703201869657654e+11, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(10, 500.0)", 1.2241331244469204398e+22, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11,  -2.0)", 0.1353308162894847149, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11,   0.0)", 0.9997576851438581909, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11,   0.1)", 1.1048751811565850418, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11,   1.0)", 2.7165128749007313436, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11,   3.0)", 19.997483022044603065, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11,  10.0)", 14987.996005901818036, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11,  50.0)", 5.558322924078990628e+11, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(11, 500.0)", 5.101293089606198280e+23, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20,  -2.0)", 0.13533527450327238373, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20,   0.0)", 0.9999995232582155428, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20,   0.1)", 1.1051703357941368203, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20,   1.0)", 2.7182783069905721654, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20,   3.0)", 20.085345296028242734, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20,  10.0)", 21898.072920149606475, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20,  50.0)", 1.236873256595717618e+16, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::fermi_dirac_int_e", "(20, 500.0)", 9.358938204369557277e+36, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_1_e", "(-0.2,   1.0)", -0.4, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_1_e", "( 0.0,   1.0)", 2.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_1_e", "( 1.0,   1.0)", 2.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_1_e", "( 1.0,   0.5)", 1.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_1_e", "( 5.0,   1.0)", 10.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_1_e", "( 100.0, 0.5)", 100.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_2_e", "(-0.2,   0.5)", 0.12, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_2_e", "( 0.0,   1.0)", 1.00, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_2_e", "( 1.0,   1.0)", 3.00, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_2_e", "( 1.0,   0.1)", -0.96, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_2_e", "( 5.0,   1.0)", 55.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_2_e", "( 100.0, 0.5)", 4950.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_3_e", "(-0.2,   0.5)", 0.112, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_3_e", "( 0.0,   1.0)", -2.0/3.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_3_e", "( 1.0,   1.0)", 4.000, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_3_e", "( 1.0,   0.1)", -0.392, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_3_e", "( 5.0,   1.0)", 220.000, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_3_e", "( 100.0, 0.5)", 161600.000, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(1,       1.0, 1.0)", 2.000              , TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(10,      1.0, 1.0)", 11.000             , TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(10,      1.0, 0.1)", -0.4542309376      , TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(10,      5.0, 1.0)", 9.23780e+4         , TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(10,    100.0, 0.5)", 1.5729338392690000e+13, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(1000,  100.0, 1.0)", 3.3353666135627322e+232, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(100,  2000.0, 1.0)", 5.8753432034937579e+202, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(103,   207.0, 2.0)", 1.4210272202235983e+145, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::gegenpoly_n_e", "(103,    -0.4, 0.3)", -1.64527498094522e-04, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_1_e", "(0.5, -1.0)", 2.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_1_e", "(0.5,  1.0)", 0.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_1_e", "(1.0,  1.0)", 1.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_2_e", "( 0.5, -1.0)", 4.875,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_2_e", "( 0.5,  1.0)", -0.125, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_2_e", "( 1.0,  1.0)",  0.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_2_e", "(-1.0,  1.0)", -0.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_2_e", "(-2.0,  1.0)",  0.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_2_e", "(-3.0,  1.0)",  2.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_3_e", "(0.5, -1.0)", 8.479166666666666667,    TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_3_e", "(0.5,  1.0)", -0.6041666666666666667,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_3_e", "(1.0,  1.0)", -0.16666666666666666667, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_3_e", "( 2.0,  1.0)", 2.3333333333333333333,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_3_e", "(-2.0,  1.0)", 1.0/3.0,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_3_e", "(-3.0,  1.0)", -1.0/6.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_3_e", "(-4.0,  1.0)", -8.0/3.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(1, 0.5, 1.0)", 0.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(2, 1.0, 1.0)", 0.5, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(3, 2.0, 1.0)", 2.3333333333333333333,   TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(4, 2.0, 0.5)", 6.752604166666666667,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(90, 2.0,  0.5)", -48.79047157201507897, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(90, 2.0, -100.0)", 2.5295879275042410902e+63, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(90, 2.0,  100.0)", -2.0929042259546928670e+20, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, 2.0, -0.5)", 2.2521795545919391405e+07,  TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, 2.0,  0.5)", -28.764832945909097418,     TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(1000, 2.0, -0.5)", 2.4399915170947549589e+21, TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100000, 2.0, 1.0)", 5107.73491348319,         TEST_TOL4, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(1, -2.0, 1.0)",  -2.0,     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(2, -2.0, 1.0)",   0.5,     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(3, -2.0, 1.0)",   1.0/3.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(10, -2.0, 1.0)", -0.04654954805996472663,   TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(10, -5.0, 1.0)", -0.0031385030864197530864, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(10, -9.0, 1.0)", -2.480158730158730159e-06, TEST_TOL5, GSL::SUCCESS)  
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(10, -11.0,  1.0)", 2.7182818011463844797,    TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(10, -11.0, -1.0)", 0.3678794642857142857,    TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -2.0,  1.0)",  -0.0027339992019526273866,  TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -2.0, -1.0)",   229923.09193402028290,     TEST_TOL5, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -10.0,  1.0)",  3.25966665871244092e-11,   TEST_TOL6, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -10.0, -1.0)",  0.00016484365618205810025, TEST_TOL6, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -20.0, 1.0)",  5.09567630343671251e-21,  TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -30.0, 1.0)",  3.46063150272466192e-34,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -50.0,  1.0)",  1.20981872933162889e-65,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -50.0, -1.0)",  8.60763477742332922e-65,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -50.5,  1.0)",  4.84021010426688393e-31,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -50.5, -1.0)",  8.49861345212160618e-33,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -101.0,  1.0)", 2.7182818284590452354,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -101.0, -1.0)", 0.3678794411714423216,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -102.0,  1.0)", 271.8281828459045235,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -102.0, -1.0)", 37.52370299948711680,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -110.0,  1.0)", 1.0666955248998831554e+13, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -110.0, -1.0)", 1.7028306108058225871e+12, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -200.0,  1.0)", 7.47851889721356628e+58,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -200.0, -1.0)", 2.73740299754732273e+58,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -50.0,  10.0)", 4.504712811317745591e-21,  TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::laguerre_n_e", "(100, -50.0, -10.0)", 1.475165520610679937e-11,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(0.0)",  0.0,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(1.0)",  0.567143290409783872999969,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(2.0)",  0.852605502013725491346472,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(20.0)", 2.205003278024059970493066,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(1000.0)", 5.24960285240159622712606,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(1.0e+6)", 11.38335808614005262200016,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(1.0e+12)", 24.43500440493491313826305,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(1.0e+308)", 702.641362034106812081125,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(-1.0/M_E - GSL::DBL_EPSILON)", -1.0,  TEST_TOL0, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(-1.0/M_E + 1.0/(1024.0*1024.0*1024.0))", -0.999928845560308370714970, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(-1.0/M_E + 1.0/(1024.0*1024.0))", -0.997724730359774141620354, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(-1.0/M_E + 1.0/512.0)", -0.900335676696088773044678, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_W0_e", "(-1.0/M_E + 0.25)", -0.1349044682661213545487599, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(0.0)",  0.0,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(1.0)",  0.567143290409783872999969,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(2.0)",  0.852605502013725491346472,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(20.0)", 2.205003278024059970493066,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(-1.0/M_E - GSL::DBL_EPSILON)", -1.0,  TEST_TOL0, GSL::EDOM)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(-1.0/M_E + 1.0/(1024.0*1024.0*1024.0))", -1.000071157815154608049055, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(-1.0/M_E + 1.0/(1024.0*1024.0))", -1.002278726118593023934693, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(-1.0/M_E + 1.0/512.0)", -1.106761200865743124599130, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(-1.0/M_E + 1.0/64.0)", -1.324240940341812125489772, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::lambert_Wm1_e", "(-1.0/M_E + 0.25)", -3.345798131120112, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_e", "(0.1)", -2.3025850929940456840,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_e", "(1.1)", 0.09531017980432486004,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_e", "(1000.0)", 6.907755278982137052, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_abs_e", "(-0.1)", -2.3025850929940456840,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_abs_e", "(-1.1)", 0.09531017980432486004,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_abs_e", "(-1000.0)", 6.907755278982137052, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_abs_e", "(0.1)", -2.3025850929940456840,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_abs_e", "(1.1)", 0.09531017980432486004,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::log_abs_e", "(1000.0)", 6.907755278982137052, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(1.0e-10)", 9.999999999500000000e-11, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(1.0e-8)", 9.999999950000000333e-09, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(1.0e-4)", 0.00009999500033330833533, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(0.1)", 0.09531017980432486004, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(0.49)", 0.3987761199573677730, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(-0.49)", -0.6733445532637655964, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(1.0)", M_LN2, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_e", "(-0.99)", -4.605170185988091368, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(1.0e-10)", -4.999999999666666667e-21, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(1.0e-8)", -4.999999966666666917e-17, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(1.0e-4)", -4.999666691664666833e-09, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(0.1)", -0.004689820195675139956, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(0.49)", -0.09122388004263222704, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(-0.49)", -0.18334455326376559639, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(1.0)", M_LN2-1.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::log_1plusx_mx_e", "(-0.99)", -3.615170185988091368, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(2.0, 3)", 8.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-2.0, 3)", -8.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(2.0, -3)", 1.0/8.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-2.0, -3)", -1.0/8.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(10.0, 4)", 1.0e+4, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(10.0, -4)", 1.0e-4, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-10.0, 4)", 1.0e+4, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-10.0, -4)", 1.0e-4, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(10.0, 40)", 1.0e+40, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(8.0, -40)", 7.523163845262640051e-37, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-10.0, 40)", 1.0e+40, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-8.0, -40)", 7.523163845262640051e-37, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(10.0, 41)", 1.0e+41, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(8.0, -41)", 9.403954806578300064e-38, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-10.0, 41)", -1.0e+41, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::pow_int_e", "(-8.0, -41)", -9.403954806578300064e-38, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_int_e", "(1)", -0.57721566490153286060, TEST_TOL0, GSL::SUCCESS)  
  TEST_SF(s, "GSL::Sf::psi_int_e", "(2)", 0.42278433509846713939, TEST_TOL0, GSL::SUCCESS)  
  TEST_SF(s, "GSL::Sf::psi_int_e", "(3)", 0.92278433509846713939, TEST_TOL0, GSL::SUCCESS)  
  TEST_SF(s, "GSL::Sf::psi_int_e", "(4)", 1.2561176684318004727, TEST_TOL0, GSL::SUCCESS)  
  TEST_SF(s, "GSL::Sf::psi_int_e", "(5)", 1.5061176684318004727, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_int_e", "(100)", 4.600161852738087400, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_int_e", "(110)", 4.695928024251535633, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_int_e", "(5000)", 8.517093188082904107, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_e", "(5000.0)", 8.517093188082904107, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_e", "(5.0)", 1.5061176684318004727, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_e", "(-10.5)",       2.3982391295357816134,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_e", "(-100.5)",      4.615124601338064117,  TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_e", "(-1.0e+5-0.5)", 11.512935464924395337, 4.0*TEST_TOL4, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_e", "(-262144.0-0.5)", 12.476653064769611581, 4.0*TEST_TOL4, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(0.8)", -0.07088340212750589223, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(1.0)",  0.09465032062247697727, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(5.0)",  1.6127848446157465854, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(100.0)",  4.605178519404762003, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(2000.0)", 7.600902480375416216, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(-0.8)", -0.07088340212750589223, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(-1.0)",  0.09465032062247697727, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(-5.0)",  1.6127848446157465854, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(-100.0)",  4.605178519404762003, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1piy_e", "(-2000.0)", 7.600902480375416216, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(1)", 1.6449340668482264364,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(2)", 0.64493406684822643647, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(3)", 0.39493406684822643647, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(4)", 0.28382295573711532536, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(1)", 1.6449340668482264365,      TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(5)", 0.22132295573711532536,     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(100)", 0.010050166663333571395,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(110)", 0.009132356622022545705,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_int_e", "(500)", 0.0020020013333322666697, TEST_TOL0, GSL::SUCCESS)
if RB_GSL_VERSION >= "1.5"
  TEST_SF(s, "GSL::Sf::psi_1_e", "(1.0/32.0)", 1025.5728544782377089,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(1.0)", 1.6449340668482264365,       TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(5.0)", 0.22132295573711532536,      TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(100.0)", 0.010050166663333571395,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(110.0)", 0.009132356622022545705,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(500.0)", 0.0020020013333322666697,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(-1.0 - 1.0/128.0)", 16386.648472598746587, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(-1.50)", 9.3792466449891237539, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(-10.5)", 9.7787577398148123845, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(-15.5)", 9.8071247184113896201, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(-50.5)", 9.8499971860824842274, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_1_e", "(-1000.5)", 9.8686054001734414233, TEST_TOL0, GSL::SUCCESS)
end
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 1)", 1.6449340668482264364,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 2)", 0.64493406684822643647,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 3)", 0.39493406684822643647,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 4)", 0.28382295573711532536,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 5)", 0.22132295573711532536,     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 100)", 0.010050166663333571395,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 110)", 0.009132356622022545705,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, 500)", 0.0020020013333322666697, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(3, 5.0)", 0.021427828192755075022,     TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(3, 500.0)", 1.6048063999872000683e-08, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(10, 5.0)", -0.08675107579196581317,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(10, 50.0)", -4.101091112731268288e-12, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(0, -1.5)", 0.70315664064524318723,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::psi_n_e", "(1, -1.5)", 9.3792466449891237539,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::synchrotron_1_e", "(0.01)",  0.444972504114210632,    TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::synchrotron_1_e", "(1.0)",   0.651422815355364504,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::synchrotron_1_e", "(10.0)",  0.000192238264300868882, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::synchrotron_1_e", "(100.0)", 4.69759366592220221e-43, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::synchrotron_2_e", "(0.01)",  0.23098077342226277732, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::synchrotron_2_e", "(1.0)",   0.4944750621042082670,  TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::synchrotron_2_e", "(10.0)",  0.00018161187569530204281,  TEST_TOL1, GSL::SUCCESS)  
  TEST_SF(s, "GSL::Sf::transport_2_e", "(1.0e-10)", 9.9999999999999999999e-11, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_2_e", "(1.0)",     0.97303256135517012845, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_2_e", "(3.0)",     2.41105004901695346199, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_2_e", "(10.0)",    3.28432911449795173575, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_2_e", "(100.0)",   3.28986813369645287294, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_2_e", "(1.0e+05)", 3.28986813369645287294, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(1.0e-10)", 4.999999999999999999997e-21, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(1.0)",     0.479841006572417499939, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(3.0)",     3.210604662942246772338, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(5.0)",     5.614386613842273228585, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(10.0)",    7.150322712008592975030, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(30.0)",    7.212341416160946511930, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(100.0)",   7.212341418957565712398, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_3_e", "(1.0e+05)", 7.212341418957565712398, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(1.0e-10)", 3.33333333333333333333e-31, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(1.0e-07)", 3.33333333333333166666e-22, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(1.0e-04)", 3.33333333166666666726e-13, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(0.1)", 0.000333166726172109903824, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(1.0)", 0.31724404523442648241, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(3.0)", 5.96482239737147652446, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(5.0)", 15.3597843168821829816, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(10.0)", 25.2736676770304417334, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(30.0)", 25.9757575220840937469, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(100.0)", 25.9757576090673165963, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_4_e", "(1.0e+05)", 25.9757576090673165963, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(1.0e-10)", 2.49999999999999999999e-41, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(1.0e-07)", 2.49999999999999861111e-29, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(1.0e-04)", 2.49999999861111111163e-17, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(0.1)", 0.000024986116317791487410, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(1.0)", 0.236615879239094789259153, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(3.0)", 12.77055769104415951115760, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(5.0)", 50.26309221817518778543615, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(10.0)", 116.3807454024207107698556, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(30.0)", 124.4313279083858954839911, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(100.0)", 124.4313306172043911597639, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::transport_5_e", "(1.0e+05)", 124.43133061720439115976, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(-10.0)",       0.5440211108893698134,    TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(1.0)",         0.8414709848078965067,    TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(1000.0)",      0.8268795405320025603,    TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(1048576.75)",  0.8851545351115651914,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(62831853.75)", 0.6273955953485000827,    TEST_TOL3, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(1073741822.5)", -0.8284043541754465988,  TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(1073741824.0)", -0.6173264150460421708,  TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(1073741825.5)",  0.7410684679436226926,  TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sin_e", "(1099511627776.0)", -0.4057050115328287198, 32.0*TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(-10.0)",      -0.8390715290764524523,    TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(1.0)",         0.5403023058681397174,    TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(1000.0)",      0.5623790762907029911,    TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(1048576.75)",  0.4652971620066351799,    TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(62831853.75)", 0.7787006914966116436,    TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(1073741822.5)",   -0.5601305436977716102,  TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(1073741824.0)",    0.7867071229411881196,  TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::cos_e", "(1099511627776.0)", -0.9140040719915570023, 128.0*TEST_SQRT_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sinc_e", "(1.0/1024.0)", 0.9999984312693665404, TEST_TOL0, GSL::SUCCESS)  
  TEST_SF(s, "GSL::Sf::sinc_e", "(1.0/2.0)", 2.0/M_PI,              TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sinc_e", "(80.5)", 0.0039541600768172754, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sinc_e", "(100.5)", 0.0031672625490924445, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::sinc_e", "(1.0e+06 + 0.5)", 3.18309727028927157e-07, TEST_TOL0, GSL::SUCCESS)
#  TEST_SF(s, "GSL::Sf::sin_pi_x_e", "(1000.5)", 1.0, TEST_TOL0, GSL::SUCCESS)
#  TEST_SF(s, "GSL::Sf::sin_pi_x_e", "(10000.0 + 1.0/65536.0)", 0.00004793689960306688455, TEST_TOL0, GSL::SUCCESS)
#  TEST_SF(s, "GSL::Sf::sin_pi_x_e", "(1099511627776.0 + 1 + 0.125)", -0.3826834323650897717, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lnsinh_e", "(0.1)",  -2.3009189815304652235,  TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lnsinh_e", "(1.0)",   0.16143936157119563361, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lnsinh_e", "(5.0)",   4.306807418479684201,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lnsinh_e", "(100.0)", 99.30685281944005469,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lncosh_e", "(0.125)", 0.007792239318898252791, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lncosh_e", "(1.0)",   0.4337808304830271870,   TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lncosh_e", "(5.0)",   4.306898218339271555, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s,  "GSL::Sf::lncosh_e", "(100.0)", 99.30685281944005469, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_int_e", "(-61.0)", -3.30660898765775767257e+34, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_int_e", "(-5.0)",  -0.003968253968253968253968, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_int_e", "( 5.0)", 1.0369277551433699263313655, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_int_e", "(31.0)", 1.0000000004656629065033784, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_int_e", "(-61.0)", -3.30660898765775767257e+34, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_int_e", "(-5.0)",  -1.003968253968253968253968, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_int_e", "( 5.0)", 0.0369277551433699263313655, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_int_e", "(31.0)", 0.0000000004656629065033784, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(-151)", 8.195215221831378294e+143, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(-51)", 9.68995788746359406565e+24, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(-5)", -0.003968253968253968253968, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(-0.5)", -0.207886224977354566017307, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(-1e-10)", -0.49999999990810614668948, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(0.0)",    -0.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(1e-10)",  -0.50000000009189385333058, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(0.5)", -1.460354508809586812889499, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(1.0-1.0/1024.0)", -1023.4228554489429787, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(1.0+1.0/1048576)", 1.0485765772157343441e+06, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(5.0)", 1.036927755143369926331365, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zeta_e", "(25.5)", 1.000000021074106110269959, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(0.5)", -2.460354508809586812889499, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(2.0)",  0.64493406684822643647,     TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(3.0)",  0.20205690315959428540,     TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(5.0)",  0.0369277551433699263314,   TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(9.5)",  0.0014125906121736622712,   TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(10.5)", 0.000700842641736155219500, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(12.5)", 0.000173751733643178193390, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(13.5)", 0.000086686727462338155188, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(15.5)", 0.000021619904246069108133, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(16.5)", 0.000010803124900178547671, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::zetam1_e", "(25.5)", 0.000000021074106110269959, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(2,  1.0)",  1.6449340668482264365, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(2, 10.0)",  0.1051663356816857461, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(5,  1.0)",  1.0369277551433699263, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(5, 10.0)",  0.000030413798676470276, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(9,  0.1)",  1.0000000004253980e+09, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(30, 0.5)",  1.0737418240000053e+09, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(30, 0.9)",  2.3589824880264765e+01, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::hzeta_e", "(75, 0.25)", 1.4272476927059599e+45, TEST_TOL1, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "(-91)", -4.945598888750002040e+94, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "(-51)", -4.363969073121683116e+40, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "(-5)", 0.25, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "(-1)", 0.25, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "( 0)", 0.5, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "( 5)", 0.9721197704469093059, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "( 6)", 0.9855510912974351041, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "( 20)", 0.9999990466115815221, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_int_e", "( 1000)", 1.0, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "(-51.5)", -1.2524184036924703656e+41, TEST_TOL2, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "(-5)", 0.25, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "(0.5)", 0.6048986434216303702, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "(0.999)", 0.6929872789683383574, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "(1.0)", 0.6931471805599453094, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "(1.0+1.0e-10)", 0.6931471805759321998, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "( 5)", 0.9721197704469093059, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "( 5.2)", 0.9755278712546684682, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "( 6)", 0.9855510912974351041, TEST_TOL0, GSL::SUCCESS)
  TEST_SF(s, "GSL::Sf::eta_e", "( 20)", 0.9999990466115815221, TEST_TOL0, GSL::SUCCESS)
