/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick
 *           Jos Miguel Ronquillo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#ifndef __GTRANS_IFASE_CONN_H__
#define __GTRANS_IFASE_CONN_H__

#include <glib.h>
#include "gtrans_ifase_result.h"


typedef struct __GTransIFaseConn GTransIFaseConn;
struct __GTransIFaseConn {

	/* Algunos datos de la conexion */
	gchar     *db;
	gchar     *host;
	gchar     *pwd;
	gchar     *user;
	gchar     *port;

	/* Connection */
	gpointer  conn;	
	

        /* La que conecta */
	GTransIFaseConn   *(* Connect)(gchar *, gchar *, gchar *, gchar *, gchar *);


        /* La que ejecuta */
        GTransIFaseResult    *(* Exec)(GTransIFaseConn *, gchar *);

	/* Status */
        void                  (* Disconnect)(GTransIFaseConn *);

        /* Status */
        gint                  (* Status)(GTransIFaseConn *);

        /* El mensaje de error */
        gchar                *(* ErrorMsg)(GTransIFaseConn *);

        /* Lista las tablas */
        GTransIFaseResult    *(* ListTables)(GTransIFaseConn *);

        /* Lista las dbs */
        GTransIFaseResult    *(* ListDb)(GTransIFaseConn *);


	/* Cosas para el table designer */
	/* Lista tipos */
        GList                *(* TableDesignerAttrNames)(void);
	
        /* Lista tipos */
        GList                *(* TableDesignerAttrVals)(void);
	
	GList                *(* TableDesignerFieldTypes)(void);
	
	GList                *(* TableDesignerTypeMasks)(void);
	
	gchar                *(* TableDesignerCreateTable)(GTransIFaseConn *,
							   gchar *,
	                                                   GList *);
}; 





/*
 * gtrans_ifase_conn_alloc
 * Alloc a new GTransIFaseConn *, and set everything to defaults.
 */
GTransIFaseConn *
gtrans_ifase_conn_alloc();



/*
 * gtrans_ifase_conn_set_conn
 * @type : GTransIFaseConn type, see gtrans_ifase_conn.h
 * @db, @host, @user, @pwd, @port : connection options
 * Connect to a database backend.
 */
GTransIFaseConn *
gtrans_ifase_conn_start_conn(gchar   *host,
			     gchar   *port,
			     gchar   *db,
			     gchar   *user,
			     gchar   *pwd);


/*
 * gtrans_ifase_conn_finish_conn
 * @conn  : A GTransIFaseConn
 * finish the connection.
 */
void
gtrans_ifase_conn_finish_conn(GTransIFaseConn *conn);



/*
 * gtrans_ifase_conn_status
 * @conn : GTransIFaseConn to a database backend.
 *
 * Check the status of the connection.
 */
gint
gtrans_ifase_conn_status(GTransIFaseConn *conn);




/*
 * gtrans_ifase_conn_error_msg
 * @conn : GTRansIFaseConn to a db backend.
 *
 * return the error message of the connection.
 */
gchar *
gtrans_ifase_conn_error_msg(GTransIFaseConn *conn);



#endif /* __GTRANS_IFASE_CONN_H__ */
