/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick
 *           Jos Miguel Ronquillo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#include <glib.h>
#include "gtrans_ifase_conn.h"
#include "gtrans_ifase_result.h"


/*
 * gtrans_ifase_exec
 * @conn  : connection to a database backend.
 * @qstr  : SQL query string.
 * Execute a SQL query in the database backend.
 */
GTransIFaseResult *
gtrans_ifase_exec(GTransIFaseConn *conn,
		  gchar           *qstr)
{
	g_return_val_if_fail(conn != NULL,NULL);

	return conn->Exec (conn, qstr);
}





/*
 * gtrans_ifase_exec_list_dbs
 * @conn  : connection to a database backend.
 * @qstr  : SQL query string.
 * Execute a SQL query in the database backend.
 */
GTransIFaseResult *
gtrans_ifase_exec_list_dbs(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,NULL);
	
	return conn->ListDb (conn);	
}




/*
 * gtrans_ifase_exec_list_tables
 * @conn  : connection to a database backend.
 * @qstr  : SQL query string.
 * Execute a SQL query in the database backend.
 */
GTransIFaseResult *
gtrans_ifase_exec_list_tables(GTransIFaseConn *conn)
{
	g_return_val_if_fail(conn != NULL,NULL);
	
	return conn->ListTables (conn);	
}




/*
 * gtrans_ifase_exec_table_select_all
 * @conn  : connection to a database backend.
 * @qstr  : SQL query string.
 * Execute a SQL query in the database backend.
 */
GTransIFaseResult *
gtrans_ifase_exec_table_select_all(GTransIFaseConn *conn,
				   gchar           *table)
{
	GTransIFaseResult *res;
	gchar             *qstr;

	g_return_val_if_fail(conn != NULL,NULL);
	
	qstr = g_strconcat("SELECT * FROM ",table,NULL);
	res = gtrans_ifase_exec(conn, qstr);
	
	g_free(qstr);
	
	return res;
}





/*
 * gtrans_ifase_exec_drop_table
 * @conn  : connection to a database backend
 * @table : Name of a table
 *
 * Drop the @table from the database.
 */
GTransIFaseResult *
gtrans_ifase_exec_drop_table(GTransIFaseConn *conn,
			     gchar           *table)
{
	GTransIFaseResult *res;
	gchar             *qstr;

	g_return_val_if_fail(conn != NULL,NULL);
	
	qstr = g_strconcat("DROP TABLE ",table,NULL);
	res = gtrans_ifase_exec(conn, qstr);
	
	g_free(qstr);
	
	return res;
}






