/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation 
 * Authors : Jos Miguel Ronquillo
 *           Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



#include <glib.h>
#include <gmodule.h>
#include <stddef.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include "gtrans_ifase_plugin.h"



/**
 * gtrans_ifase_plugin_search:
 * @list  : A GList containing GTransIFasePlugin's
 * @src   : A GTransIFasePlugin
 *
 * Checks (by plugin name @src->name) if the plugin is found
 * on the list.
 * Returns TRUE if it is, FLASE otherwise.
 */
static gboolean
gtrans_ifase_plugin_search(GList             *list,
			   GTransIFasePlugin *src)
{
	GTransIFasePlugin *tgt;
	GList             *tmp;
	
	g_return_val_if_fail(src != NULL,FALSE);
	
	if (!list)
		return FALSE;
	
	for (tmp = list ; tmp != NULL ; tmp = tmp->next){
		
		tgt = (GTransIFasePlugin *) tmp->data;
		if (!g_strcasecmp(tgt->name,src->name))
			return TRUE;
	}
	return FALSE;
}




/**
 * gtrans_ifase_plugin_open:
 * @modulefile : Absolute path-name of the module to open
 *
 * Opens @module file and creates the corresponding GTransIFasePlugin.
 * Returns : A GTransIFasePlugin with the symbols read from @modulefile,
 *           or NULL if it's not a valid GTransIFasePlugin.
 */
GTransIFasePlugin *
gtrans_ifase_plugin_open(gchar *modulefile)
{
	GTransIFasePlugin *ifase_plugin;
	GModule           *module;
	gchar             *(*pName) (void);
	gboolean           found_name, found_connect;

	ifase_plugin = g_new0(GTransIFasePlugin,1);
	
	if ((module = g_module_open(modulefile, 0)) == NULL)
		return NULL;
	
	found_name    = g_module_symbol(module,"Name",(gpointer *) &pName);
	found_connect = g_module_symbol(module,"Connect",(gpointer *)&(ifase_plugin->connect));
	
	if (!found_name || !found_connect){
		g_module_close(module);
		g_free(ifase_plugin);
		return NULL;
	}
	
	ifase_plugin->name     = pName();
	ifase_plugin->plugin   = module;
	ifase_plugin->filename = g_strdup(modulefile);
	
	return ifase_plugin;
}





/**
 * gtrans_ifase_plugin_list:
 * @dirname : the directory name to sarch for plugins.
 *
 * Returns a GList of the valid (but not repited) GTransIFasePlugin's
 * foun in @dirname.
 */
GList *
gtrans_ifase_plugin_list(gchar *dirname)
{
	GList             *plist = NULL;
	GTransIFasePlugin *plugin;
	DIR               *dir;
	struct dirent     *direntry;
	gchar             *modulefile;
	
	g_return_val_if_fail(dirname,NULL);
	
	if ( !(dir = opendir (dirname)) ) 
		return NULL;

	while ((direntry = readdir(dir))){
		
		if ((g_strcasecmp(direntry->d_name, ".") && 
		     g_strcasecmp(direntry->d_name, ".."))){
			
			modulefile = g_strconcat(dirname,"/",direntry->d_name,NULL);
			plugin = gtrans_ifase_plugin_open(modulefile);
			g_free(modulefile);
			
			if(plugin)
				if(!gtrans_ifase_plugin_search(plist,plugin))
					plist = g_list_append(plist,plugin);
		}
	}
	closedir (dir);
	
	return plist;	
}



