/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ConditionEvaluator.java,v 1.1 2005/05/29 00:14:56 pietschy Exp $
 */
package org.pietschy.command;

/**
 * @author andrewp
 * @version $Revision: 1.1 $
 * @see DefaultConditionEvaluator
 */
public interface
ConditionEvaluator
{
   /**
    * Evaluates the specified condition.  The expressoin syntax is undefined and must be defined
    * by each individual implementation.
    *
    * @param expression the conditional expression as a string.
    * @return <tt>true</tt> if the expression evaluates to <tt>true</tt>, <tt>false</tt> otherwise.
    * @see DefaultConditionEvaluator
    */
   public boolean
   evaluate(String expression)
   throws EvaluationException;
}
