package org.pietschy.command.delegate;

import java.awt.*;

/**
 * This interface allows the {@link DelegateManager} to determine which windows should be
 * considered for command container discovery during focus events.
 *
 * @see DelegateManager#setRelatedWindowDiscriminator(RelatedWindowDiscriminator).
 */
public interface RelatedWindowDiscriminator
{
   /**
    * Check if the the other window is a child or is related to the parent.
    *
    * @param parent the window to which the {@link DelegatingCommand} is bound.
    * @param other  the window that is the ancestor of the currently focused component.
    * @return <code>true</code> if the other window is related to the parent and should be checked
    *         for {@link DelegateContainer}s, <code>false</code> otherwise.
    */
   public boolean isRelated(Window parent, Window other);
}
