/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ToggleDemoPanel.java,v 1.12 2005/06/15 23:43:05 pietschy Exp $
 */

package org.pietschy.command.demo.toggle;

import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.*;
import org.pietschy.command.demo.AbstractDemoPanel;
import org.pietschy.explicit.TableBuilder;

import javax.swing.*;
import java.awt.*;
import java.io.IOException;

public class
ToggleDemoPanel
extends AbstractDemoPanel
{
   static final String _ID_ = "$Id: ToggleDemoPanel.java,v 1.12 2005/06/15 23:43:05 pietschy Exp $";

   private CommandGroup[] menus;

   public ToggleDemoPanel()
   {
      super("Toggle Examples", "toggle-page.selector", "toggle-commands.xml");
   }


   public void
   loadBlurb(HTMLPane html)
   {
      try
      {
         html.setPage(getClass().getResource("toggle.html"));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load toggle file", e);
      }
   }

   public JComponent
   createExamplePanel()
   {
      DefaultToolbarFactory factory = new DefaultToolbarFactory(new Insets(2, 5, 2, 5),
                                                                false,
                                                                false);

      CommandManager cm = CommandManager.defaultInstance();
      menus = new CommandGroup[] {cm.getGroup("toggle-page.menu")};

      SimpleToggle boldToggle = new SimpleToggle("toggle-page.toggle-bold");
      new SimpleToggle("toggle-page.toggle-italic");
      new SimpleToggle("toggle-page.toggle-underline");

      SimpleToggle left = new SimpleToggle("toggle-page.toggle-left");
      left.setSelected(true);
      new SimpleToggle("toggle-page.toggle-right");
      new SimpleToggle("toggle-page.toggle-centre");
      new SimpleToggle("toggle-page.toggle-justify");


      new QueryToggle("toggle-page.toggle-smile");
      new SimpleToggle("toggle-page.toggle-wink");

      TableBuilder builder = new TableBuilder();
      builder.rows().defaultPaddingTop(builder.layoutStyle().unrelatedRowGap());
      builder.row(0).paddingTop(0);
      int row = 0;

      CommandGroup g = cm.getGroup("toggle-page.style-group");
      JToolBar toolBar = g.createToolBar(factory);

      builder.addXY(toolBar, 1, row);
      builder.addXY(createTextArea("A standard group of ToggleCommands. Each command operates independently of the others"), 0, row++)
      .fillX().fillY()
      .minimumWidth(0);

      g = cm.getGroup("toggle-page.align-group");
      toolBar = g.createToolBar(factory);

      builder.addXY(toolBar, 1, row);
      builder.addXY(createTextArea("An exclusive group of four ToggleCommands."), 0, row++)
      .fillX().fillY()
      .minimumWidth(0);


      g = cm.getGroup("toggle-page.allow-empty-group");
      toolBar = g.createToolBar(factory);

      builder.addXY(toolBar, 1, row);
      builder.addXY(createTextArea("An exclusive group of two ToggleCommands that allows empty selection.  The smile command will prompt for confirmation"), 0, row++)
      .fillX().fillY()
      .minimumWidth(0);

      AbstractButton checkBox = boldToggle.createCheckBox();
      checkBox.setOpaque(false);
      builder.addXY(checkBox, 1, row);
      builder.addXY(createTextArea("The bold toggle as a checkbox"), 0, row++)
      .fillX().fillY()
      .minimumWidth(0);

      builder.firstColumn().grow(1.0);
      builder.firstColumn().paddingLeft(0);
      builder.margin(builder.layoutStyle().tabbedDialogMargin());
      builder.buildLayout();

      JPanel panel = builder.getPanel();
      panel.setBackground(Color.WHITE);
      return new JScrollPane(panel);
   }

   public CommandGroup[]
   getMenuGroups()
   {
      return menus;
   }

   public CommandGroup
   getToolbarGroup()
   {
      return menus[0];
   }

   private class QueryToggle
   extends ToggleCommand
   {

      public QueryToggle(String commandId)
      {
         super(commandId);
         export();
      }

      protected void
      handleSelection(boolean selected)
      throws ToggleVetoException
      {
         if (selected)
         {
            int result = JOptionPane.showConfirmDialog(getInvokerWindow(),
                                                       "Are you sure you want to select " +
                                                       getDefaultFace().getText() + "?",
                                                       "Please Confirm",
                                                       JOptionPane.YES_NO_OPTION);

            if (result != JOptionPane.YES_OPTION)
               throw new ToggleVetoException();
         }
      }
   }
}
