#ifndef ISO2MB_CN_H

#define ISO2MB_CN_H

#include "mb.h"

#define MB_BIG5L_FC (mb_BIG5_FCs & ((1 << 7) - 1))
#define MB_BIG5R_FC ((mb_BIG5_FCs >> 7) & ((1 << 7) - 1))

#define MB_EUCTWB_FC (mb_EUCTW_FCs & ((1 << 7) - 1))
#define MB_EUCTWE_FC ((mb_EUCTW_FCs >> 7) & ((1 << 7) - 1))

enum {
  mb_cs_detect_cn_EUC,
  mb_cs_detect_cn_BIG5,
  mb_cs_detect_cn_UTF8,
  mb_cs_detect_cn_EUCTW,
  mb_cs_detect_cn_N,
};

extern void mb_conv_big5_to_cns(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_iso2022cn(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_euc_tw(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_cn_gb(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_cn_gb_isoir165(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_cn_big5(mb_char_t *ch, mb_info_t *info);
extern void mb_cs_judge_gb2312(mb_cs_detector_stat_t *p, const char *bat, size_t e);
extern void mb_cs_judge_big5(mb_cs_detector_stat_t *p, const char *bat, size_t e);
extern void mb_cs_judge_euc_tw(mb_cs_detector_stat_t *p, const char *bat, size_t e);
extern size_t mb_cs_judge_cn(mb_cs_detector_t *p);
extern char *mb_cs_setup_cn(mb_cs_detector_t *p, size_t i, size_t same);

#ifdef USE_UCS

#include "ucs.h"

extern void mb_conv_ucs_to_big5(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_ucs_to_cn(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_ucs_to_gb(mb_char_t *ch, mb_info_t *info);
extern void mb_conv_ucs_to_gb_isoir165(mb_char_t *ch, mb_info_t *info);

#endif

#endif
