package org.jboss.cache.lock;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

/**
 * Implements most of the methods of Lock using the {@link Semaphore} implementation.
 */
public class SemaphoreLock extends Semaphore implements Lock
{

   /**
    * It's unclear why this class would be serialized. 
    */
   private static final long serialVersionUID = -15293253129957476L;

   public SemaphoreLock(int permits)
   {
      super(permits);
   }

   public void lock()
   {
      try
      {
         acquire();
      }
      catch (InterruptedException e)
      {
         lock(); // recursive, I know ..
      }
   }

   public void lockInterruptibly() throws InterruptedException
   {
      acquire();
   }

   public Condition newCondition()
   {
      throw new UnsupportedOperationException();
   }

   public boolean tryLock()
   {
      return tryAcquire();
   }

   public boolean tryLock(long arg0, TimeUnit arg1) throws InterruptedException
   {
      return tryAcquire(arg0, arg1);
   }

   public void unlock()
   {
      release();
   }

}
