/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.Comments;
import org.jfree.xml.generator.model.MappingModel;

public class DescriptionModel {
    private ArrayList sources;
    private ArrayList classes = new ArrayList();
    private HashMap classesMap = new HashMap();
    private MappingModel mappingModel = new MappingModel();
    private Comments modelComments;
    private HashMap includeComments;

    public DescriptionModel() {
        this.sources = new ArrayList();
        this.includeComments = new HashMap();
    }

    public void addClassDescription(ClassDescription cd) {
        this.classesMap.put(cd.getObjectClass(), cd);
        if (!this.classes.contains(cd)) {
            this.classes.add(cd);
        }
    }

    public void addIncludeComment(String source, Comments comments) {
        this.includeComments.put(source, comments);
    }

    public void addSource(String source) {
        this.sources.add(source);
    }

    public ClassDescription get(int index) {
        return (ClassDescription)this.classes.get(index);
    }

    public ClassDescription get(Class key) {
        return (ClassDescription)this.classesMap.get(key);
    }

    public Comments getIncludeComment(String source) {
        return (Comments)this.includeComments.get(source);
    }

    public MappingModel getMappingModel() {
        return this.mappingModel;
    }

    public Comments getModelComments() {
        return this.modelComments;
    }

    public String[] getSources() {
        return this.sources.toArray(new String[this.sources.size()]);
    }

    public void prune() {
        ClassDescription[] cds = this.classes.toArray(new ClassDescription[0]);
        int i = 0;
        while (i < cds.length) {
            if (cds[i].isUndefined()) {
                this.removeClassDescription(cds[i]);
                Log.debug((Object)("Pruned: " + cds[i].getName()));
            }
            ++i;
        }
    }

    public void removeClassDescription(ClassDescription cd) {
        this.classesMap.remove(cd.getObjectClass());
        ((AbstractCollection)this.classes).remove(cd);
    }

    public void setModelComments(Comments modelComments) {
        Log.debug((Object)("Model: Comment set: " + modelComments));
        this.modelComments = modelComments;
    }

    public int size() {
        return this.classes.size();
    }
}

