/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.composer.output.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.composer.output.model.SearchResult;

/**
 * Parsers for Composer's output.
 */
public final class Parsers {

    private static final List<Parser> PARSERS = Arrays.<Parser>asList(
            new CliParser());

    private Parsers() {
    }

    public static List<SearchResult> parseSearch(String chunk) {
        for (Parser parser : PARSERS) {
            List<SearchResult> result = parser.parseSearch(chunk);
            if (result != null) {
                return result;
            }
        }
        return Collections.emptyList();
    }

}
