/* fixedDepthSearcher2.cc
 */
#include "osl/checkmate/fixedDepthSearcher2.h"
#include "osl/checkmate/fixedDepthSearcher2.tcc"
#include "osl/state/numEffectState.tcc"

const osl::checkmate::ProofDisproof 
osl::checkmate::FixedDepthSearcher2::
hasCheckmateMoveOfTurn(int depth, Move& best_move, PieceStand& proof_pieces)
{
  NumEffectState* state= &states[depth];
  if (state->getTurn() == BLACK)
    return hasCheckmateMove<BLACK>(depth, best_move, proof_pieces);
  else
    return hasCheckmateMove<WHITE>(depth, best_move, proof_pieces);
}

const osl::checkmate::ProofDisproof 
osl::checkmate::FixedDepthSearcher2::
hasCheckmateMoveOfTurn(int depth, Move& best_move)
{
  NumEffectState* state= &states[depth];
  if (state->getTurn() == BLACK)
    return hasCheckmateMove<BLACK>(depth, best_move);
  else
    return hasCheckmateMove<WHITE>(depth, best_move);
}

const osl::checkmate::ProofDisproof 
osl::checkmate::FixedDepthSearcher2::
hasCheckmateWithGuideOfTurn(int depth, Move& guide, PieceStand& proof_pieces)
{
  NumEffectState* state= &states[depth];
  if (state->getTurn() == BLACK)
    return hasCheckmateWithGuide<BLACK>(depth, guide, proof_pieces);
  else
    return hasCheckmateWithGuide<WHITE>(depth, guide, proof_pieces);
}

const osl::checkmate::ProofDisproof 
osl::checkmate::FixedDepthSearcher2::
hasEscapeMoveOfTurn(Move last_move, int depth)
{
  NumEffectState* state= &states[depth];
  if (state->getTurn() == BLACK)
    return hasEscapeMove<BLACK>(last_move, depth);
  else
    return hasEscapeMove<WHITE>(last_move, depth);
}

const osl::checkmate::ProofDisproof 
osl::checkmate::FixedDepthSearcher2::
hasEscapeByMoveOfTurn(Move next_move, int depth, 
		      Move& check_move, PieceStand& proof_pieces)
{
  NumEffectState* state= &states[depth];
  if (state->getTurn() == BLACK)
    return hasEscapeByMove<WHITE>(next_move, depth, check_move, proof_pieces);
  else
    return hasEscapeByMove<BLACK>(next_move, depth, check_move, proof_pieces);
}

const osl::checkmate::ProofDisproof 
osl::checkmate::FixedDepthSearcher2::
hasEscapeByMoveOfTurn(Move next_move, int depth)
{
  NumEffectState* state= &states[depth];
  if (state->getTurn() == BLACK)
    return hasEscapeByMove<WHITE>(next_move, depth);
  else
    return hasEscapeByMove<BLACK>(next_move, depth);
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
