/* alphaBetaPlayer.cc
 */
#include "osl/game_playing/alphaBetaPlayer.h"
#include "osl/game_playing/searchPlayer.tcc"
#include "osl/search/alphaBeta2.h"
#include "osl/search/alphaBeta3.h"
#include "osl/search/simpleHashTable.h"
#include "osl/eval/progressEval.h"
#include "osl/eval/pieceEval.h"
#include <iostream>

#ifndef MINIMAL
osl::game_playing::
AlphaBeta2ProgressEvalPlayer::AlphaBeta2ProgressEvalPlayer()
{
}

osl::game_playing::
AlphaBeta2ProgressEvalPlayer::~AlphaBeta2ProgressEvalPlayer()
{
}

osl::game_playing::ComputerPlayer* osl::game_playing::
AlphaBeta2ProgressEvalPlayer::clone() const 
{
  return cloneIt(*this);
}

const osl::search::MoveWithComment osl::game_playing::
AlphaBeta2ProgressEvalPlayer::searchWithSecondsForThisMove(const GameState& gs, const search::TimeAssigned& org)
{
  const MilliSeconds::Interval consumed
    = setUpTable(gs, pawnValueOfTurn<AlphaBeta2ProgressEval>(gs.state().getTurn()));
  const search::TimeAssigned msec(adjust(org, consumed));
  searcher.reset();
  try 
  {
    searcher.reset(new AlphaBeta2ProgressEval(gs.state(), *checkmate_ptr, table_ptr.get(),
					      *recorder_ptr));
  }
  catch (std::bad_alloc&)
  {
    std::cerr << "panic. allocation of AlphaBeta2 failed\n";
  }
  return SearchPlayer::search<AlphaBeta2ProgressEval>(gs, msec);
}

bool osl::game_playing::
AlphaBeta2ProgressEvalPlayer::isReasonableMove(const GameState& gs,
				   Move move, int pawn_sacrifice)
{
  setUpTable(gs, pawnValueOfTurn<AlphaBeta2ProgressEval>(gs.state().getTurn()));
  AlphaBeta2ProgressEval searcher(gs.state(), *checkmate_ptr, table_ptr.get(),
				  *recorder_ptr);  
  return SearchPlayer::isReasonableMoveBySearch(searcher, move, pawn_sacrifice);
}
#endif

/* ------------------------------------------------------------------------- */

osl::game_playing::
AlphaBeta2OpenMidEndingEvalPlayer::AlphaBeta2OpenMidEndingEvalPlayer()
{
}

osl::game_playing::
AlphaBeta2OpenMidEndingEvalPlayer::~AlphaBeta2OpenMidEndingEvalPlayer()
{
}

osl::game_playing::ComputerPlayer* osl::game_playing::
AlphaBeta2OpenMidEndingEvalPlayer::clone() const 
{
  return cloneIt(*this);
}

const osl::search::MoveWithComment osl::game_playing::
AlphaBeta2OpenMidEndingEvalPlayer::searchWithSecondsForThisMove(const GameState& gs, const search::TimeAssigned& org)
{
  const MilliSeconds::Interval consumed = setUpTable(gs, pawnValueOfTurn<AlphaBeta2OpenMidEndingEval>(gs.state().getTurn()));
  const search::TimeAssigned msec(adjust(org, consumed));
  searcher.reset();
  try 
  {
    searcher.reset(new AlphaBeta2OpenMidEndingEval(gs.state(), *checkmate_ptr, table_ptr.get(),
					  *recorder_ptr));
  }
  catch (std::bad_alloc&)
  {
    std::cerr << "panic. allocation of AlphaBeta2 failed\n";
  }
  return SearchPlayer::search<AlphaBeta2OpenMidEndingEval>(gs, msec);
}

const osl::search::MoveWithComment osl::game_playing::
AlphaBeta2OpenMidEndingEvalPlayer::analyzeWithSeconds(const GameState& gs, const search::TimeAssigned& org,
						      search::AlphaBeta2SharedRoot& out)
{
  const search::MoveWithComment
    result = searchWithSecondsForThisMove(gs, org);
  out = dynamic_cast<AlphaBeta2OpenMidEndingEval&>(*searcher).sharedRootInfo();
  return result;
}

bool osl::game_playing::
AlphaBeta2OpenMidEndingEvalPlayer::isReasonableMove(const GameState& gs,
				   Move move, int pawn_sacrifice)
{
  setUpTable(gs, pawnValueOfTurn<AlphaBeta2OpenMidEndingEval>(gs.state().getTurn()));
  AlphaBeta2OpenMidEndingEval searcher(gs.state(), *checkmate_ptr, table_ptr.get(),
				  *recorder_ptr);  
  return SearchPlayer::isReasonableMoveBySearch(searcher, move, pawn_sacrifice);
}

/* ------------------------------------------------------------------------- */

#ifndef MINIMAL
osl::game_playing::
AlphaBeta3OpenMidEndingEvalPlayer::AlphaBeta3OpenMidEndingEvalPlayer()
{
}

osl::game_playing::
AlphaBeta3OpenMidEndingEvalPlayer::~AlphaBeta3OpenMidEndingEvalPlayer()
{
}

osl::game_playing::ComputerPlayer* osl::game_playing::
AlphaBeta3OpenMidEndingEvalPlayer::clone() const 
{
  return cloneIt(*this);
}

const osl::search::MoveWithComment osl::game_playing::
AlphaBeta3OpenMidEndingEvalPlayer::searchWithSecondsForThisMove(const GameState& gs, const search::TimeAssigned& org)
{
  const MilliSeconds::Interval consumed = setUpTable(gs, pawnValueOfTurn<AlphaBeta3>(gs.state().getTurn()));
  const search::TimeAssigned msec(adjust(org, consumed));
  searcher.reset();
  try 
  {
    searcher.reset(new AlphaBeta3(gs.state(), *checkmate_ptr, table_ptr.get(),
				  *recorder_ptr));
  }
  catch (std::bad_alloc&)
  {
    std::cerr << "panic. allocation of AlphaBeta3 failed\n";
  }
  return SearchPlayer::search<AlphaBeta3>(gs, msec);
}

bool osl::game_playing::
AlphaBeta3OpenMidEndingEvalPlayer::isReasonableMove(const GameState& gs,
				   Move move, int pawn_sacrifice)
{
  setUpTable(gs, pawnValueOfTurn<AlphaBeta3>(gs.state().getTurn()));
  AlphaBeta3 searcher(gs.state(), *checkmate_ptr, table_ptr.get(),
				  *recorder_ptr);  
  return SearchPlayer::isReasonableMoveBySearch(searcher, move, pawn_sacrifice);
}
#endif
/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
