#ifndef _PIECE_VALUES_H
#define _PIECE_VALUES_H
#include "osl/piece.h"
#include "osl/misc/carray.h"
#include <iosfwd>

namespace osl
{
  namespace state
  {
    class SimpleState;
  } // namespace state
  
  namespace container
  {
    /**
     * 駒番号->intの配列. 局面に対する駒の価値など
     */
    class PieceValues : public CArray<int,Piece::SIZE>
    {
    public:
      PieceValues();
      ~PieceValues();
      
      int sum() const;
      void showValues(std::ostream&, const state::SimpleState&) const;
    };
  } // namespace container
  using container::PieceValues;
} // namespace osl
#endif // _PIECE_VALUES_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
