
// C++ header file partially generated from Ada using cproto.adb

extern "C" {

//----------------------------------------------------------------------------
// USER IO                                                                  --
//                                                                          --
// Part of TextTools                                                        --
// Designed and Programmed by Ken O. Burtch                                 --
//                                                                          --
//----------------------------------------------------------------------------
//                                                                          --
//                 Copyright (C) 1999-2002 Ken O. Burtch                    --
//                                                                          --
// This is free software;  you can  redistribute it  and/or modify it under --
// terms of the  GNU General Public License as published  by the Free Soft- --
// ware  Foundation;  either version 2,  or (at your option) any later ver- --
// sion.  This is distributed in the hope that it will be useful, but WITH- --
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
// for  more details.  You should have  received  a copy of the GNU General --
// Public License  distributed with this;  see file COPYING.  If not, write --
// to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
// MA 02111-1307, USA.                                                      --
//                                                                          --
// As a special exception,  if other files  instantiate  generics from this --
// unit, or you link  this unit with other files  to produce an executable, --
// this  unit  does not  by itself cause  the resulting  executable  to  be --
// covered  by the  GNU  General  Public  License.  This exception does not --
// however invalidate  any other reasons why  the executable file  might be --
// covered by the  GNU Public License.                                      --
//                                                                          --
// This is maintained at http://www.vaxxine.com/pegasoft                    --
//                                                                          --
//----------------------------------------------------------------------------
// Design notes:
//   1. Errors are only returned at startup and shutdown (with the
//      exception of constraint errors and the like.)
//   2. As much as possible, the package supports both logical and
//      real pen/text attributes.  Unless you really need to use the
//      actual attribute (eg. RGB), use the logical one (ColourName's).

// remind Ada that Common elaborates first


//-> Definitions of Important Control Characters
//
// These maybe represented by more than one key (see C sources)

const char null_key = 0;         // no keypress
const char left_key = 8;         // left arrow
const char right_key = 21;       // right arrow
const char up_key = 11;          // up key
const char down_key = 10;        // down key
const char home_key = 25;        // home key (& ctrl-y)
const char page_up_key = 16;     // page up (& ctrl-p)
const char page_down_key = 14;   // page up (& ctrl-n)
const char end_key = 5;          // end key (& ctrl-e)
const char clear_key = 24;       // clear (ctrl-x)
const char delete_key = 127;     // delete/backspace
const char copy_key = 2;         // copy key (& ctrl-b)
const char paste_key = 22;       // paste key (ctrl-v)
const char return_key = 13;      // ok
const char tab_key = 9;          // ok
const char back_key = 20;        // backtab (& ctrl-t)
const char help_key = 27;        // help key (F1/ESC)
const char macro_key = 1;        // do  mac (F2/ctrl-a)
const char redraw_key = 12;      // redraw scrn (ctr-l)
const char mark_key = 30;        // mark key (ctrl-r)
const char csearch_key = 29;     // fwd chr search (ctrl-])


//-> Error Codes
//
// (none, yet)


//-> Housekeeping
//
// LastError = error

extern void startup_userio( void );
extern void idle_userio( a_time_stamp idle_period );
extern void shutdown_userio( void );
extern void reset_userio( void );
// for Windows refresh desktop

extern void blue_background( int blue_on );
// Set the default background to blue or black.  On startup, it's
// blue.
// Errors: none

extern unsigned char is_blue_background( void );
// return whether background is blue or black
// Errors: none

//-> Terminal Info
//
// True device independance is difficult: these calls let you determine
// if the I/O devices support some general features.

typedef struct _a_display_info_rec {

                       // (eg. for vt-100)
unsigned int fields;   // count of number of fields (>=8)    (eg. 8)
int text_based;        // true if a text-based display    (eg. true)
unsigned int h_res;    // horizontal resolution           (eg.   80)
unsigned int v_res;    // vertical resolution             (eg.   24)
unsigned int c_res;    // R/G/B bits (0=N/A)              (eg.    0)
unsigned int p_len;    // length of the palette (0=N/A)   (eg.    0)
unsigned int d_buf;    // total number of display buffers (eg.    1)
unsigned int s_res;    // sound resolution (0=N/A)        (eg.    0)
unsigned int y_res;    // sound voices/channels (0=N/A)   (eg.    0)

} a_display_info_rec;

extern void get_display_info( a_display_info_rec *info );

typedef struct _an_input_info_rec {

                     // (eg for vt-100)
unsigned int fields; // count of number of fields (>=4) (eg. 4)
int has_keyboard;    // true if has active keyboard (eg.  true)
int has_direction;   // true if has direction device(eg. false)
int has_velocity;    // true if dir dev can do velocity (eg.false)
int has_locator;     // true if has locator device  (eg. false)

} an_input_info_rec;

extern void get_input_info( an_input_info_rec *info );

//-> Pen and Palette Attributes
//
// APenColourName is a shortform for a particular colour
// ARGBComponent is the percentage of a colour component
// APaletteEntryNumber is for access the colour palette

enum a_pen_colour_name {none, outline, scroll_back, scroll_thumb, therm_back, therm_fore, white, red, purple, green, blue, yellow, black};
typedef float a_rgbcomponent;
typedef unsigned int a_palette_colour;

// Setting the current pen colour
//extern void set_pen_colour( a_rgbcomponent red_c, a_rgbcomponent green_c, a_rgbcomponent blue_c );
extern void set_pen_colour( a_pen_colour_name name );
//extern void set_pen_colour( a_palette_colour colour );

// Setting palette colours (if device has palettes)
// extern void set_palette_colour( a_palette_colour colour, a_pen_colour_name name );
// extern void set_palette_colour( a_palette_colour colour, a_rgbcomponent red_c, a_rgbcomponent green_c, a_rgbcomponent blue_c );

// Getting the current pen colour
// extern void get_pen_colour( a_rgbcomponent *red_c, a_rgbcomponent *green_c, a_rgbcomponent *blue_c );
extern a_pen_colour_name get_pen_colour( void );
// extern a_palette_colour get_pen_colour( void );

// Getting palette colours (if device has palettes)
extern void get_palette_colour( a_palette_colour colour, a_rgbcomponent *red_c, a_palette_colour *green_c, a_palette_colour *blue_c );
// extern a_pen_colour_name get_palette_colour( a_palette_colour colour );
extern a_palette_colour find_palette_colour( a_rgbcomponent red_c, a_rgbcomponent green_c, a_rgbcomponent blue_c );

extern void get_pen_pos( int *x, int *y );
extern void get_pixel( int x, int y, a_rgbcomponent *red_c, a_rgbcomponent green_c, a_rgbcomponent blue_c );
extern void set_pen_size( points p );
extern points get_pen_size( void );

// Turtle Graphics

extern void set_pen_angle( float angle );
extern void change_pen_angle( float degrees );
extern float get_pen_angle( void );
extern void draw_forward( float dist );

//-> Text attributes
//
// TextStyles describe the type of text to be drawn

enum a_text_style {normal, bold, underline, italic, bold_underline, bold_italic, italic_underline, bold_italic_underline, success, failure, warning, status, citation, section_heading, sub_heading, heading, title, emphasis, input, marquee, headline, fine_print, defined_term, footnote, to_address, from_address, sub_script, super_script};

// Text Styles
extern void set_text_style( a_text_style style );
extern a_text_style get_text_style( void );

// Text Colour
extern void set_text_colour( a_pen_colour_name name );
extern a_pen_colour_name get_text_colour( void );

// Text Font
// extern void set_text_font( str255 font, unsigned int size = 0 );
// extern void set_text_font( str255_list._list fonts, unsigned int size = 0 );
// extern void get_text_font( str255 *font, unsigned int *size );
// extern void get_font_name_list( str255_list_list *the_list );
// extern void get_font_size_list( str255 font, str255_list_list *the_list );

// Text Sizes (always 1 pixel each for text screens)

// extern int get_text_height( char ch );
extern int get_text_height( str255 s );
// extern int get_text_width( char ch );
extern int get_text_width( str255 s );

//-> Sound Functions
//
// This is strickly a draft.

// typedef unsigned int a_voice;   // voice number
// typedef a_path_name a_sound;    // sound path
// typedef unsigned int a_song;    // song number

// Digital Sound
// extern void play_sound( a_sound sound );
// extern void play_sound( a_voice voice, a_sound sound, float angle = 0.0, float volume = 100.0, float freqchange = 0.0 );
// extern void stop_sound( a_voice voice );
// extern void stop_sounds( void );

// Songs
// extern void play_song( a_song song );
// extern void stop_song( void );

// Misc Functions
// extern a_voice get_free_voice( void );
// extern float get_master_volume( void );
// extern void set_master_volume( float volume );


//-> Misc I/O Functions
//
// BeepStyles describe the type of beep to be used

enum beep_styles {normal_beep, success_beep, failure_beep, warning_beep, status_beep, bad_input, hour_chime, quarter_chime1, quarter_chime2, quarter_chime3, alarm, new_mail, low_power, startup, shutdown};

extern void move_to_global( int x, int y );
extern void move_forward( float dist );
extern void beep( beep_styles style );
extern void Cls( void );
// Curses move/clrtobot
extern void flush_keys( void );
// Curses' flushinp
//procedure Refresh;                     -- Curses' refresh
//  pragma Import( C, Refresh, "Refresh" );


//-> Basic Input
//
// Modeled on three device types:
// 1. ASCII Input Device (eg. keyboard) -- required
// 2. Location Device    (eg. mouse)
// 3. Direction Device   (eg. joystick)
//
// On demand functions (avoids input event handling):
//
// Mouse location is especially useful

typedef float a_direction;   // 0 to 360 degrees
typedef float a_velocity;    // 0 to 100 percent

extern char keypress( int shortblock ); // get key, null if none; shortblock uses half-delay
extern void get_key( char *c );
// get key, wait if none
// extern void get_location( int *x, int *y );
// get mouse
// extern void get_direction( a_direction *direction, a_velocity *velocity );
// get joystick

//-> Input Event Handling
//
// Assumes that there is only one data entry stream and one locator
// stream (may represent the input of more than one device).  OS events
// handled by core_system's IPC.
//
// NullInput       - return with no wait on GetInput
// KeyInput        - given key was pressed
// HeldKeyInput    - give key is being held (may not be supported)
// DirectionInput  - direction and distance (eg. joystick)
// LocationInput   - a pair of coordinates (eg. change in mouse)
// ButtonDownInput - button being pressed (eg. mouse or joystick)
// ButtonUpInput   - button being released (eg. mouse or joystick)
// MoveInput       - mouse moved
// HeartBeatInput  - "application busy" event for screen savers, etc.
// UserInput       - user-defined event

enum an_input {null_input, key_input, held_key_input, direction_input, location_input, button_down_input, button_up_input, heart_beat_input, move_input, user_input};

struct key_input_rec {
   char key;
};

struct held_key_input_rec {
   char held_key;
};

struct direction_input_rec {
   a_direction direction;
   a_velocity  velocity;
};

struct location_input_rec {
   int x, y;
};

struct button_down_input_rec {
   int down_button;
   int down_location_x;
   int down_location_y;
};

struct button_up_input_rec {
   int up_button;
   int up_location_x;
   int up_location_y;
};

struct move_input_rec {
   int move_location_x;
   int move_location_y;
};

struct user_input_rec {
   long id;
};

typedef struct _an_input_record{
  unsigned char input_type;                         // type of input
  // an_input type (Ada optimizes the 4-byte enum down to 1 byte)
  a_time_stamp time_stamp;                          // time of the event
  union {
     struct key_input_rec key_data;                 // key typed
     struct held_key_input_rec held_key_data;       // key held
     struct direction_input_rec direction_data;     // dir/degrees
     struct location_input_rec location_data;       // location/grid
     struct button_down_input_rec button_down_data; // button pressed
     struct button_up_input_rec button_up_data;     // button released
     struct move_input_rec move_data;               // moved
     struct user_input_rec user_data;               // user defined
  };
} an_input_record;

enum a_response_time {blocking, erratic, instant };
// Wait Indefinitely for input
// Give up after a fraction of a sec.
// Give up immediately

// Dynamic Allocation
typedef an_input_record *an_input_ptr;
// pointer to an input event
// skipping Ada generic procedure instantiation
// of unchecked_deallocation
// extern void free( an_input_record, an_input_ptr );

// Standard Calls
extern void get_input( an_input_record *e, a_response_time response );
// tried change response to unsigned char
// tried removing default parameter in Ada
// extern void get_input( an_input_record *e, unsigned char response );
// Ada default is blocking, but defaults not allowed in C++ interface
extern void set_input( an_input_record *e, int usetime );
// Ada default is false, but defaults not allowed in C++ interface
extern void heart_beat( void );
// shorthand call for SetInput( SomeHeartBeatRec );
extern void set_input_string( str255 s );
// post string to input queue
extern void flush_input( void );
extern long get_input_length( void );
extern void wait_for( int ticks );
// wait, handling any input


//-> Text Output
//

//extern void draw( char * s );
//procedure Draw( s : str80 );
// extern void draw( str255 s, int fieldwidth, int elipsis = false );
extern void draw_edit( str255 s, int fieldwidth, int am );
extern void draw( str255 s );
// extern void draw( char c );
// extern void draw( int i );
// extern void draw( long l );
// extern void draw( float f );
extern void draw_ln( void );
extern void draw_cstring( const char *s );
// actually c_string * but C++ wants a cast so we'll do it this way

//- Error Output
//
// Work the same as Draw commands, but automatically position themselves
// on the screen and switch text style to normal for visibility.

// extern void draw_err( char * s );          // write a string
// extern void draw_err( int i );             // write an integer
// extern void draw_err( long l );            // write a long integer
// extern void draw_err( an_input_record i ); // dump an input record
extern void draw_errln( void );           // move to next free error line
extern void draw_cerr( const char *s );


//-> Basic Pen Drawing
//
// Works with the assumption of 80x24 grid.

// Line Drawing functions
extern void draw_line( int x1, int y1, int x2, int y2 );
extern void draw_horizontal_line( int x1, int x2, int y1 );
extern void draw_vertical_line( int y1, int y2, int x1 );

// Rectangle Drawing functions
extern void frame_rect( const a_rect *r );
extern void frame_rect_3d( const a_rect *r );
extern void framed_rect( const a_rect *r, a_pen_colour_name fore_colour, a_pen_colour_name back_colour );
extern void fill_rect( const a_rect *r, a_pen_colour_name colour );
extern void paint_rect( const a_rect *r );
extern void erase_rect( const a_rect *r );

// Circle/Oval drawing functions
// renamed procedure omitted: 
// extern void frame_oval( a_rect r );
// renamed procedure omitted: 
// extern void framed_oval( a_rect r, a_pen_colour_name fore_colour, [type] back_colour );
// renamed procedure omitted: 
// extern void fill_oval( a_rect r, a_pen_colour_name colour );
// renamed procedure omitted: 
// extern void paint_oval( a_rect r );
// renamed procedure omitted: 
// extern void erase_oval( a_rect r );


//-> Region Drawing functions
//
// For some future day when you can draw to all windows.

// typedef rect_list._list a_region;
// just a list of rectangles

// Region Allocation
// allocate
// deallocate
// renamed procedure omitted: 
// extern void clear_region( a_region *region );

// Defining Regions
// extern void set_rect_region( a_region *region, a_rect rect );

// Manipulating and Testing Regions

// extern void offset_region( a_region *region, int dx, [type] dy );
//procedure InsetRegion( region : in out ARegion );
// extern void in_region( int x, [type] y, a_region *region, int *result );
// extern void in_region( a_rect r, a_region *region, int *result );
// extern void in_region( a_region *r, [type] region, int *result );

// renamed procedure omitted: 
// extern void add_rect( a_region *region, a_rect r );
// extern void add_region( a_region *region, [type] region2add );
//procedure SubRegion( region, region2sub : in out ARegion );

// extern void set_clip_region( a_region *r );

//-> Pictures
//
typedef unsigned int a_picture_id;
const a_picture_id no_picture_id = 0;

// extern a_picture_id register_picture( str255 path );
//function  CopyPicture( id : APictureID ) return APictureID;
//procedure ClearPicture( id : APictureID ); 
//procedure InsetPicture( id : APictureID, dx, dy : integer );
// extern a_picture_id save_picture( str255 path, [type] title, a_rect bounds );
// extern void draw_picture( a_picture_id picture, a_rect bounds );
extern void screen_dump( void );

//-> Caching/Spooling support
//
// In part to support Curses' caching, and in part to allow clients in
// a client/server scenario to optimize their drawing.  On displays
// that don't use caching, has no effect.

extern void wait_to_reveal( void ); // enable spooling/caching
extern void reveal( void );         // spooling/caching complete
extern void reveal_now( void ); // forced revealing, no effect on reveal nesting


}
