/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-shell.h"

#include "mn-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "mn-shell.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include <libxml/tree.h>
#include "mn-properties-dialog.h"
#include "mn-util.h"
#include "mn-conf.h"
#include "mn-mailboxes.h"
#include "mn-about-dialog.h"
#include "mn-standard-message-view.h"
#include "mn-compact-message-view.h"
#include "mn-message.h"
#include "mn-stock.h"
#include "mn-locked-callback.h"

MNShell *mn_shell = NULL;

#line 45 "mn-shell.c"
static const GEnumValue _mn_shell_tooltip_mail_summary_values[] = {
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD", (char *)"standard" },
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT", (char *)"compact" },
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE", (char *)"none" },
	{ 0, NULL, NULL }
};

GType
mn_shell_tooltip_mail_summary_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNShellTooltipMailSummary", _mn_shell_tooltip_mail_summary_values);
	return type;
}

/* self casting macros */
#define SELF(x) MN_SHELL(x)
#define SELF_CONST(x) MN_SHELL_CONST(x)
#define IS_SELF(x) MN_IS_SHELL(x)
#define TYPE_SELF MN_TYPE_SHELL
#define SELF_CLASS(x) MN_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) MN_SHELL_GET_CLASS(x)

/* self typedefs */
typedef MNShell Self;
typedef MNShellClass SelfClass;

/* here are local prototypes */
static void mn_shell_class_init (MNShellClass * c) G_GNUC_UNUSED;
static void mn_shell_init (MNShell * self) G_GNUC_UNUSED;
static void ___2_mn_shell_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_init_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_always_display_icon_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_tooltip_mail_summary_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_open_latest_message_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_update_sensitivity (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_tooltip (MNShell * self) G_GNUC_UNUSED;
static int mn_shell_new_mailboxes_compare_cb (MNMailbox * a, MNMailbox * b) G_GNUC_UNUSED;
static GtkWidget * mn_shell_tooltip_section_new (GtkVBox ** vbox, const char * title) G_GNUC_UNUSED;
static void mn_shell_tooltip_text_section_new (GtkVBox ** vbox, const char * title, const char * text) G_GNUC_UNUSED;
static void mn_shell_open_latest_message (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_display_window (MNShell * self, GType type, GtkWidget ** ptr) G_GNUC_UNUSED;
static void mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_messages_changed_h mn_shell_messages_changed_h
#define self_mailbox_removed_h mn_shell_mailbox_removed_h
#define self_init_icon mn_shell_init_icon
#define self_notify_blink_on_errors_cb mn_shell_notify_blink_on_errors_cb
#define self_notify_always_display_icon_cb mn_shell_notify_always_display_icon_cb
#define self_notify_mail_reader_cb mn_shell_notify_mail_reader_cb
#define self_notify_tooltip_mail_summary_cb mn_shell_notify_tooltip_mail_summary_cb
#define self_icon_activate_h mn_shell_icon_activate_h
#define self_icon_activate_mail_reader_h mn_shell_icon_activate_mail_reader_h
#define self_icon_activate_open_latest_message_h mn_shell_icon_activate_open_latest_message_h
#define self_icon_activate_update_h mn_shell_icon_activate_update_h
#define self_icon_activate_properties_h mn_shell_icon_activate_properties_h
#define self_icon_activate_help_h mn_shell_icon_activate_help_h
#define self_icon_activate_about_h mn_shell_icon_activate_about_h
#define self_icon_activate_remove_h mn_shell_icon_activate_remove_h
#define self_icon_destroy_h mn_shell_icon_destroy_h
#define self_update_sensitivity mn_shell_update_sensitivity
#define self_update_icon mn_shell_update_icon
#define self_update_tooltip mn_shell_update_tooltip
#define self_new_mailboxes_compare_cb mn_shell_new_mailboxes_compare_cb
#define self_tooltip_section_new mn_shell_tooltip_section_new
#define self_tooltip_text_section_new mn_shell_tooltip_text_section_new
#define self_open_latest_message mn_shell_open_latest_message
#define self_new mn_shell_new
#define self_display_properties_dialog mn_shell_display_properties_dialog
#define self_display_about_dialog mn_shell_display_about_dialog
#define self_display_window mn_shell_display_window
#define self_add_mailbox_properties_dialog mn_shell_add_mailbox_properties_dialog
#define self_mailbox_properties_dialog_weak_notify_cb mn_shell_mailbox_properties_dialog_weak_notify_cb
#define self_get_mailbox_properties_dialog mn_shell_get_mailbox_properties_dialog
#define self_get_summary mn_shell_get_summary
GType
mn_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNShell *)g_object_new(mn_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNShell *
GET_NEW_VARG (const char *first, ...)
{
	MNShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNShell *)g_object_new_valist (mn_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::dispose"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 58 "mn-shell.gob"
	if(self->mailboxes) { g_object_unref ((gpointer) self->mailboxes); self->mailboxes = NULL; }
#line 192 "mn-shell.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 97 "mn-shell.gob"
	___2_mn_shell_finalize(obj_self);
#line 205 "mn-shell.c"
}
#undef __GOB_FUNCTION__

static void 
mn_shell_class_init (MNShellClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 97 "mn-shell.gob"
	g_object_class->finalize = ___finalize;
#line 221 "mn-shell.c"
	g_object_class->dispose = ___dispose;
}
#undef __GOB_FUNCTION__
#line 68 "mn-shell.gob"
static void 
mn_shell_init (MNShell * self G_GNUC_UNUSED)
#line 228 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_SHELL,MNShellPrivate);
#line 58 "mn-shell.gob"
	self->mailboxes = mn_mailboxes_new();
#line 234 "mn-shell.c"
 {
#line 69 "mn-shell.gob"

    g_assert(mn_shell == NULL);

    mn_shell = self;
    eel_add_weak_pointer(&mn_shell);

    self_init_icon(self);

    mn_g_object_gconf_notifications_add_gdk_locked(self,
						   MN_CONF_BLINK_ON_ERRORS, self_notify_blink_on_errors_cb, self,
						   MN_CONF_ALWAYS_DISPLAY_ICON, self_notify_always_display_icon_cb, self,
						   MN_CONF_GNOME_MAIL_READER_NAMESPACE, self_notify_mail_reader_cb, self,
						   MN_CONF_TOOLTIP_MAIL_SUMMARY, self_notify_tooltip_mail_summary_cb, self,
						   NULL);

    g_object_connect(self->mailboxes,
		     "signal::messages-changed", self_messages_changed_h, self,
		     "signal::mailbox-removed", self_mailbox_removed_h, self,
		     "swapped-signal::notify::poll", self_update_sensitivity, self,
		     "swapped-signal::list-changed", self_update_tooltip, self,
		     "swapped-signal::list-changed", self_update_icon, self,
		     "swapped-signal::error-changed", self_update_tooltip, self,
		     "swapped-signal::error-changed", self_update_icon, self,
		     NULL);

    self->popups = mn_popups_new();
  
#line 264 "mn-shell.c"
 }
}
#undef __GOB_FUNCTION__



#line 97 "mn-shell.gob"
static void 
___2_mn_shell_finalize (GObject * object G_GNUC_UNUSED)
#line 274 "mn-shell.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
{
#line 99 "mn-shell.gob"
	
    gtk_main_quit();
    PARENT_HANDLER(object);
  }}
#line 286 "mn-shell.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 104 "mn-shell.gob"
static void 
mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data)
#line 293 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::messages_changed_h"
{
#line 108 "mn-shell.gob"
	
    Self *self = user_data;

    if (mn_conf_has_command(MN_CONF_COMMANDS_MAIL_CHANGED_NAMESPACE))
      mn_conf_execute_command(MN_CONF_COMMANDS_MAIL_CHANGED_COMMAND);

    if (has_new)
      {
	if (mn_conf_has_command(MN_CONF_COMMANDS_NEW_MAIL_NAMESPACE))
	  mn_conf_execute_command(MN_CONF_COMMANDS_NEW_MAIL_COMMAND);
      }

    self_update_sensitivity(self);
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 314 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 125 "mn-shell.gob"
static void 
mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data)
#line 320 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_removed_h"
{
#line 129 "mn-shell.gob"
	
    Self *self = user_data;
    MNMailboxPropertiesDialog *dialog;

    /* destroy the associated properties dialog, if any */
    dialog = self_get_mailbox_properties_dialog(self, mailbox);
    if (dialog)
      gtk_widget_destroy(GTK_WIDGET(dialog));
  }}
#line 334 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 139 "mn-shell.gob"
static void 
mn_shell_init_icon (MNShell * self)
#line 340 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init_icon"
#line 139 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 139 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 347 "mn-shell.c"
{
#line 141 "mn-shell.gob"
	
    self->icon = MN_MAIL_ICON(mn_mail_icon_new());

    g_object_connect(self->icon,
		     "signal::activate", self_icon_activate_h, self,
		     "signal::activate-mail-reader", self_icon_activate_mail_reader_h, self,
		     "signal::activate-open-latest-message", self_icon_activate_open_latest_message_h, self,
		     "signal::activate-update", self_icon_activate_update_h, self,
		     "signal::activate-properties", self_icon_activate_properties_h, self,
		     "signal::activate-help", self_icon_activate_help_h, self,
		     "signal::activate-about", self_icon_activate_about_h, self,
		     "signal::activate-remove", self_icon_activate_remove_h, self,
		     "signal::destroy", self_icon_destroy_h, self,
		     NULL);

    self_update_sensitivity(self);
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 369 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 161 "mn-shell.gob"
static void 
mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 375 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_blink_on_errors_cb"
{
#line 166 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_icon(self);
  }}
#line 385 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 172 "mn-shell.gob"
static void 
mn_shell_notify_always_display_icon_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 391 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_always_display_icon_cb"
{
#line 177 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_icon(self);
  }}
#line 401 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 183 "mn-shell.gob"
static void 
mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 407 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_mail_reader_cb"
{
#line 188 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_sensitivity(self);
  }}
#line 417 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 194 "mn-shell.gob"
static void 
mn_shell_notify_tooltip_mail_summary_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 423 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_tooltip_mail_summary_cb"
{
#line 199 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_tooltip(self);
  }}
#line 433 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 205 "mn-shell.gob"
static void 
mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data)
#line 439 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_h"
{
#line 207 "mn-shell.gob"
	
    MNShell *self = user_data;
    MNAction action;

    action = mn_conf_get_enum_value(MN_TYPE_ACTION, MN_CONF_CLICK_ACTION);

    switch (action)
      {
      case MN_ACTION_DISPLAY_PROPERTIES_DIALOG:
	self_display_properties_dialog(self);
	break;

      case MN_ACTION_LAUNCH_MAIL_READER:
	if (mn_conf_has_command(MN_CONF_GNOME_MAIL_READER_NAMESPACE))
	  mn_conf_execute_mail_reader();
	else
	  mn_error_dialog_with_markup(NULL,
				      _("No mail reader is configured"),
				      _("You can configure a mail reader by choosing <b>System → Preferences → Preferred Applications</b>."));
	break;

      case MN_ACTION_OPEN_LATEST_MESSAGE:
	if (self->mailboxes->messages)
	  {
	    MNMessage *message = self->mailboxes->messages->data;
	    if (mn_message_can_open(message))
	      self_open_latest_message(self);
	    else
	      mn_error_dialog(NULL,
			      _("Unable to open the latest message"),
			      _("Messages of mailbox \"%s\" cannot be opened."),
			      message->mailbox->runtime_name);
	  }
	else
	  mn_error_dialog(NULL,
			  _("Unable to open the latest message"),
			  _("You have no new mail."));
	break;

      case MN_ACTION_UPDATE_MAIL_STATUS:
	mn_mailboxes_check(self->mailboxes);
	break;

      default:
	g_assert_not_reached();
      }
  }}
#line 491 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 255 "mn-shell.gob"
static void 
mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data)
#line 497 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_mail_reader_h"
{
#line 257 "mn-shell.gob"
	
    mn_conf_execute_mail_reader();
  }}
#line 505 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 261 "mn-shell.gob"
static void 
mn_shell_icon_activate_open_latest_message_h (MNMailIcon * icon, gpointer user_data)
#line 511 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_open_latest_message_h"
{
#line 263 "mn-shell.gob"
	
    Self *self = user_data;
    self_open_latest_message(self);
  }}
#line 520 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 268 "mn-shell.gob"
static void 
mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data)
#line 526 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_update_h"
{
#line 270 "mn-shell.gob"
	
    Self *self = user_data;
    mn_mailboxes_check(self->mailboxes);
  }}
#line 535 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 275 "mn-shell.gob"
static void 
mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data)
#line 541 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_properties_h"
{
#line 277 "mn-shell.gob"
	
    Self *self = user_data;
    self_display_properties_dialog(self);
  }}
#line 550 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 282 "mn-shell.gob"
static void 
mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data)
#line 556 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_help_h"
{
#line 284 "mn-shell.gob"
	
    mn_display_help(NULL, NULL);
  }}
#line 564 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 288 "mn-shell.gob"
static void 
mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data)
#line 570 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_about_h"
{
#line 290 "mn-shell.gob"
	
    Self *self = user_data;
    self_display_about_dialog(self);
  }}
#line 579 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 295 "mn-shell.gob"
static void 
mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data)
#line 585 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_remove_h"
{
#line 297 "mn-shell.gob"
	
    Self *self = user_data;
    g_object_unref(self);
  }}
#line 594 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 302 "mn-shell.gob"
static void 
mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data)
#line 600 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_destroy_h"
{
#line 304 "mn-shell.gob"
	
    Self *self = user_data;

    /* The Notification Area applet has been terminated. Recreate the icon. */
    self_init_icon(self);
  }}
#line 611 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 311 "mn-shell.gob"
static void 
mn_shell_update_sensitivity (MNShell * self)
#line 617 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_sensitivity"
#line 311 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 311 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 624 "mn-shell.c"
{
#line 313 "mn-shell.gob"
	
    gtk_widget_set_sensitive(self->icon->mail_reader_item, mn_conf_has_command(MN_CONF_GNOME_MAIL_READER_NAMESPACE));
    gtk_widget_set_sensitive(self->icon->open_latest_message_item, self->mailboxes->messages && mn_message_can_open(self->mailboxes->messages->data));
    gtk_widget_set_sensitive(self->icon->update_item, mn_mailboxes_get_poll(self->mailboxes));
  }}
#line 632 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 319 "mn-shell.gob"
static void 
mn_shell_update_icon (MNShell * self)
#line 638 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_icon"
#line 319 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 319 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 645 "mn-shell.c"
{
#line 321 "mn-shell.gob"
	
    GList *l;
    gboolean has_new = FALSE;
    gboolean blink = FALSE;
    gboolean always = eel_gconf_get_boolean(MN_CONF_ALWAYS_DISPLAY_ICON);

    MN_LIST_FOREACH(l, self->mailboxes->list)
      {
	MNMailbox *mailbox = l->data;

	if (mailbox->messages)
	  has_new = TRUE;
	if (mailbox->error)
	  blink = TRUE;
      }

    if (selfp->has_new && ! has_new && mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READ_NAMESPACE))
      mn_conf_execute_command(MN_CONF_COMMANDS_MAIL_READ_COMMAND);
    selfp->has_new = has_new;

    if (blink && ! eel_gconf_get_boolean(MN_CONF_BLINK_ON_ERRORS))
      blink = FALSE;

    if (has_new || blink || always)
      {
	mn_blinking_image_set_from_stock(MN_BLINKING_IMAGE(self->icon->image),
					 has_new ? MN_STOCK_MAIL : MN_STOCK_NO_MAIL,
					 GTK_ICON_SIZE_LARGE_TOOLBAR);
	mn_blinking_image_set_blinking(MN_BLINKING_IMAGE(self->icon->image),
				       blink);
	gtk_widget_show(GTK_WIDGET(self->icon));
      }
    else
      gtk_widget_hide(GTK_WIDGET(self->icon));
  }}
#line 683 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 357 "mn-shell.gob"
static void 
mn_shell_update_tooltip (MNShell * self)
#line 689 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_tooltip"
#line 357 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 357 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 696 "mn-shell.c"
{
#line 359 "mn-shell.gob"
	
    GtkVBox *vbox = NULL;

    if (self->mailboxes->list)
      {
	GList *la;
	GSList *lb;
	GSList *new_mailboxes = NULL;
	GSList *error_mailboxes = NULL;

	MN_LIST_FOREACH(la, self->mailboxes->list)
          {
	    MNMailbox *mailbox = la->data;

	    if (mailbox->messages)
	      new_mailboxes = g_slist_insert_sorted(new_mailboxes, mailbox, (GCompareFunc) self_new_mailboxes_compare_cb);

	    if (mailbox->error)
	      error_mailboxes = g_slist_insert_sorted(error_mailboxes, mailbox, mn_mailboxes_compare_by_name_func);
	  }

	if (new_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    MN_LIST_FOREACH(lb, new_mailboxes)
	      {
		MNMailbox *mailbox = lb->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append(string, mailbox->runtime_name);

		if (mailbox->n_messages > 0)
		  g_string_append_printf(string, " (%i)", mailbox->n_messages);
	      }
	    g_slist_free(new_mailboxes);

	    /* translators: header capitalization */
	    self_tooltip_text_section_new(&vbox, _("Mailboxes Having New Mail"), string->str);
	    g_string_free(string, TRUE);
	  }

	if (error_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    MN_LIST_FOREACH(lb, error_mailboxes)
	      {
		MNMailbox *mailbox = lb->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append_printf(string, "%s: %s", mailbox->runtime_name, mailbox->error);
	      }
	    g_slist_free(error_mailboxes);

	    /* translators: header capitalization */
	    self_tooltip_text_section_new(&vbox, _("Errors"), string->str);
	    g_string_free(string, TRUE);
	  }
      }

    if (self->mailboxes->messages)
      {
	MNShellTooltipMailSummary mail_summary;

	mail_summary = mn_conf_get_enum_value(MN_TYPE_SHELL_TOOLTIP_MAIL_SUMMARY, MN_CONF_TOOLTIP_MAIL_SUMMARY);
	if (mail_summary != MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE)
	  {
	    GtkWidget *alignment;
	    GtkWidget *message_view;

	    /* translators: header capitalization */
	    alignment = self_tooltip_section_new(&vbox, _("Mail Summary"));

	    switch (mail_summary)
	      {
	      case MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD:
		message_view = mn_standard_message_view_new();
		break;

	      case MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT:
		message_view = mn_compact_message_view_new();
		break;

	      default:
		g_assert_not_reached();
		break;
	      }

	    gtk_widget_set_name(message_view, "mn-message-view");
	    mn_message_view_set_messages(MN_MESSAGE_VIEW(message_view), self->mailboxes->messages);
	    gtk_container_add(GTK_CONTAINER(alignment), message_view);
	  }
      }

    if (vbox)
      {
	gtk_widget_show_all(GTK_WIDGET(vbox));
	mn_mail_icon_set_tip_widget(self->icon, GTK_WIDGET(vbox));
      }
    else
      mn_mail_icon_set_tip(self->icon, _("You have no new mail."));
  }}
#line 804 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 465 "mn-shell.gob"
static int 
mn_shell_new_mailboxes_compare_cb (MNMailbox * a, MNMailbox * b)
#line 810 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new_mailboxes_compare_cb"
{
#line 467 "mn-shell.gob"
	
    int cmp;

    /* sort by timestamp (descending order) */
    cmp = b->timestamp - a->timestamp;
    /* else sort by number of messages (descending order) */
    if (cmp == 0)
      {
	cmp = b->n_messages - a->n_messages;
	/* else sort by name (ascending order) */
	if (cmp == 0)
	  cmp = mn_mailboxes_compare_by_name_func(a, b);
      }

    return cmp;
  }}
#line 831 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 484 "mn-shell.gob"
static GtkWidget * 
mn_shell_tooltip_section_new (GtkVBox ** vbox, const char * title)
#line 837 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_section_new"
#line 484 "mn-shell.gob"
	g_return_val_if_fail (vbox != NULL, (GtkWidget * )0);
#line 484 "mn-shell.gob"
	g_return_val_if_fail (title != NULL, (GtkWidget * )0);
#line 844 "mn-shell.c"
{
#line 487 "mn-shell.gob"
	
    GtkWidget *section;
    GtkWidget *label;
    GtkWidget *alignment;

    if (! *vbox)
      *vbox = GTK_VBOX(gtk_vbox_new(FALSE, 18));

    section = mn_hig_section_new(title, &label, &alignment);

    gtk_widget_set_name(label, "mn-tooltip-section-title");

    gtk_box_pack_start(GTK_BOX(*vbox), section, TRUE, TRUE, 0);

    return alignment;
  }}
#line 863 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 504 "mn-shell.gob"
static void 
mn_shell_tooltip_text_section_new (GtkVBox ** vbox, const char * title, const char * text)
#line 869 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_text_section_new"
#line 504 "mn-shell.gob"
	g_return_if_fail (vbox != NULL);
#line 504 "mn-shell.gob"
	g_return_if_fail (title != NULL);
#line 504 "mn-shell.gob"
	g_return_if_fail (text != NULL);
#line 878 "mn-shell.c"
{
#line 508 "mn-shell.gob"
	
    GtkWidget *alignment;
    GtkWidget *label;

    alignment = self_tooltip_section_new(vbox, title);

    label = gtk_label_new(text);
    gtk_widget_set_name(label, "mn-tooltip-section-body");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

    gtk_container_add(GTK_CONTAINER(alignment), label);
  }}
#line 893 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 521 "mn-shell.gob"
static void 
mn_shell_open_latest_message (MNShell * self)
#line 899 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::open_latest_message"
#line 521 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 521 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 906 "mn-shell.c"
{
#line 523 "mn-shell.gob"
	
    MNMessage *message;
    GError *err = NULL;

    g_return_if_fail(self->mailboxes->messages != NULL);

    message = self->mailboxes->messages->data;
    g_return_if_fail(mn_message_can_open(message));

    if (! mn_message_open(message, &err))
      {
	mn_error_dialog(NULL, _("Unable to open the latest message"), "%s", err->message);
	g_error_free(err);
      }
  }}
#line 924 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 539 "mn-shell.gob"
MNShell * 
mn_shell_new (void)
#line 930 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new"
{
#line 541 "mn-shell.gob"
	
    return GET_NEW;
  }}
#line 938 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 545 "mn-shell.gob"
void 
mn_shell_display_properties_dialog (MNShell * self)
#line 944 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_properties_dialog"
#line 545 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 545 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 951 "mn-shell.c"
{
#line 547 "mn-shell.gob"
	
    self_display_window(self, MN_TYPE_PROPERTIES_DIALOG, &selfp->properties_dialog);
  }}
#line 957 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 551 "mn-shell.gob"
void 
mn_shell_display_about_dialog (MNShell * self)
#line 963 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_about_dialog"
#line 551 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 551 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 970 "mn-shell.c"
{
#line 553 "mn-shell.gob"
	
    self_display_window(self, MN_TYPE_ABOUT_DIALOG, &selfp->about_dialog);
  }}
#line 976 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 557 "mn-shell.gob"
static void 
mn_shell_display_window (MNShell * self, GType type, GtkWidget ** ptr)
#line 982 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_window"
#line 557 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 557 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 557 "mn-shell.gob"
	g_return_if_fail (type != 0);
#line 557 "mn-shell.gob"
	g_return_if_fail (ptr != NULL);
#line 993 "mn-shell.c"
{
#line 561 "mn-shell.gob"
	
    if (*ptr)
      {
	gtk_window_present(GTK_WINDOW(*ptr));
	return;
      }

    *ptr = g_object_new(type, NULL);
    eel_add_weak_pointer(ptr);

    gtk_widget_show(*ptr);
  }}
#line 1008 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 574 "mn-shell.gob"
void 
mn_shell_add_mailbox_properties_dialog (MNShell * self, MNMailboxPropertiesDialog * dialog)
#line 1014 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::add_mailbox_properties_dialog"
#line 574 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 574 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 574 "mn-shell.gob"
	g_return_if_fail (dialog != NULL);
#line 574 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (dialog));
#line 1025 "mn-shell.c"
{
#line 576 "mn-shell.gob"
	
    selfp->mailbox_properties_dialogs = g_slist_append(selfp->mailbox_properties_dialogs, dialog);
    g_object_weak_ref(G_OBJECT(dialog), self_mailbox_properties_dialog_weak_notify_cb, self);
  }}
#line 1032 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 581 "mn-shell.gob"
static void 
mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object)
#line 1038 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_properties_dialog_weak_notify_cb"
{
#line 584 "mn-shell.gob"
	
    Self *self = data;

    selfp->mailbox_properties_dialogs = g_slist_remove(selfp->mailbox_properties_dialogs, former_object);
  }}
#line 1048 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 590 "mn-shell.gob"
MNMailboxPropertiesDialog * 
mn_shell_get_mailbox_properties_dialog (MNShell * self, MNMailbox * mailbox)
#line 1054 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::get_mailbox_properties_dialog"
#line 590 "mn-shell.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxPropertiesDialog * )0);
#line 590 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (MNMailboxPropertiesDialog * )0);
#line 590 "mn-shell.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMailboxPropertiesDialog * )0);
#line 590 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMailboxPropertiesDialog * )0);
#line 1065 "mn-shell.c"
{
#line 592 "mn-shell.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->mailbox_properties_dialogs)
      {
	MNMailboxPropertiesDialog *dialog = l->data;
	MNMailbox *this_mailbox;
	gboolean found;

	this_mailbox = mn_mailbox_properties_dialog_get_mailbox(dialog);
	found = this_mailbox == mailbox;
	g_object_unref(this_mailbox);

	if (found)
	  return dialog;
      }

    return NULL;
  }}
#line 1087 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 612 "mn-shell.gob"
char * 
mn_shell_get_summary (MNShell * self)
#line 1093 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::get_summary"
#line 612 "mn-shell.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 612 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (char * )0);
#line 1100 "mn-shell.c"
{
#line 614 "mn-shell.gob"
	
    int indent;
    xmlDoc *doc;
    xmlNode *root;
    GSList *l;
    xmlChar *summary;

    indent = xmlIndentTreeOutput;
    xmlIndentTreeOutput = 1;

    doc = xmlNewDoc("1.0");
    root = xmlNewNode(NULL, "messages");
    xmlDocSetRootElement(doc, root);

    MN_LIST_FOREACH(l, self->mailboxes->messages)
      {
	MNMessage *message = l->data;
	xmlNode *node;

	node = mn_message_xml_node_new(message);
	xmlAddChild(root, node); /* owns node */
      }

    xmlDocDumpFormatMemory(doc, &summary, NULL, 1);

    xmlFreeDoc(doc);
    xmlIndentTreeOutput = indent;

    return summary;
  }}
#line 1133 "mn-shell.c"
#undef __GOB_FUNCTION__
static const GEnumValue _mn_action_values[] = {
	{ MN_ACTION_DISPLAY_PROPERTIES_DIALOG, (char *)"MN_ACTION_DISPLAY_PROPERTIES_DIALOG", (char *)"display-properties-dialog" },
	{ MN_ACTION_LAUNCH_MAIL_READER, (char *)"MN_ACTION_LAUNCH_MAIL_READER", (char *)"launch-mail-reader" },
	{ MN_ACTION_OPEN_LATEST_MESSAGE, (char *)"MN_ACTION_OPEN_LATEST_MESSAGE", (char *)"open-latest-message" },
	{ MN_ACTION_UPDATE_MAIL_STATUS, (char *)"MN_ACTION_UPDATE_MAIL_STATUS", (char *)"update-mail-status" },
	{ 0, NULL, NULL }
};

GType
mn_action_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAction", _mn_action_values);
	return type;
}

static const GEnumValue _mn_expiration_enabled_values[] = {
	{ MN_EXPIRATION_ENABLED_DEFAULT, (char *)"MN_EXPIRATION_ENABLED_DEFAULT", (char *)"default" },
	{ MN_EXPIRATION_ENABLED_FALSE, (char *)"MN_EXPIRATION_ENABLED_FALSE", (char *)"false" },
	{ MN_EXPIRATION_ENABLED_TRUE, (char *)"MN_EXPIRATION_ENABLED_TRUE", (char *)"true" },
	{ 0, NULL, NULL }
};

GType
mn_expiration_enabled_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNExpirationEnabled", _mn_expiration_enabled_values);
	return type;
}

static const GEnumValue _mn_popup_position_values[] = {
	{ MN_POPUP_POSITION_ATTACHED, (char *)"MN_POPUP_POSITION_ATTACHED", (char *)"attached" },
	{ MN_POPUP_POSITION_FREE, (char *)"MN_POPUP_POSITION_FREE", (char *)"free" },
	{ 0, NULL, NULL }
};

GType
mn_popup_position_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPopupPosition", _mn_popup_position_values);
	return type;
}

